/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.utils;

import java.util.Collection;
import java.util.Map;
import org.hellojavaer.ddal.ddr.utils.DDRJSONUtils;

public class DDRToStringBuilder {
    private StringBuilder sb = new StringBuilder("{");
    private int count = 0;

    public DDRToStringBuilder append(String name, Object val) {
        if (name == null) {
            this.sb.append("null");
            this.sb.append(":");
        } else {
            this.sb.append('\"');
            this.sb.append(name);
            this.sb.append("\":");
        }
        if (val == null) {
            this.sb.append("null");
        } else if (val instanceof String || val instanceof Character) {
            this.sb.append('\"');
            this.sb.append(val);
            this.sb.append('\"');
        } else if (val instanceof Collection) {
            this.sb.append(DDRJSONUtils.toJSONString((Collection)val));
        } else if (val instanceof Map) {
            this.sb.append(DDRJSONUtils.toJSONString((Map)val));
        } else {
            this.sb.append(val);
        }
        this.sb.append(',');
        ++this.count;
        return this;
    }

    public String toString() {
        if (this.count > 0) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        this.sb.append('}');
        String temp = this.sb.toString();
        this.sb.deleteCharAt(this.sb.length() - 1);
        if (this.count > 0) {
            this.sb.append(',');
        }
        return temp;
    }
}

