/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.shard.rule;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hellojavaer.ddal.ddr.expression.el.function.ELFunctionManager;
import org.hellojavaer.ddal.ddr.shard.RangeShardValue;
import org.hellojavaer.ddal.ddr.shard.ShardRouteInfo;
import org.hellojavaer.ddal.ddr.shard.ShardRouteRule;
import org.hellojavaer.ddal.ddr.shard.exception.CrossTableException;
import org.hellojavaer.ddal.ddr.shard.exception.ExpressionValueNotFoundException;
import org.hellojavaer.ddal.ddr.shard.exception.OutOfRangeSizeLimitException;
import org.hellojavaer.ddal.ddr.utils.DDRToStringBuilder;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ReflectionUtils;

public class SpelShardRouteRule
implements ShardRouteRule {
    private String scRouteRule;
    private String tbRouteRule;
    private Integer rangeSizeLimit;
    private Expression scRouteRuleExpression;
    private Expression tbRouteRuleExpression;
    private static final Set<String> RESERVED_WORDS = new HashSet<String>();
    private static final TypedValue rootObject;
    private static final List<PropertyAccessor> propertyAccessors;
    private static final List<MethodResolver> methodResolvers;
    private static final ParserContext PARSER_CONTEXT;

    private SpelShardRouteRule() {
    }

    public SpelShardRouteRule(String scRouteRule, String tbRouteRule) {
        this.setScRouteRule(scRouteRule);
        this.setTbRouteRule(tbRouteRule);
    }

    public SpelShardRouteRule(String scRouteRule, String tbRouteRule, Integer rangeSizeLimit) {
        this.scRouteRule = scRouteRule;
        this.tbRouteRule = tbRouteRule;
        this.rangeSizeLimit = rangeSizeLimit;
    }

    public void setScRouteRule(String scRouteRule) {
        this.scRouteRule = scRouteRule = this.filter(scRouteRule);
        if (scRouteRule != null) {
            SpelExpressionParser parser = new SpelExpressionParser();
            this.scRouteRuleExpression = parser.parseExpression(scRouteRule, PARSER_CONTEXT);
        }
    }

    public String getScRouteRule() {
        return this.scRouteRule;
    }

    public void setTbRouteRule(String tbRouteRule) {
        this.tbRouteRule = tbRouteRule = this.filter(tbRouteRule);
        if (tbRouteRule != null) {
            SpelExpressionParser parser = new SpelExpressionParser();
            this.tbRouteRuleExpression = parser.parseExpression(tbRouteRule, PARSER_CONTEXT);
        }
    }

    public String getTbRouteRule() {
        return this.tbRouteRule;
    }

    public Integer getRangeSizeLimit() {
        return this.rangeSizeLimit;
    }

    public void setRangeSizeLimit(Integer rangeSizeLimit) {
        this.rangeSizeLimit = rangeSizeLimit;
    }

    private String filter(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String parseScName(String scName, Object sdValue) {
        if (this.scRouteRuleExpression == null) {
            return scName;
        }
        EvaluationContext elContext = SpelShardRouteRule.buildEvaluationContext(this.tbRouteRule);
        elContext.setVariable("scName", (Object)scName);
        return this.parseName(this.scRouteRuleExpression, elContext, sdValue);
    }

    @Override
    public String parseTbName(String tbName, Object sdValue) {
        if (this.tbRouteRuleExpression == null) {
            return tbName;
        }
        EvaluationContext elContext = SpelShardRouteRule.buildEvaluationContext(this.tbRouteRule);
        elContext.setVariable("tbName", (Object)tbName);
        return this.parseName(this.tbRouteRuleExpression, elContext, sdValue);
    }

    @Override
    public Map<ShardRouteInfo, List<RangeShardValue>> groupSdValuesByRouteInfo(String scName, String tbName, RangeShardValue rangeShardValue) {
        Long begin = rangeShardValue.getBegin();
        Long end = rangeShardValue.getEnd();
        if (begin == null || end == null) {
            throw new IllegalArgumentException("rangeShardValue.begin and rangeShardValue.end can't be null");
        }
        if (begin > end) {
            throw new IllegalArgumentException("rangeShardValue.begin can't be greater than rangeShardValue.end");
        }
        if (this.rangeSizeLimit != null && end - begin + 1L > (long)this.rangeSizeLimit.intValue()) {
            throw new OutOfRangeSizeLimitException(end - begin + " > " + this.rangeSizeLimit);
        }
        LinkedHashMap<ShardRouteInfo, List<RangeShardValue>> map = new LinkedHashMap<ShardRouteInfo, List<RangeShardValue>>();
        if (this.scRouteRuleExpression == null && this.tbRouteRuleExpression == null) {
            ArrayList<RangeShardValue> list = new ArrayList<RangeShardValue>(1);
            list.add(new RangeShardValue(begin, end));
            ShardRouteInfo routeInfo = new ShardRouteInfo(scName, tbName);
            map.put(routeInfo, list);
            return map;
        }
        for (long l = begin.longValue(); l <= end; ++l) {
            String scName0 = this.parseScName(scName, l);
            String tbName0 = this.parseTbName(tbName, l);
            ShardRouteInfo routeInfo = new ShardRouteInfo();
            routeInfo.setScName(scName0);
            routeInfo.setTbName(tbName0);
            ArrayList<RangeShardValue> rangeShardValues = (ArrayList<RangeShardValue>)map.get(routeInfo);
            if (rangeShardValues == null) {
                rangeShardValues = new ArrayList<RangeShardValue>();
                map.put(routeInfo, rangeShardValues);
            }
            rangeShardValues.add(new RangeShardValue(l, l));
        }
        return map;
    }

    protected String parseName(Expression expression, EvaluationContext elContext, Object sdValue) {
        if (expression == null) {
            throw new IllegalArgumentException("expression can't be null");
        }
        if (sdValue != null && sdValue instanceof RangeShardValue) {
            Long begin = ((RangeShardValue)sdValue).getBegin();
            Long end = ((RangeShardValue)sdValue).getEnd();
            if (begin == null || end == null) {
                throw new IllegalArgumentException("rangeShardValue.begin and rangeShardValue.end can't be null");
            }
            if (begin > end) {
                throw new IllegalArgumentException("rangeShardValue.begin can't be greater than rangeShardValue.end");
            }
            if (this.rangeSizeLimit != null && end - begin + 1L > (long)this.rangeSizeLimit.intValue()) {
                throw new OutOfRangeSizeLimitException(end - begin + " > " + this.rangeSizeLimit);
            }
            String result = null;
            for (long l = begin.longValue(); l <= end; ++l) {
                elContext.setVariable("sdValue", (Object)l);
                String temp = (String)expression.getValue(elContext, String.class);
                if (result != null && !result.equals(temp)) {
                    throw new CrossTableException(result + " and " + temp);
                }
                result = temp;
            }
            return result;
        }
        elContext.setVariable("sdValue", sdValue);
        return (String)expression.getValue(elContext, String.class);
    }

    public String toString() {
        return new DDRToStringBuilder().append("scRouteRule", this.scRouteRule).append("tbRouteRule", this.tbRouteRule).toString();
    }

    private static boolean isReservedWords(String str) {
        if (str == null) {
            return false;
        }
        return RESERVED_WORDS.contains(str);
    }

    private static EvaluationContext buildEvaluationContext(final String expression) {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject){

            public Object lookupVariable(String name) {
                Object val = null;
                if (SpelShardRouteRule.isReservedWords(name)) {
                    val = super.lookupVariable(name);
                    if (val == null) {
                        throw new ExpressionValueNotFoundException("Value of '" + name + "' is not found when parsing expression '" + expression + "'");
                    }
                } else {
                    val = ELFunctionManager.getRegisteredFunction(name);
                }
                return val;
            }

            public List<PropertyAccessor> getPropertyAccessors() {
                return propertyAccessors;
            }

            public List<MethodResolver> getMethodResolvers() {
                return methodResolvers;
            }
        };
        return context;
    }

    static {
        RESERVED_WORDS.add("db");
        RESERVED_WORDS.add("dbName");
        RESERVED_WORDS.add("dbValue");
        RESERVED_WORDS.add("dbRoute");
        RESERVED_WORDS.add("dbFormat");
        RESERVED_WORDS.add("sc");
        RESERVED_WORDS.add("scName");
        RESERVED_WORDS.add("scValue");
        RESERVED_WORDS.add("scRoute");
        RESERVED_WORDS.add("scFormat");
        RESERVED_WORDS.add("tb");
        RESERVED_WORDS.add("tbName");
        RESERVED_WORDS.add("tbValue");
        RESERVED_WORDS.add("tbRoute");
        RESERVED_WORDS.add("tbFormat");
        RESERVED_WORDS.add("sd");
        RESERVED_WORDS.add("sdName");
        RESERVED_WORDS.add("sdKey");
        RESERVED_WORDS.add("sdValue");
        RESERVED_WORDS.add("sdRoute");
        RESERVED_WORDS.add("sdFormat");
        RESERVED_WORDS.add("col");
        RESERVED_WORDS.add("colName");
        RESERVED_WORDS.add("colValue");
        RESERVED_WORDS.add("colRoute");
        RESERVED_WORDS.add("colFormat");
        rootObject = new TypedValue(null);
        propertyAccessors = new ArrayList<PropertyAccessor>(1);
        methodResolvers = new ArrayList<MethodResolver>(2);
        PARSER_CONTEXT = new ParserContext(){

            public boolean isTemplate() {
                return true;
            }

            public String getExpressionPrefix() {
                return "{";
            }

            public String getExpressionSuffix() {
                return "}";
            }
        };
        propertyAccessors.add((PropertyAccessor)new ReflectivePropertyAccessor());
        propertyAccessors.add(new PropertyAccessor(){

            public Class<?>[] getSpecificTargetClasses() {
                return null;
            }

            public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
                return true;
            }

            public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
                return new TypedValue(context.lookupVariable(name));
            }

            public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
                return false;
            }

            public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            }
        });
        methodResolvers.add((MethodResolver)new ReflectiveMethodResolver());
        methodResolvers.add(new MethodResolver(){

            public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
                final Method method = (Method)context.lookupVariable(name);
                if (method == null) {
                    return null;
                }
                return new MethodExecutor(){

                    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
                        try {
                            if (method.isVarArgs()) {
                                arguments = ReflectionHelper.setupArgumentsForVarargsInvocation((Class[])method.getParameterTypes(), (Object[])arguments);
                            }
                            ReflectionUtils.makeAccessible((Method)method);
                            Object value = method.invoke(target, arguments);
                            return new TypedValue(value, new TypeDescriptor(new MethodParameter(method, -1)).narrow(value));
                        }
                        catch (Exception ex) {
                            throw new AccessException("Problem invoking method: " + method, ex);
                        }
                    }
                };
            }
        });
    }
}

