/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.shard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.hellojavaer.ddal.ddr.datasource.exception.AmbiguousDataSourceBindingException;
import org.hellojavaer.ddal.ddr.shard.ShardRouteInfo;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;

public class ShardRouteContext {
    private static final ThreadLocal<LinkedList<Context>> STACK = new ThreadLocal<LinkedList<Context>>(){

        @Override
        protected LinkedList<Context> initialValue() {
            LinkedList<Context> stack = new LinkedList<Context>();
            stack.add(new Context());
            return stack;
        }
    };
    private static final Object NULL_OBJECT = new Object();

    public static void pushContext() {
        STACK.get().addFirst(new Context());
    }

    public static void popContext() throws IndexOutOfBoundsException {
        if (STACK.get().size() <= 1) {
            throw new IndexOutOfBoundsException("root context can't be pop");
        }
        STACK.get().removeFirst();
    }

    public static void clearContext() {
        Context context = STACK.get().getFirst();
        context.getDefaultRouteContext().clear();
        context.getExactRouteContext().clear();
        context.getAmbiguousRouteContext().clear();
    }

    public static void setRouteInfo(String scName, ShardRouteInfo routeInfo) {
        ShardRouteContext.setRouteInfo(scName, (Object)routeInfo);
    }

    public static void setRouteInfo(String scName, Object sdValue) {
        if ((scName = DDRStringUtils.toLowerCase(scName)) == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        if (sdValue == null) {
            sdValue = NULL_OBJECT;
        }
        ShardRouteContext.getCurContext().getDefaultRouteContext().put(scName, sdValue);
    }

    public static Object getRouteInfo(String scName) {
        if ((scName = DDRStringUtils.toLowerCase(scName)) == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        for (Context context : STACK.get()) {
            Map<String, Object> defaultRouteContext = context.getDefaultRouteContext();
            Object val = defaultRouteContext.get(scName);
            if (val == null) continue;
            if (val == NULL_OBJECT) {
                return null;
            }
            return val;
        }
        return null;
    }

    public static boolean containsRouteInfo(String scName) {
        if ((scName = DDRStringUtils.toLowerCase(scName)) == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        return ShardRouteContext.getCurContext().getDefaultRouteContext().containsKey(scName);
    }

    public static Object removeRouteInfo(String scName) {
        if ((scName = DDRStringUtils.toLowerCase(scName)) == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        return ShardRouteContext.getCurContext().getDefaultRouteContext().remove(scName);
    }

    public static void setRouteInfo(String scName, String tbName, Object sdValue) {
        scName = DDRStringUtils.toLowerCase(scName);
        tbName = DDRStringUtils.toLowerCase(tbName);
        if (scName == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        if (tbName == null) {
            throw new IllegalArgumentException("'tbName' can't be empty");
        }
        if (sdValue == null) {
            sdValue = NULL_OBJECT;
        }
        Map<String, Object> exactRouteContext = ShardRouteContext.getCurContext().getExactRouteContext();
        exactRouteContext.put(ShardRouteContext.buildQueryKey(scName, tbName), sdValue);
        Map<String, Map<String, Object>> ambiguousRouteContext = ShardRouteContext.getCurContext().getAmbiguousRouteContext();
        Map<String, Object> scMap = ambiguousRouteContext.get(tbName);
        if (scMap == null) {
            scMap = new HashMap<String, Object>();
            ambiguousRouteContext.put(tbName, scMap);
        }
        scMap.put(scName, sdValue);
    }

    public static void setRouteInfo(String scName, String tbName, ShardRouteInfo routeInfo) {
        ShardRouteContext.setRouteInfo(scName, tbName, (Object)routeInfo);
    }

    public static Object removeRouteInfo(String scName, String tbName) {
        scName = DDRStringUtils.toLowerCase(scName);
        tbName = DDRStringUtils.toLowerCase(tbName);
        if (scName == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        if (tbName == null) {
            throw new IllegalArgumentException("'tbName' can't be empty");
        }
        Map<String, Object> exactRouteContext = ShardRouteContext.getCurContext().getExactRouteContext();
        Object obj = exactRouteContext.remove(ShardRouteContext.buildQueryKey(scName, tbName));
        Map<String, Map<String, Object>> ambiguousRouteContext = ShardRouteContext.getCurContext().getAmbiguousRouteContext();
        Map<String, Object> scMap = ambiguousRouteContext.get(tbName);
        if (scMap != null) {
            scMap.remove(scName);
            if (scMap.isEmpty()) {
                ambiguousRouteContext.remove(tbName);
            }
        }
        return obj;
    }

    public static Object getRouteInfo(String scName, String tbName) throws AmbiguousDataSourceBindingException {
        scName = DDRStringUtils.toLowerCase(scName);
        if ((tbName = DDRStringUtils.toLowerCase(tbName)) == null) {
            throw new IllegalArgumentException("'tbName' can't be empty");
        }
        for (Context context : STACK.get()) {
            Object object = null;
            if (scName != null) {
                object = context.getExactRouteContext().get(ShardRouteContext.buildQueryKey(scName, tbName));
            } else {
                Map<String, Map<String, Object>> ambiguousRouteContext = context.getAmbiguousRouteContext();
                Map<String, Object> scMap = ambiguousRouteContext.get(tbName);
                if (scMap == null || scMap.isEmpty()) continue;
                if (scMap.size() > 1) {
                    throw new AmbiguousDataSourceBindingException("Datasource binding for scName:" + scName + ", tbName:" + tbName + " is ambiguous");
                }
                object = scMap.values().iterator().next();
            }
            if (object == null) continue;
            if (object == NULL_OBJECT) {
                return null;
            }
            return object;
        }
        if (scName == null) {
            return null;
        }
        return ShardRouteContext.getRouteInfo(scName);
    }

    public static boolean containsRouteInfo(String scName, String tbName) {
        scName = DDRStringUtils.toLowerCase(scName);
        tbName = DDRStringUtils.toLowerCase(tbName);
        if (scName == null) {
            throw new IllegalArgumentException("'scName' can't be empty");
        }
        if (tbName == null) {
            throw new IllegalArgumentException("'tbName' can't be empty");
        }
        String fullTableName = ShardRouteContext.buildQueryKey(scName, tbName);
        return ShardRouteContext.getCurContext().getExactRouteContext().containsKey(fullTableName);
    }

    private static String buildQueryKey(String scName, String tbName) {
        if (scName == null) {
            return tbName;
        }
        return scName + '.' + tbName;
    }

    private static Context getCurContext() {
        return STACK.get().getFirst();
    }

    private static class Context {
        private Map<String, Object> defaultRouteContext = new HashMap<String, Object>();
        private Map<String, Object> exactRouteContext = new HashMap<String, Object>();
        private Map<String, Map<String, Object>> ambiguousRouteContext = new HashMap<String, Map<String, Object>>();

        private Context() {
        }

        public Map<String, Object> getExactRouteContext() {
            return this.exactRouteContext;
        }

        public void setExactRouteContext(Map<String, Object> exactRouteContext) {
            this.exactRouteContext = exactRouteContext;
        }

        public Map<String, Object> getDefaultRouteContext() {
            return this.defaultRouteContext;
        }

        public void setDefaultRouteContext(Map<String, Object> defaultRouteContext) {
            this.defaultRouteContext = defaultRouteContext;
        }

        public Map<String, Map<String, Object>> getAmbiguousRouteContext() {
            return this.ambiguousRouteContext;
        }

        public void setAmbiguousRouteContext(Map<String, Map<String, Object>> ambiguousRouteContext) {
            this.ambiguousRouteContext = ambiguousRouteContext;
        }
    }

    protected static class InnerRouteInfoWrapper {
        private Set<String> conflictSchemas = new HashSet<String>();
        private Object routeInfo;

        public InnerRouteInfoWrapper(String scName, Object routeInfo) {
            this.conflictSchemas.add(scName);
            this.routeInfo = routeInfo;
        }

        public Set<String> getConflictSchemas() {
            return this.conflictSchemas;
        }

        public void setConflictSchemas(Set<String> conflictSchemas) {
            this.conflictSchemas = conflictSchemas;
        }

        public Object getRouteInfo() {
            return this.routeInfo;
        }

        public void setRouteInfo(Object routeInfo) {
            this.routeInfo = routeInfo;
        }
    }
}

