/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.lb.random;

import java.util.List;
import java.util.Random;
import org.hellojavaer.ddal.ddr.lb.random.WeightItem;

public class WeightedRandom {
    private Random random;
    private int allWeight;
    private InnerWeightItem[] innerWeightItems;

    public WeightedRandom(Long seed, List<WeightItem> itemList) {
        if (itemList == null || itemList.isEmpty()) {
            throw new IllegalArgumentException("WeightItem list can't be empty");
        }
        this.random = new Random(seed);
        int count = 0;
        this.innerWeightItems = new InnerWeightItem[itemList.size()];
        int i = 0;
        for (WeightItem item : itemList) {
            InnerWeightItem innerWeightItem = new InnerWeightItem();
            innerWeightItem.setStart(count);
            innerWeightItem.setEnd(count + item.getWeight() - 1);
            count += item.getWeight();
            innerWeightItem.setValue(item.getValue());
            this.innerWeightItems[i++] = innerWeightItem;
        }
        this.allWeight = count;
    }

    public Object nextValue() {
        int i = this.random.nextInt();
        if (i < 0) {
            i *= -1;
        }
        InnerWeightItem innerWeightItem = WeightedRandom.binarySearch(this.innerWeightItems, i %= this.allWeight);
        return innerWeightItem.getValue();
    }

    private static InnerWeightItem binarySearch(InnerWeightItem[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            InnerWeightItem midVal = a[mid];
            if (midVal.getEnd() < key) {
                low = mid + 1;
                continue;
            }
            if (midVal.getStart() > key) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    private class InnerWeightItem {
        private int start;
        private int end;
        private Object value;

        private InnerWeightItem() {
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

