/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.expression.range;

import java.util.ArrayList;
import java.util.List;
import org.hellojavaer.ddal.ddr.expression.range.RangeExpressionItemVisitor;
import org.hellojavaer.ddal.ddr.expression.range.Token;
import org.hellojavaer.ddal.ddr.expression.range.TokenKind;
import org.hellojavaer.ddal.ddr.expression.range.Tokenizer;

public class RangeExpressionParser {
    private Tokenizer tokenizer = null;
    private List<List> list = new ArrayList<List>();
    private boolean empty = false;

    public RangeExpressionParser(String expression) {
        this.tokenizer = new Tokenizer(expression);
        this.eatExpression();
    }

    public void visit(RangeExpressionItemVisitor itemVisitor) {
        if (this.list != null) {
            for (List segments : this.list) {
                this.visit0(segments, itemVisitor);
            }
        }
    }

    private void visit0(List segments, RangeExpressionItemVisitor itemVisitor) {
        if (segments == null || segments.isEmpty() || this.empty) {
            return;
        }
        if (segments.size() == 1) {
            Object obj = segments.get(0);
            if (obj instanceof List) {
                for (Object item : (List)obj) {
                    if (item instanceof InnerRange) {
                        int i;
                        InnerRange range = (InnerRange)item;
                        if (range.isIntegerRange()) {
                            if (range.getBegin() <= range.getEnd()) {
                                for (i = range.getBegin(); i <= range.getEnd(); ++i) {
                                    itemVisitor.visit(i);
                                }
                                continue;
                            }
                            for (i = range.getBegin(); i >= range.getEnd(); --i) {
                                itemVisitor.visit(i);
                            }
                            continue;
                        }
                        if (range.getBegin() <= range.getEnd()) {
                            for (i = range.getBegin(); i <= range.getEnd(); ++i) {
                                itemVisitor.visit(String.valueOf((char)i));
                            }
                            continue;
                        }
                        for (i = range.getBegin(); i >= range.getEnd(); --i) {
                            itemVisitor.visit(String.valueOf((char)i));
                        }
                        continue;
                    }
                    itemVisitor.visit(item);
                }
            } else {
                itemVisitor.visit(obj);
            }
            return;
        }
        this.recvInvoke(segments, "", 0, itemVisitor);
    }

    private void recvInvoke(List segments, String prefix, int index, RangeExpressionItemVisitor itemVisitor) {
        if (index == segments.size()) {
            itemVisitor.visit(prefix);
        } else {
            Object obj = segments.get(index);
            if (obj instanceof List) {
                for (Object item : (List)obj) {
                    if (item instanceof InnerRange) {
                        int i;
                        InnerRange range = (InnerRange)item;
                        if (range.isIntegerRange()) {
                            if (range.getBegin() <= range.getEnd()) {
                                for (i = range.getBegin(); i <= range.getEnd(); ++i) {
                                    this.recvInvoke(segments, prefix + i, index + 1, itemVisitor);
                                }
                                continue;
                            }
                            for (i = range.getBegin(); i >= range.getEnd(); --i) {
                                this.recvInvoke(segments, prefix + i, index + 1, itemVisitor);
                            }
                            continue;
                        }
                        if (range.getBegin() <= range.getEnd()) {
                            for (i = range.getBegin(); i <= range.getEnd(); ++i) {
                                this.recvInvoke(segments, prefix + (char)i, index + 1, itemVisitor);
                            }
                            continue;
                        }
                        for (i = range.getBegin(); i >= range.getEnd(); --i) {
                            this.recvInvoke(segments, prefix + (char)i, index + 1, itemVisitor);
                        }
                        continue;
                    }
                    this.recvInvoke(segments, prefix + item, index + 1, itemVisitor);
                }
            } else {
                this.recvInvoke(segments, prefix + obj, index + 1, itemVisitor);
            }
        }
    }

    private void eatExpression() {
        ArrayList segments = new ArrayList();
        this.eatSplicedRange(segments);
        this.list.add(segments);
        if (this.tokenizer.hasMoreTokens()) {
            this.tokenizer.peekToken(0, TokenKind.COMMA);
            this.tokenizer.nextToken(new TokenKind[0]);
            this.eatExpression();
        }
    }

    private void eatSplicedRange(List segments) {
        Token token = this.tokenizer.peekToken(0, new TokenKind[0]);
        if (token == null) {
            return;
        }
        switch (token.getKind()) {
            case LITERAL_STRING: {
                segments.add(token.getData());
                break;
            }
            case LSQUARE: {
                this.tokenizer.nextToken(new TokenKind[0]);
                ArrayList list = new ArrayList();
                this.eatRange(list);
                if (list.isEmpty()) {
                    this.empty = true;
                } else {
                    segments.add(list);
                }
                this.tokenizer.peekToken(0, TokenKind.RSQUARE);
                break;
            }
            default: {
                return;
            }
        }
        if (this.tokenizer.hasMoreTokens()) {
            this.tokenizer.nextToken(new TokenKind[0]);
            this.eatSplicedRange(segments);
        }
    }

    private void eatRange(List list) {
        Token token0 = this.tokenizer.peekToken(0, new TokenKind[0]);
        Token token1 = this.tokenizer.peekToken(1, new TokenKind[0]);
        if (token0 == null) {
            return;
        }
        if (token1 != null && token1.getKind() == TokenKind.TO) {
            Token token2;
            if (token0.getKind() == TokenKind.LITERAL_INT) {
                token2 = this.tokenizer.nextToken(2, TokenKind.LITERAL_INT);
                InnerRange range = new InnerRange(true, Integer.parseInt(token0.getData()), Integer.parseInt(token2.getData()));
                list.add(range);
            } else if (token0.getKind() == TokenKind.LITERAL_LOWER_CHAR) {
                token2 = this.tokenizer.nextToken(2, TokenKind.LITERAL_LOWER_CHAR);
                InnerRange range = new InnerRange(false, token0.getData().charAt(0), token2.getData().charAt(0));
                list.add(range);
            } else if (token0.getKind() == TokenKind.LITERAL_UPPER_CHAR) {
                token2 = this.tokenizer.nextToken(2, TokenKind.LITERAL_UPPER_CHAR);
                InnerRange range = new InnerRange(false, token0.getData().charAt(0), token2.getData().charAt(0));
                list.add(range);
            } else {
                this.tokenizer.peekToken(0, TokenKind.LITERAL_INT, TokenKind.LITERAL_LOWER_CHAR, TokenKind.LITERAL_UPPER_CHAR);
            }
        } else if (token0.getKind() == TokenKind.LITERAL_INT) {
            list.add(Integer.parseInt(token0.getData()));
        } else if (token0.getKind() == TokenKind.LITERAL_DOUBLE) {
            list.add(Double.parseDouble(token0.getData()));
        } else if (token0.getKind() == TokenKind.LITERAL_STRING || token0.getKind() == TokenKind.LITERAL_LOWER_CHAR || token0.getKind() == TokenKind.LITERAL_UPPER_CHAR) {
            list.add(token0.getData());
        } else {
            return;
        }
        Token token = this.tokenizer.nextToken(new TokenKind[0]);
        if (token != null && token.getKind() == TokenKind.COMMA) {
            this.tokenizer.nextToken(new TokenKind[0]);
            this.eatRange(list);
        }
    }

    private class InnerRange {
        private boolean integerRange;
        private int begin;
        private int end;

        public InnerRange(boolean integerRange, int begin, int end) {
            this.integerRange = integerRange;
            this.begin = begin;
            this.end = end;
        }

        public boolean isIntegerRange() {
            return this.integerRange;
        }

        public void setIntegerRange(boolean integerRange) {
            this.integerRange = integerRange;
        }

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }
}

