/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.expression.el.function;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hellojavaer.ddal.ddr.expression.el.function.FormatFunction;
import org.hellojavaer.ddal.ddr.expression.el.function.MathFunction;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;

public class ELFunctionManager {
    private static Map<String, Method> map = new ConcurrentHashMap<String, Method>(128);

    private static void registerFunction(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            ELFunctionManager.registerFunction(method.getName(), method);
        }
    }

    public static void registerFunction(String functionName, Method method) {
        if ((functionName = DDRStringUtils.trimToNull(functionName)) == null) {
            throw new IllegalArgumentException("function name can't be empty");
        }
        map.put(functionName, method);
    }

    public static Method unregisterFunction(String functionName) {
        if ((functionName = functionName.trim()).length() == 0) {
            throw new IllegalArgumentException("function name can't be empty");
        }
        return map.remove(functionName);
    }

    public static Method getRegisteredFunction(String name) {
        return map.get(name);
    }

    public static Set<Map.Entry<String, Method>> getRegisteredFunctions() {
        return map.entrySet();
    }

    public static void reset() {
        map.clear();
    }

    static {
        ELFunctionManager.registerFunction(MathFunction.class);
        ELFunctionManager.registerFunction(FormatFunction.class);
    }
}

