/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.datasource.manager.rw;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.hellojavaer.ddal.ddr.datasource.WeightedDataSource;
import org.hellojavaer.ddal.ddr.datasource.exception.CrossDataSourceException;
import org.hellojavaer.ddal.ddr.datasource.exception.DataSourceNotFoundException;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DataSourceWrapper;
import org.hellojavaer.ddal.ddr.datasource.manager.DataSourceParam;
import org.hellojavaer.ddal.ddr.datasource.manager.rw.ReadOnlyDataSourceBinding;
import org.hellojavaer.ddal.ddr.datasource.manager.rw.ReadWriteDataSourceManager;
import org.hellojavaer.ddal.ddr.datasource.manager.rw.WriteOnlyDataSourceBinding;
import org.hellojavaer.ddal.ddr.datasource.manager.rw.monitor.ReadOnlyDataSourceMonitor;
import org.hellojavaer.ddal.ddr.datasource.manager.rw.monitor.ReadOnlyDataSourceMonitorServer;
import org.hellojavaer.ddal.ddr.datasource.manager.rw.monitor.WriterMethodInvokeResult;
import org.hellojavaer.ddal.ddr.datasource.security.metadata.DefaultMetaDataChecker;
import org.hellojavaer.ddal.ddr.datasource.security.metadata.MetaDataChecker;
import org.hellojavaer.ddal.ddr.expression.range.RangeExpressionItemVisitor;
import org.hellojavaer.ddal.ddr.expression.range.RangeExpressionParser;
import org.hellojavaer.ddal.ddr.lb.random.WeightItem;
import org.hellojavaer.ddal.ddr.lb.random.WeightedRandom;
import org.hellojavaer.ddal.ddr.shard.ShardRouteInfo;
import org.hellojavaer.ddal.ddr.shard.ShardRouter;
import org.hellojavaer.ddal.ddr.utils.DDRJSONUtils;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;
import org.hellojavaer.ddal.ddr.utils.DDRToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReadWriteDataSourceManager
implements ReadWriteDataSourceManager {
    protected final Logger stdLogger = LoggerFactory.getLogger((String)"org.hellojavaer.ddr.ds");
    private ReadOnlyDataSourceMonitorServer readOnlyDataSourceMonitorServer;
    private List<WriteOnlyDataSourceBinding> writeOnlyDataSources = null;
    private List<ReadOnlyDataSourceBinding> readOnlyDataSources = null;
    private ShardRouter shardRouter = null;
    private MetaDataChecker metaDataChecker = null;
    private Map<String, WeightedRandom> readOnlyDataSourceQueryCache = null;
    private Map<String, DataSourceWrapper> writeOnlyDataSourceQueryCache = null;
    private LinkedHashMap<String, List<WeightedDataSourceWrapper>> readOnlyDataSourceIndexCacheOriginalValues = null;
    private Map<String, Map<String, WeightedDataSourceWrapper>> readOnlyDataSourceMapCacheOriginalValues = null;
    private LinkedHashMap<String, List<WeightedDataSourceWrapper>> readOnlyDataSourceIndexCacheCurrentValues = null;
    private Map<String, Map<String, WeightedDataSourceWrapper>> readOnlyDataSourceMapCahceCurrentValues = null;
    private boolean initialized = false;
    private volatile Map<String, Set<String>> physicalTables = null;

    private DefaultReadWriteDataSourceManager() {
        this.metaDataChecker = new DefaultMetaDataChecker("mysql");
    }

    public DefaultReadWriteDataSourceManager(List<ReadOnlyDataSourceBinding> readOnlyDataSources, ReadOnlyDataSourceMonitorServer readOnlyDataSourceMonitorServer, List<WriteOnlyDataSourceBinding> writeOnlyDataSources, ShardRouter shardRouter) {
        this.setReadOnlyDataSources(readOnlyDataSources);
        this.setReadOnlyDataSourceMonitorServer(readOnlyDataSourceMonitorServer);
        this.setWriteOnlyDataSources(writeOnlyDataSources);
        this.setShardRouter(shardRouter);
        this.setMetaDataChecker(new DefaultMetaDataChecker("mysql"));
        this.init();
    }

    public DefaultReadWriteDataSourceManager(ReadOnlyDataSourceMonitorServer readOnlyDataSourceMonitorServer, List<WriteOnlyDataSourceBinding> writeOnlyDataSources, List<ReadOnlyDataSourceBinding> readOnlyDataSources, ShardRouter shardRouter, MetaDataChecker metaDataChecker) {
        this.setReadOnlyDataSources(readOnlyDataSources);
        this.setReadOnlyDataSourceMonitorServer(readOnlyDataSourceMonitorServer);
        this.setWriteOnlyDataSources(writeOnlyDataSources);
        this.setShardRouter(shardRouter);
        this.setMetaDataChecker(metaDataChecker);
        this.init();
    }

    @Override
    public synchronized List<ReadOnlyDataSourceBinding> getReadOnlyDataSources() {
        return this.readOnlyDataSources;
    }

    public synchronized void setReadOnlyDataSources(List<ReadOnlyDataSourceBinding> readOnlyDataSources) {
        this.initReadOnlyDataSource(readOnlyDataSources);
        this.check(this.readOnlyDataSourceIndexCacheOriginalValues);
        this.readOnlyDataSources = readOnlyDataSources;
    }

    @Override
    public ReadOnlyDataSourceMonitorServer getReadOnlyDataSourceMonitorServer() {
        return this.readOnlyDataSourceMonitorServer;
    }

    public void setReadOnlyDataSourceMonitorServer(ReadOnlyDataSourceMonitorServer readOnlyDataSourceMonitorServer) {
        this.readOnlyDataSourceMonitorServer = readOnlyDataSourceMonitorServer;
    }

    @Override
    public synchronized List<WriteOnlyDataSourceBinding> getWriteOnlyDataSources() {
        return this.writeOnlyDataSources;
    }

    public synchronized void setWriteOnlyDataSources(List<WriteOnlyDataSourceBinding> writeOnlyDataSources) {
        this.initWriteOnlyDataSource(writeOnlyDataSources);
        this.check(this.writeOnlyDataSourceQueryCache);
        this.writeOnlyDataSources = writeOnlyDataSources;
    }

    public ShardRouter getShardRouter() {
        return this.shardRouter;
    }

    public void setShardRouter(ShardRouter shardRouter) {
        this.shardRouter = shardRouter;
    }

    public MetaDataChecker getMetaDataChecker() {
        return this.metaDataChecker;
    }

    public void setMetaDataChecker(MetaDataChecker metaDataChecker) {
        this.metaDataChecker = metaDataChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.initialized && this.readOnlyDataSourceMonitorServer != null) {
            DefaultReadWriteDataSourceManager defaultReadWriteDataSourceManager = this;
            synchronized (defaultReadWriteDataSourceManager) {
                if (!this.initialized && this.readOnlyDataSourceMonitorServer != null) {
                    this.readOnlyDataSourceMonitorServer.init(this.getReadOnlyDataSourceMonitor());
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public synchronized ReadOnlyDataSourceMonitor getReadOnlyDataSourceMonitor() {
        return new ReadOnlyDataSourceMonitor(){

            @Override
            public Integer getWeight(String scName, int index) {
                if ((scName = DDRStringUtils.toLowerCase(scName)) == null || index < 0 || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.isEmpty()) {
                    return null;
                }
                List weightedDataSourceList = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(scName);
                if (weightedDataSourceList == null || weightedDataSourceList.isEmpty() || index >= weightedDataSourceList.size()) {
                    return null;
                }
                WeightedDataSource weightedDataSource = (WeightedDataSource)weightedDataSourceList.get(index);
                if (weightedDataSource == null) {
                    return null;
                }
                return weightedDataSource.getWeight();
            }

            @Override
            public String setWeight(String scName, int index, int weight) {
                if ((scName = DDRStringUtils.toLowerCase(scName)) == null || index < 0 || weight < 0) {
                    return new WriterMethodInvokeResult(20, "parameter invalid").toString();
                }
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                List weightedDataSourceList = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(scName);
                if (weightedDataSourceList == null || weightedDataSourceList.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                if (index < 0 || index >= weightedDataSourceList.size()) {
                    return new WriterMethodInvokeResult(20, "illegal argument(s)").toString();
                }
                WeightedDataSource weightedDataSource = (WeightedDataSource)weightedDataSourceList.get(index);
                if (weightedDataSource == null) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                weightedDataSource.setWeight(weight);
                this.refreshReadDataSourceQueryCache(scName, weightedDataSourceList);
                return new WriterMethodInvokeResult(0, "OK").toString();
            }

            @Override
            public String restoreWeight(String scName, int index) {
                if ((scName = DDRStringUtils.toLowerCase(scName)) == null || index < 0) {
                    return new WriterMethodInvokeResult(20, "illegal argument(s)").toString();
                }
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.isEmpty() || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                List weightedDataSourceList0 = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.get(scName);
                List weightedDataSourceList1 = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(scName);
                if (weightedDataSourceList0 == null || weightedDataSourceList0.isEmpty() || weightedDataSourceList0.size() <= index || weightedDataSourceList1 == null || weightedDataSourceList1.isEmpty() || weightedDataSourceList1.size() <= index) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                WeightedDataSource weightedDataSource0 = (WeightedDataSource)weightedDataSourceList0.get(index);
                WeightedDataSource weightedDataSource1 = (WeightedDataSource)weightedDataSourceList1.get(index);
                if (weightedDataSource0 == null || weightedDataSource1 == null) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                weightedDataSource1.setWeight(weightedDataSource0.getWeight());
                this.refreshReadDataSourceQueryCache(scName, weightedDataSourceList1);
                return new WriterMethodInvokeResult(0, "OK").toString();
            }

            @Override
            public Integer getWeight(String scName, String dataSourceName) {
                scName = DDRStringUtils.toLowerCase(scName);
                dataSourceName = DDRStringUtils.trimToNull(dataSourceName);
                if (scName == null || dataSourceName == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues.isEmpty()) {
                    return null;
                }
                Map weightedDataSourceList = (Map)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues.get(scName);
                if (weightedDataSourceList == null || weightedDataSourceList.isEmpty()) {
                    return null;
                }
                WeightedDataSource weightedDataSource = (WeightedDataSource)weightedDataSourceList.get(dataSourceName);
                if (weightedDataSource == null) {
                    return null;
                }
                return weightedDataSource.getWeight();
            }

            @Override
            public String setWeight(String scName, String dataSourceName, int weight) {
                scName = DDRStringUtils.toLowerCase(scName);
                dataSourceName = DDRStringUtils.trimToNull(dataSourceName);
                if (scName == null || dataSourceName == null || weight < 0) {
                    return new WriterMethodInvokeResult(20, "illegal argument(s)").toString();
                }
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                Map weightedDataSourceMap = (Map)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues.get(scName);
                if (weightedDataSourceMap == null || weightedDataSourceMap.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                WeightedDataSource weightedDataSource = (WeightedDataSource)weightedDataSourceMap.get(dataSourceName);
                if (weightedDataSource == null) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                weightedDataSource.setWeight(weight);
                this.refreshReadDataSourceQueryCache(scName, (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(scName));
                return new WriterMethodInvokeResult(0, "OK").toString();
            }

            @Override
            public String restoreWeight(String scName, String dataSourceName) {
                scName = DDRStringUtils.toLowerCase(scName);
                dataSourceName = DDRStringUtils.trimToNull(dataSourceName);
                if (scName == null || dataSourceName == null) {
                    return new WriterMethodInvokeResult(20, "illegal argument(s)").toString();
                }
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCacheOriginalValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCacheOriginalValues.isEmpty() || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                Map weightedDataSourceMap0 = (Map)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCacheOriginalValues.get(scName);
                Map weightedDataSourceMap1 = (Map)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceMapCahceCurrentValues.get(scName);
                if (weightedDataSourceMap0 == null || weightedDataSourceMap0.isEmpty() || weightedDataSourceMap1 == null || weightedDataSourceMap1.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                WeightedDataSource weightedDataSource0 = (WeightedDataSource)weightedDataSourceMap0.get(dataSourceName);
                WeightedDataSource weightedDataSource1 = (WeightedDataSource)weightedDataSourceMap1.get(dataSourceName);
                if (weightedDataSource0 == null || weightedDataSource1 == null) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                weightedDataSource1.setWeight(weightedDataSource0.getWeight());
                this.refreshReadDataSourceQueryCache(scName, (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(scName));
                return new WriterMethodInvokeResult(0, "OK").toString();
            }

            @Override
            public String getWeight(String scName) {
                scName = DDRStringUtils.toLowerCase(scName);
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.isEmpty()) {
                    return null;
                }
                return DDRJSONUtils.toJSONString((Collection)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.get(scName));
            }

            @Override
            public String restoreWeight(String scName) {
                if ((scName = DDRStringUtils.toLowerCase(scName)) == null) {
                    return new WriterMethodInvokeResult(20, "illegal argument(s)").toString();
                }
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.isEmpty() || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                List weightedDataSourceList0 = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.get(scName);
                List weightedDataSourceList1 = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(scName);
                if (weightedDataSourceList0 == null || weightedDataSourceList0.isEmpty() || weightedDataSourceList0 == null || weightedDataSourceList0.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "target data is empty").toString();
                }
                for (int i = 0; i < weightedDataSourceList0.size(); ++i) {
                    WeightedDataSource weightedDataSource0 = (WeightedDataSource)weightedDataSourceList0.get(i);
                    WeightedDataSource weightedDataSource1 = (WeightedDataSource)weightedDataSourceList1.get(i);
                    weightedDataSource1.setWeight(weightedDataSource0.getWeight());
                }
                this.refreshReadDataSourceQueryCache(scName, weightedDataSourceList1);
                return new WriterMethodInvokeResult(0, "OK").toString();
            }

            @Override
            public String restoreWeight() {
                if (DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.isEmpty() || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues == null || DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.isEmpty()) {
                    return new WriterMethodInvokeResult(40, "data exception").toString();
                }
                for (Map.Entry entry : DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues.entrySet()) {
                    List weightedDataSourceList0 = (List)entry.getValue();
                    List weightedDataSourceList1 = (List)DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues.get(entry.getKey());
                    if (weightedDataSourceList0 == null || weightedDataSourceList0.isEmpty() || weightedDataSourceList0 == null || weightedDataSourceList0.isEmpty()) {
                        return new WriterMethodInvokeResult(40, "data exception").toString();
                    }
                    for (int i = 0; i < weightedDataSourceList0.size(); ++i) {
                        WeightedDataSource weightedDataSource0 = (WeightedDataSource)weightedDataSourceList0.get(i);
                        WeightedDataSource weightedDataSource1 = (WeightedDataSource)weightedDataSourceList1.get(i);
                        weightedDataSource1.setWeight(weightedDataSource0.getWeight());
                    }
                }
                DefaultReadWriteDataSourceManager.this.refreshReadDataSourceQueryCache();
                return new WriterMethodInvokeResult(0, "OK").toString();
            }

            @Override
            public String getOriginalWeightConfig() {
                return DDRJSONUtils.toJSONString(DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheOriginalValues);
            }

            @Override
            public String getCurrentWeightConfig() {
                return DDRJSONUtils.toJSONString(DefaultReadWriteDataSourceManager.this.readOnlyDataSourceIndexCacheCurrentValues);
            }

            private void refreshReadDataSourceQueryCache(String schema, List<WeightedDataSourceWrapper> weightedDataSourceWrappers) {
                DefaultReadWriteDataSourceManager.this.refreshReadDataSourceQueryCache(DefaultReadWriteDataSourceManager.this.readOnlyDataSourceQueryCache, schema, weightedDataSourceWrappers);
            }
        };
    }

    private void check(Map<String, DataSourceWrapper> writeOnlyDataSourceQueryCache) {
        if (writeOnlyDataSourceQueryCache == null || writeOnlyDataSourceQueryCache.isEmpty() || this.metaDataChecker == null || this.shardRouter == null) {
            return;
        }
        Map<String, Set<String>> routedTables = this.shardRouter.getRoutedTables();
        if (routedTables == null || routedTables.isEmpty()) {
            return;
        }
        for (Map.Entry<String, DataSourceWrapper> entry : writeOnlyDataSourceQueryCache.entrySet()) {
            Connection conn = null;
            try {
                conn = entry.getValue().getDataSource().getConnection();
                String scName = entry.getKey();
                this.check(conn, scName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void check(LinkedHashMap<String, List<WeightedDataSourceWrapper>> readOnlyDataSourceIndexCacheOriginalValues) {
        if (readOnlyDataSourceIndexCacheOriginalValues == null || readOnlyDataSourceIndexCacheOriginalValues.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<WeightedDataSourceWrapper>> entry : readOnlyDataSourceIndexCacheOriginalValues.entrySet()) {
            for (WeightedDataSourceWrapper dataSource : entry.getValue()) {
                Connection conn = null;
                try {
                    conn = dataSource.getDataSource().getConnection();
                    String scName = entry.getKey();
                    this.check(conn, scName);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (conn == null) continue;
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getPhysicalTables() {
        if (this.physicalTables == null) {
            DefaultReadWriteDataSourceManager defaultReadWriteDataSourceManager = this;
            synchronized (defaultReadWriteDataSourceManager) {
                if (this.physicalTables == null) {
                    HashMap<String, Set<String>> tabs = new HashMap<String, Set<String>>();
                    Map<String, Set<String>> routedTables = this.shardRouter.getRoutedTables();
                    if (routedTables != null) {
                        for (Map.Entry<String, Set<String>> entry : routedTables.entrySet()) {
                            String sc = entry.getKey();
                            for (String tb : entry.getValue()) {
                                List<ShardRouteInfo> routeInfos = this.shardRouter.getRouteInfos(sc, tb);
                                if (routeInfos == null) continue;
                                for (ShardRouteInfo routeInfo : routeInfos) {
                                    HashSet<String> set = (HashSet<String>)tabs.get(routeInfo.getScName());
                                    if (set == null) {
                                        set = new HashSet<String>();
                                        tabs.put(routeInfo.getScName(), set);
                                    }
                                    set.add(routeInfo.getTbName());
                                }
                            }
                        }
                    }
                    this.physicalTables = tabs;
                }
            }
        }
        return this.physicalTables;
    }

    private void check(Connection conn, String scName) {
        Set<String> tbNames;
        if (this.metaDataChecker == null || this.shardRouter == null) {
            return;
        }
        Map<String, Set<String>> physicalTables = this.getPhysicalTables();
        if (physicalTables != null && (tbNames = physicalTables.get(scName)) != null && !tbNames.isEmpty()) {
            this.metaDataChecker.check(conn, scName, tbNames);
            if (this.stdLogger.isInfoEnabled()) {
                this.stdLogger.info("MetaDataCheck - sc:{}, tb:{} meta data checking is passed", (Object)scName, tbNames);
            }
        }
    }

    private void initWriteOnlyDataSource(List<WriteOnlyDataSourceBinding> bindings) {
        if (bindings == null || bindings.isEmpty()) {
            return;
        }
        HashMap<String, DataSourceWrapper> dataSourceMap = new HashMap<String, DataSourceWrapper>();
        for (WriteOnlyDataSourceBinding binding : bindings) {
            String schemasString = DDRStringUtils.trimToNull(binding.getScNames());
            if (schemasString == null) {
                throw new IllegalArgumentException("scNames of 'writeOnlyDataSourceQueryCache' can't be empty");
            }
            final ArrayList<String> schemas = new ArrayList<String>();
            new RangeExpressionParser(schemasString).visit(new RangeExpressionItemVisitor(){

                @Override
                public void visit(Object val) {
                    schemas.add(val.toString());
                }
            });
            this.buildWriteOnlyDataSource(dataSourceMap, schemas, binding.getDataSource());
        }
        this.writeOnlyDataSourceQueryCache = dataSourceMap;
    }

    private void buildWriteOnlyDataSource(Map<String, DataSourceWrapper> dataSourceMap, List<String> schemas, DataSource dataSource) {
        HashSet<String> uniqueSchemas = new HashSet<String>();
        if (schemas != null && !schemas.isEmpty()) {
            for (String s : schemas) {
                uniqueSchemas.add(s);
            }
        }
        for (String schema : schemas) {
            if ((schema = DDRStringUtils.trimToNull(schema)) == null) {
                throw new IllegalArgumentException("Schema of 'writeOnlyDataSources' can't be null");
            }
            if (dataSource == null) {
                throw new IllegalArgumentException("[schema:" + schema + "] dataSource of 'writeOnlyDataSources' can't be null");
            }
            boolean exist = dataSourceMap.containsKey(schema = DDRStringUtils.toLowerCase(schema));
            if (exist) {
                throw new IllegalArgumentException("Schema '" + schema + "' duplicate binding in 'writeOnlyDataSources' configuration");
            }
            dataSourceMap.put(schema, new DataSourceWrapper(dataSource, uniqueSchemas));
        }
    }

    private void initReadOnlyDataSource(List<ReadOnlyDataSourceBinding> bindings) {
        if (bindings == null || bindings.isEmpty()) {
            return;
        }
        LinkedHashMap<String, List<WeightedDataSourceWrapper>> readOnlyDataSourceIndexCacheOriginalValues = new LinkedHashMap<String, List<WeightedDataSourceWrapper>>();
        for (ReadOnlyDataSourceBinding binding : bindings) {
            String schemasString = DDRStringUtils.trimToNull(binding.getScNames());
            if (schemasString == null) {
                throw new IllegalArgumentException("scNames of 'readOnlyDataSourceQueryCache' can't be empty");
            }
            final ArrayList<String> schemas = new ArrayList<String>();
            new RangeExpressionParser(schemasString).visit(new RangeExpressionItemVisitor(){

                @Override
                public void visit(Object val) {
                    schemas.add(val.toString());
                }
            });
            this.buildReadOnlyDataSource(readOnlyDataSourceIndexCacheOriginalValues, schemas, binding.getDataSources());
        }
        this.readOnlyDataSourceIndexCacheOriginalValues = readOnlyDataSourceIndexCacheOriginalValues;
        if (readOnlyDataSourceIndexCacheOriginalValues == null) {
            this.readOnlyDataSourceIndexCacheCurrentValues = null;
            this.readOnlyDataSourceMapCahceCurrentValues = null;
            this.readOnlyDataSourceMapCacheOriginalValues = null;
        } else {
            LinkedHashMap curList = new LinkedHashMap();
            LinkedHashMap<String, Map<String, WeightedDataSourceWrapper>> curMap = new LinkedHashMap<String, Map<String, WeightedDataSourceWrapper>>();
            LinkedHashMap<String, Map<String, WeightedDataSourceWrapper>> orgMap = new LinkedHashMap<String, Map<String, WeightedDataSourceWrapper>>();
            for (Map.Entry entry : readOnlyDataSourceIndexCacheOriginalValues.entrySet()) {
                if (entry.getValue() == null) {
                    curList.put(entry.getKey(), null);
                    continue;
                }
                ArrayList<WeightedDataSourceWrapper> list = new ArrayList<WeightedDataSourceWrapper>(((List)entry.getValue()).size());
                LinkedHashMap<String, WeightedDataSourceWrapper> map0 = new LinkedHashMap<String, WeightedDataSourceWrapper>();
                LinkedHashMap<String, WeightedDataSourceWrapper> map1 = new LinkedHashMap<String, WeightedDataSourceWrapper>();
                for (WeightedDataSourceWrapper weightedDataSourceWrapper : (List)entry.getValue()) {
                    WeightedDataSourceWrapper backup = weightedDataSourceWrapper.clone();
                    list.add(backup);
                    if (backup.getName() == null) continue;
                    map0.put(weightedDataSourceWrapper.getName(), backup);
                    map1.put(weightedDataSourceWrapper.getName(), weightedDataSourceWrapper);
                }
                if (!list.isEmpty()) {
                    curList.put(entry.getKey(), list);
                }
                if (!map0.isEmpty()) {
                    curMap.put((String)entry.getKey(), (Map<String, WeightedDataSourceWrapper>)map0);
                }
                if (map1.isEmpty()) continue;
                orgMap.put((String)entry.getKey(), (Map<String, WeightedDataSourceWrapper>)map1);
            }
            this.readOnlyDataSourceIndexCacheCurrentValues = curList;
            this.readOnlyDataSourceMapCahceCurrentValues = curMap;
            this.readOnlyDataSourceMapCacheOriginalValues = orgMap;
        }
        this.refreshReadDataSourceQueryCache();
    }

    private void refreshReadDataSourceQueryCache() {
        if (this.readOnlyDataSourceIndexCacheOriginalValues == null || this.readOnlyDataSourceIndexCacheOriginalValues.isEmpty()) {
            this.readOnlyDataSourceQueryCache = null;
        } else {
            HashMap<String, WeightedRandom> map = new HashMap<String, WeightedRandom>();
            for (Map.Entry<String, List<WeightedDataSourceWrapper>> entry : this.readOnlyDataSourceIndexCacheOriginalValues.entrySet()) {
                List<WeightedDataSourceWrapper> weightedDataSourceWrappers = entry.getValue();
                if (weightedDataSourceWrappers == null || weightedDataSourceWrappers.isEmpty()) continue;
                this.refreshReadDataSourceQueryCache(map, entry.getKey(), entry.getValue());
            }
            this.readOnlyDataSourceQueryCache = map;
        }
    }

    private void refreshReadDataSourceQueryCache(Map<String, WeightedRandom> map, String schema, List<WeightedDataSourceWrapper> weightedDataSourceWrappers) {
        ArrayList<WeightItem> dataSourceSchemasBindings = new ArrayList<WeightItem>();
        for (WeightedDataSourceWrapper weightedDataSourceWrapper : weightedDataSourceWrappers) {
            if (weightedDataSourceWrapper.getWeight() <= 0) continue;
            WeightItem weightItem = new WeightItem(weightedDataSourceWrapper.getWeight(), weightedDataSourceWrapper);
            dataSourceSchemasBindings.add(weightItem);
        }
        if (!dataSourceSchemasBindings.isEmpty()) {
            map.put(schema, new WeightedRandom(System.currentTimeMillis(), dataSourceSchemasBindings));
        } else {
            map.put(schema, null);
        }
    }

    private void buildReadOnlyDataSource(LinkedHashMap<String, List<WeightedDataSourceWrapper>> schemaDataSourceMapping, List<String> schemas, List<WeightedDataSource> dataSources) {
        HashSet<String> uniqSchemas = new HashSet<String>();
        if (schemas != null && !schemas.isEmpty()) {
            for (String s : schemas) {
                if ((s = DDRStringUtils.toLowerCase(s)) == null) {
                    throw new IllegalArgumentException("scName can't be empty");
                }
                if (uniqSchemas.contains(s)) {
                    throw new IllegalArgumentException("duplicate scName '" + s + "'");
                }
                uniqSchemas.add(s);
            }
        }
        for (String schema : uniqSchemas) {
            if (schema == null) {
                throw new IllegalArgumentException("Schema of 'readOnlyDataSources' can't be null");
            }
            if (dataSources == null || dataSources.isEmpty()) {
                throw new IllegalArgumentException("[schema:" + schema + "] dataSource of 'readOnlyDataSources' can't be empty");
            }
            if (schemaDataSourceMapping.containsKey(schema = DDRStringUtils.toLowerCase(schema))) {
                throw new IllegalArgumentException("Duplicate schema '" + schema + "' bind in 'readOnlyDataSources' configuration");
            }
            ArrayList<WeightItem> itemList = new ArrayList<WeightItem>();
            ArrayList<WeightedDataSourceWrapper> dataSourceSchemasBindings = new ArrayList<WeightedDataSourceWrapper>();
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 0; i < dataSources.size(); ++i) {
                WeightedDataSource weightedDataSource = dataSources.get(i);
                if (weightedDataSource.getWeight() == null || weightedDataSource.getWeight() < 0) {
                    throw new IllegalArgumentException("weight can't be null or less than 0 for schemas '" + DDRJSONUtils.toJSONString(uniqSchemas) + "' of readOnlyDataSources");
                }
                if (weightedDataSource.getDataSource() == null) {
                    throw new IllegalArgumentException("datasource can't be null for schemas '" + DDRJSONUtils.toJSONString(uniqSchemas) + "' of 'readOnlyDataSources'");
                }
                WeightedDataSourceWrapper weightedDataSourceWrapper = new WeightedDataSourceWrapper();
                weightedDataSourceWrapper.setDataSource(weightedDataSource.getDataSource());
                weightedDataSourceWrapper.setName(DDRStringUtils.trimToNull(weightedDataSource.getName()));
                weightedDataSourceWrapper.setIndex(i);
                weightedDataSourceWrapper.setDesc(weightedDataSource.getDesc());
                weightedDataSourceWrapper.setWeight(weightedDataSource.getWeight());
                weightedDataSourceWrapper.setDataSourceWrapper(new DataSourceWrapper(weightedDataSourceWrapper.getDataSource(), uniqSchemas));
                if (weightedDataSourceWrapper.getName() != null) {
                    if (nameSet.contains(weightedDataSourceWrapper.getName())) {
                        throw new IllegalArgumentException("Duplicate datasource name '" + weightedDataSourceWrapper.getName() + "' for scNames '" + DDRJSONUtils.toJSONString(uniqSchemas) + "'");
                    }
                    nameSet.add(weightedDataSourceWrapper.getName());
                }
                dataSourceSchemasBindings.add(weightedDataSourceWrapper);
                if (weightedDataSource.getWeight() == 0) continue;
                WeightItem weightItem = new WeightItem();
                weightItem.setWeight(weightedDataSource.getWeight());
                weightItem.setValue(weightedDataSourceWrapper);
                itemList.add(weightItem);
            }
            schemaDataSourceMapping.put(schema, dataSourceSchemasBindings);
        }
    }

    @Override
    public DataSourceWrapper getDataSource(DataSourceParam param) {
        this.init();
        if (param.getScNames() == null || param.getScNames().isEmpty()) {
            throw new IllegalArgumentException("scNames can't be empty");
        }
        boolean readOnly = param.isReadOnly();
        if (readOnly) {
            if (this.readOnlyDataSourceQueryCache == null) {
                throw new DataSourceNotFoundException("No 'readOnlyDataSource' is configured");
            }
            WeightedDataSourceWrapper weightedDataSourceWrapper = null;
            for (String scName : param.getScNames()) {
                if (weightedDataSourceWrapper == null) {
                    WeightedRandom weightedRandom = this.readOnlyDataSourceQueryCache.get(scName);
                    if (weightedRandom == null) {
                        throw new DataSourceNotFoundException("schema:'" + scName + "' isn't configured in 'readOnlyDataSource' list ");
                    }
                    weightedDataSourceWrapper = (WeightedDataSourceWrapper)weightedRandom.nextValue();
                    continue;
                }
                if (weightedDataSourceWrapper.getDataSourceWrapper().getSchemas().contains(scName)) continue;
                throw new CrossDataSourceException("For parameter " + param + ", scName:'" + scName + "' is not in 'readOnlyDataSource' binding '" + weightedDataSourceWrapper.getDataSourceWrapper().toString() + "'");
            }
            if (this.stdLogger.isDebugEnabled()) {
                this.stdLogger.debug("[GetDataSource] " + "param:" + param + " matched R:" + weightedDataSourceWrapper);
            }
            return weightedDataSourceWrapper.getDataSourceWrapper();
        }
        if (this.writeOnlyDataSourceQueryCache == null) {
            throw new DataSourceNotFoundException("No 'writeOnlyDataSource' is configured");
        }
        DataSourceWrapper dataSourceWrapper = null;
        for (String scName : param.getScNames()) {
            if (dataSourceWrapper == null) {
                dataSourceWrapper = this.writeOnlyDataSourceQueryCache.get(scName);
                if (dataSourceWrapper != null) continue;
                throw new DataSourceNotFoundException("schema '" + scName + "' isn't configured in 'writeOnlyDataSource' list");
            }
            if (dataSourceWrapper.getSchemas().contains(scName)) continue;
            throw new CrossDataSourceException("For parameter " + param + ", scName:'" + scName + "' is not in 'writeOnlyDataSource' binding '" + dataSourceWrapper.toString() + "'");
        }
        if (this.stdLogger.isDebugEnabled()) {
            this.stdLogger.debug("[GetDataSource] " + "param:" + param + " matched W:" + dataSourceWrapper);
        }
        return dataSourceWrapper;
    }

    private static class WeightedDataSourceWrapper
    extends WeightedDataSource
    implements Cloneable {
        private int index;
        private DataSourceWrapper dataSourceWrapper;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public DataSourceWrapper getDataSourceWrapper() {
            return this.dataSourceWrapper;
        }

        public void setDataSourceWrapper(DataSourceWrapper dataSourceWrapper) {
            this.dataSourceWrapper = dataSourceWrapper;
        }

        public WeightedDataSourceWrapper clone() {
            try {
                WeightedDataSourceWrapper backup = (WeightedDataSourceWrapper)super.clone();
                backup.setIndex(this.index);
                backup.setDataSourceWrapper(this.dataSourceWrapper);
                return backup;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString() {
            return new DDRToStringBuilder().append("name", this.getName()).append("index", this.index).append("weight", this.getWeight()).append("desc", this.getDesc()).append("schemas", this.dataSourceWrapper.getSchemas()).append("datasource", this.getDataSource()).toString();
        }
    }
}

