/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.sqlparse.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import org.hellojavaer.ddal.ddr.shard.ShardRouter;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedState;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParser;
import org.hellojavaer.ddal.ddr.sqlparse.cache.SQLParserCache;

public class LRUSQLParserCache
implements SQLParserCache {
    private volatile ConcurrentLinkedHashMap<InnerQueryKey, SQLParsedState> cache;
    private Integer capacity;
    private SQLParser sqlParser;

    private LRUSQLParserCache() {
    }

    public LRUSQLParserCache(SQLParser sqlParser, Integer capacity) {
        this.sqlParser = sqlParser;
        this.capacity = capacity;
        this.init();
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public SQLParser getSqlParser() {
        return this.sqlParser;
    }

    public void setSqlParser(SQLParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    @Override
    public SQLParsedState parse(String sql, ShardRouter shardRouter) {
        this.init();
        InnerQueryKey queryKey = new InnerQueryKey(sql, shardRouter);
        SQLParsedState result = (SQLParsedState)this.cache.get((Object)queryKey);
        if (result == null) {
            result = this.sqlParser.parse(sql, shardRouter);
            this.cache.put((Object)queryKey, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.cache == null) {
            LRUSQLParserCache lRUSQLParserCache = this;
            synchronized (lRUSQLParserCache) {
                if (this.cache == null) {
                    this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.capacity.intValue()).weigher(Weighers.singleton()).build();
                }
            }
        }
    }

    private class InnerQueryKey {
        private String sql;
        private ShardRouter shardRouter;

        public InnerQueryKey(String sql, ShardRouter shardRouter) {
            this.sql = sql;
            this.shardRouter = shardRouter;
        }

        public int hashCode() {
            return this.sql.hashCode() + this.shardRouter.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof InnerQueryKey) {
                InnerQueryKey tar = (InnerQueryKey)obj;
                return (this.sql == null && tar.getSql() == null || this.sql != null && this.sql.equals(tar.getSql())) && (this.shardRouter == null && tar.getShardRouter() == null || this.shardRouter != null && this.shardRouter.equals(tar.getShardRouter()));
            }
            return false;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public ShardRouter getShardRouter() {
            return this.shardRouter;
        }

        public void setShardRouter(ShardRouter shardRouter) {
            this.shardRouter = shardRouter;
        }
    }
}

