/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.shard.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hellojavaer.ddal.ddr.expression.range.RangeExpressionItemVisitor;
import org.hellojavaer.ddal.ddr.expression.range.RangeExpressionParser;
import org.hellojavaer.ddal.ddr.shard.ShardRouteConfig;
import org.hellojavaer.ddal.ddr.shard.ShardRouteContext;
import org.hellojavaer.ddal.ddr.shard.ShardRouteInfo;
import org.hellojavaer.ddal.ddr.shard.ShardRouteRule;
import org.hellojavaer.ddal.ddr.shard.ShardRouter;
import org.hellojavaer.ddal.ddr.shard.exception.AmbiguousRouteRuleBindingException;
import org.hellojavaer.ddal.ddr.shard.exception.DuplicateRouteRuleBindingException;
import org.hellojavaer.ddal.ddr.shard.exception.IllegalShardValueException;
import org.hellojavaer.ddal.ddr.shard.exception.ShardRouteException;
import org.hellojavaer.ddal.ddr.shard.exception.ShardValueNotFoundException;
import org.hellojavaer.ddal.ddr.shard.simple.SimpleShardRouteRuleBinding;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleShardRouter
implements ShardRouter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<SimpleShardRouteRuleBinding> routeRuleBindings = null;
    private Map<String, InnerSimpleShardRouteRuleBindingWrapper> cache = Collections.EMPTY_MAP;
    private Map<String, List<ShardRouteInfo>> routeInfoMap = new HashMap<String, List<ShardRouteInfo>>();
    private Map<String, Set<String>> routedTables = new HashMap<String, Set<String>>();

    private SimpleShardRouter() {
    }

    public SimpleShardRouter(List<SimpleShardRouteRuleBinding> routeRuleBindings) {
        this.setRouteRuleBindings(routeRuleBindings);
    }

    public List<SimpleShardRouteRuleBinding> getRouteRuleBindings() {
        return this.routeRuleBindings;
    }

    public void setRouteRuleBindings(List<SimpleShardRouteRuleBinding> bindings) {
        HashMap<String, InnerSimpleShardRouteRuleBindingWrapper> cache = new HashMap<String, InnerSimpleShardRouteRuleBindingWrapper>();
        HashMap<String, List<ShardRouteInfo>> routeInfoMap = new HashMap<String, List<ShardRouteInfo>>();
        HashMap<String, Set<String>> routedTables = new HashMap<String, Set<String>>();
        if (bindings != null && !bindings.isEmpty()) {
            for (SimpleShardRouteRuleBinding binding : bindings) {
                String key;
                final String scName = DDRStringUtils.toLowerCase(binding.getScName());
                final String tbName = DDRStringUtils.toLowerCase(binding.getTbName());
                String sdKey = DDRStringUtils.toLowerCase(binding.getSdKey());
                String sdValues = DDRStringUtils.trimToNull(binding.getSdValues());
                if (scName == null) {
                    throw new IllegalArgumentException("'scName' can't be empty");
                }
                if (tbName == null) {
                    throw new IllegalArgumentException("'tbName' can't be empty");
                }
                final SimpleShardRouteRuleBinding b0 = new SimpleShardRouteRuleBinding();
                b0.setScName(scName);
                b0.setTbName(tbName);
                b0.setSdKey(sdKey);
                b0.setRule(binding.getRule());
                StringBuilder sb = new StringBuilder();
                sb.append(scName).append('.').append(tbName);
                this.putToCache(cache, sb.toString(), b0, true);
                this.putToCache(cache, tbName, b0, false);
                final LinkedHashSet routeInfos = new LinkedHashSet();
                if (sdValues != null) {
                    new RangeExpressionParser(sdValues).visit(new RangeExpressionItemVisitor(){

                        @Override
                        public void visit(Object val) {
                            ShardRouteInfo routeInfo = SimpleShardRouter.this.getRouteInfo(b0, scName, tbName, val);
                            routeInfos.add(routeInfo);
                        }
                    });
                }
                if (routeInfoMap.containsKey(key = SimpleShardRouter.buildQueryKey(scName, tbName))) {
                    throw new IllegalArgumentException("Duplicate route config for table '" + key + "'");
                }
                LinkedHashSet<String> tables = (LinkedHashSet<String>)routedTables.get(scName);
                if (tables == null) {
                    tables = new LinkedHashSet<String>();
                    routedTables.put(scName, tables);
                }
                tables.add(tbName);
                routeInfoMap.put(key, new ArrayList(routeInfos));
            }
        }
        this.routeRuleBindings = bindings;
        this.cache = cache;
        this.routeInfoMap = routeInfoMap;
        this.routedTables = routedTables;
    }

    private void putToCache(Map<String, InnerSimpleShardRouteRuleBindingWrapper> cache, String key, SimpleShardRouteRuleBinding ruleBinding, boolean checkConflict) {
        InnerSimpleShardRouteRuleBindingWrapper ruleBindingWrapper = cache.get(key);
        if (checkConflict && ruleBindingWrapper != null) {
            throw new DuplicateRouteRuleBindingException("Duplicate route rule binding for scName:" + ruleBinding.getScName() + ", tbName:" + ruleBinding.getTbName());
        }
        if (ruleBindingWrapper == null) {
            ruleBindingWrapper = new InnerSimpleShardRouteRuleBindingWrapper();
            ruleBindingWrapper.setRuleBinding(ruleBinding);
            ruleBindingWrapper.setRouteConfig(new ShardRouteConfig(ruleBinding.getScName(), ruleBinding.getTbName(), ruleBinding.getSdKey()));
            cache.put(key, ruleBindingWrapper);
        }
        ruleBindingWrapper.getConflictSchemas().add(ruleBinding.getScName());
    }

    private InnerSimpleShardRouteRuleBindingWrapper getBinding(String scName, String tbName) {
        InnerSimpleShardRouteRuleBindingWrapper ruleBindingWrapper;
        if (tbName == null) {
            throw new IllegalArgumentException("'tbName' can't be empty");
        }
        String queryKey = tbName;
        if (scName != null) {
            queryKey = scName + '.' + tbName;
        }
        if ((ruleBindingWrapper = this.cache.get(queryKey)) == null) {
            return null;
        }
        if (ruleBindingWrapper.getConflictSchemas().size() > 1) {
            throw new AmbiguousRouteRuleBindingException("route rule binding for 'scName':" + scName + ", 'tbName':" + tbName + " is ambiguous");
        }
        return ruleBindingWrapper;
    }

    @Override
    public ShardRouteRule getRouteRule(String scName, String tbName) {
        InnerSimpleShardRouteRuleBindingWrapper bindingWrapper = this.getBinding(scName = DDRStringUtils.toLowerCase(scName), tbName = DDRStringUtils.toLowerCase(tbName));
        if (bindingWrapper == null || bindingWrapper.getRuleBinding() == null) {
            return null;
        }
        return bindingWrapper.getRuleBinding().getRule();
    }

    @Override
    public ShardRouteConfig getRouteConfig(String scName, String tbName) {
        InnerSimpleShardRouteRuleBindingWrapper bindingWrapper = this.getBinding(scName = DDRStringUtils.toLowerCase(scName), tbName = DDRStringUtils.toLowerCase(tbName));
        if (bindingWrapper == null) {
            return null;
        }
        return bindingWrapper.getRouteConfig();
    }

    @Override
    public ShardRouteInfo getRouteInfo(String scName, String tbName, Object sdValue) throws ShardValueNotFoundException, ShardRouteException {
        InnerSimpleShardRouteRuleBindingWrapper bindingWrapper = this.getBinding(scName = DDRStringUtils.toLowerCase(scName), tbName = DDRStringUtils.toLowerCase(tbName));
        SimpleShardRouteRuleBinding binding = bindingWrapper.getRuleBinding();
        if (binding == null) {
            return null;
        }
        ShardRouteInfo info = this.getRouteInfo(binding, binding.getScName(), binding.getTbName(), sdValue);
        return info;
    }

    @Override
    public List<ShardRouteInfo> getRouteInfos(String scName, String tbName) throws ShardValueNotFoundException, ShardRouteException {
        return this.routeInfoMap.get(SimpleShardRouter.buildQueryKey(scName, tbName));
    }

    @Override
    public Map<String, Set<String>> getRoutedTables() {
        return this.routedTables;
    }

    private static String buildQueryKey(String scName, String tbName) {
        StringBuilder sb = new StringBuilder();
        if ((scName = DDRStringUtils.toLowerCase(scName)) != null) {
            sb.append(scName);
            sb.append('.');
        }
        sb.append(DDRStringUtils.toLowerCase(tbName));
        return sb.toString();
    }

    private ShardRouteInfo getRouteInfo(SimpleShardRouteRuleBinding binding, String scName, String tbName, Object sdValue) throws ShardRouteException, ShardValueNotFoundException {
        ShardRouteRule rule = binding.getRule();
        if (rule == null) {
            ShardRouteInfo info = new ShardRouteInfo();
            info.setScName(scName);
            info.setTbName(tbName);
            return info;
        }
        if (sdValue == null) {
            Object obj = ShardRouteContext.getRouteInfo(scName, tbName);
            if (obj == null) {
                throw new ShardValueNotFoundException("shard value is not found for scName:" + scName + ", tbName:" + tbName + ",routeRule:" + rule);
            }
            if (binding.getSdKey() != null && !(obj instanceof ShardRouteInfo)) {
                throw new IllegalShardValueException("when 'sdKey' is configed in route rule for table '" + scName + "." + tbName + "', " + ", the type of 'sdValue' can only be 'RouteInfo'. but current 'sdValue' is " + obj.getClass() + "(" + obj + ")");
            }
            if (obj instanceof ShardRouteInfo) {
                return (ShardRouteInfo)obj;
            }
            return this.getRouteInfoByRouteRule(rule, scName, tbName, obj);
        }
        return this.getRouteInfoByRouteRule(rule, scName, tbName, sdValue);
    }

    private ShardRouteInfo getRouteInfoByRouteRule(ShardRouteRule rule, String scName, String tbName, Object sdValue) {
        try {
            ShardRouteInfo info = new ShardRouteInfo();
            String sc = rule.parseScName(scName, sdValue);
            String tb = rule.parseTbName(tbName, sdValue);
            info.setScName(sc);
            info.setTbName(tb);
            return info;
        }
        catch (Throwable e) {
            throw new ShardRouteException("'scName':" + scName + ",'tbName':" + tbName + ",'sdName':" + sdValue + ",routeRule:" + rule, e);
        }
    }

    protected class InnerSimpleShardRouteRuleBindingWrapper {
        private List<String> conflictSchemas = new ArrayList<String>();
        private SimpleShardRouteRuleBinding ruleBinding;
        private ShardRouteConfig routeConfig;

        protected InnerSimpleShardRouteRuleBindingWrapper() {
        }

        public List<String> getConflictSchemas() {
            return this.conflictSchemas;
        }

        public void setConflictSchemas(List<String> conflictSchemas) {
            this.conflictSchemas = conflictSchemas;
        }

        public SimpleShardRouteRuleBinding getRuleBinding() {
            return this.ruleBinding;
        }

        public void setRuleBinding(SimpleShardRouteRuleBinding ruleBinding) {
            this.ruleBinding = ruleBinding;
        }

        public ShardRouteConfig getRouteConfig() {
            return this.routeConfig;
        }

        public void setRouteConfig(ShardRouteConfig routeConfig) {
            this.routeConfig = routeConfig;
        }
    }
}

