/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.shard.rule;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hellojavaer.ddal.ddr.shard.RangeShardValue;
import org.hellojavaer.ddal.ddr.shard.ShardRouteInfo;
import org.hellojavaer.ddal.ddr.shard.ShardRouteRule;
import org.hellojavaer.ddal.ddr.shard.exception.CrossTableException;
import org.hellojavaer.ddal.ddr.shard.exception.UnsupportedShardValueTypeException;

public class DivideShardRouteRule
implements ShardRouteRule {
    private Long scSdValueDividend;
    private Long tbSdValueDividend;
    private boolean useOrignalNameIfZero = false;

    private DivideShardRouteRule() {
    }

    public DivideShardRouteRule(Long scSdValueDividend, Long tbSdValueDividend) {
        this.scSdValueDividend = scSdValueDividend;
        this.tbSdValueDividend = tbSdValueDividend;
        this.verify();
    }

    public DivideShardRouteRule(Long scSdValueDividend, Long tbSdValueDividend, boolean useOrignalNameIfZero) {
        this.scSdValueDividend = scSdValueDividend;
        this.tbSdValueDividend = tbSdValueDividend;
        this.useOrignalNameIfZero = useOrignalNameIfZero;
        this.verify();
    }

    private void verify() {
        if (this.scSdValueDividend != null && this.scSdValueDividend <= 0L) {
            throw new IllegalArgumentException("scSdValueDividend must be greater than 0");
        }
        if (this.tbSdValueDividend != null && this.tbSdValueDividend <= 0L) {
            throw new IllegalArgumentException("tbSdValueDividend must be greater than 0");
        }
        if (this.scSdValueDividend != null && this.tbSdValueDividend != null && (this.tbSdValueDividend > this.scSdValueDividend || this.scSdValueDividend % this.tbSdValueDividend != 0L)) {
            throw new IllegalArgumentException("tbSdValueDividend must be a multiple of scSdValueDividend");
        }
    }

    public Long getScSdValueDividend() {
        return this.scSdValueDividend;
    }

    private void setScSdValueDividend(Long scSdValueDividend) {
        this.scSdValueDividend = scSdValueDividend;
        this.verify();
    }

    public Long getTbSdValueDividend() {
        return this.tbSdValueDividend;
    }

    private void setTbSdValueDividend(Long tbSdValueDividend) {
        this.tbSdValueDividend = tbSdValueDividend;
        this.verify();
    }

    public boolean isUseOrignalNameIfZero() {
        return this.useOrignalNameIfZero;
    }

    private void setUseOrignalNameIfZero(boolean useOrignalNameIfZero) {
        this.useOrignalNameIfZero = useOrignalNameIfZero;
    }

    @Override
    public String parseScName(String scName, Object sdValue) {
        return this.parseName(scName, sdValue, this.scSdValueDividend);
    }

    @Override
    public String parseTbName(String tbName, Object sdValue) {
        return this.parseName(tbName, sdValue, this.tbSdValueDividend);
    }

    @Override
    public Map<ShardRouteInfo, List<RangeShardValue>> groupSdValuesByRouteInfo(String scName, String tbName, RangeShardValue rangeShardValue) {
        Long begin = rangeShardValue.getBegin();
        Long end = rangeShardValue.getEnd();
        if (begin == null || end == null) {
            throw new IllegalArgumentException("rangeShardValue.begin and rangeShardValue.end can't be null");
        }
        if (begin > end) {
            throw new IllegalArgumentException("rangeShardValue.begin can't be greater than rangeShardValue.end");
        }
        LinkedHashMap<ShardRouteInfo, List<RangeShardValue>> map = new LinkedHashMap<ShardRouteInfo, List<RangeShardValue>>();
        if (this.scSdValueDividend == null && this.tbSdValueDividend == null) {
            ShardRouteInfo routeInfo = new ShardRouteInfo(scName, tbName);
            ArrayList<RangeShardValue> list = new ArrayList<RangeShardValue>(1);
            list.add(new RangeShardValue(begin, end));
            map.put(routeInfo, list);
            return map;
        }
        if (this.scSdValueDividend != null && this.tbSdValueDividend != null) {
            int scBegin = (int)(begin / this.scSdValueDividend);
            int scEnd = (int)(end / this.scSdValueDividend);
            int tbBegin = (int)(begin / this.tbSdValueDividend);
            int tbEnd = (int)(end / this.tbSdValueDividend);
            for (int i = scBegin; i <= scEnd; ++i) {
                String scName0 = scName;
                if (i != 0 || !this.useOrignalNameIfZero) {
                    scName0 = scName + '_' + i;
                }
                for (int j = tbBegin; j <= tbEnd; ++j) {
                    ShardRouteInfo routeInfo;
                    ArrayList<RangeShardValue> list;
                    String tbName0 = tbName;
                    if (j != 0 || !this.useOrignalNameIfZero) {
                        tbName0 = tbName + '_' + j;
                    }
                    if ((list = (ArrayList<RangeShardValue>)map.get(routeInfo = new ShardRouteInfo(scName0, tbName0))) == null) {
                        list = new ArrayList<RangeShardValue>();
                        map.put(routeInfo, list);
                    }
                    RangeShardValue rangeShardValue1 = new RangeShardValue((long)j * this.tbSdValueDividend, (long)(j + 1) * this.tbSdValueDividend - 1L);
                    this.adjustBorder(rangeShardValue1, rangeShardValue);
                    list.add(rangeShardValue1);
                }
            }
            return map;
        }
        if (this.scSdValueDividend == null && this.tbSdValueDividend != null) {
            int tbBegin = (int)(begin / this.tbSdValueDividend);
            int tbEnd = (int)(end / this.tbSdValueDividend);
            for (int j = tbBegin; j <= tbEnd; ++j) {
                ShardRouteInfo routeInfo;
                ArrayList<RangeShardValue> list;
                String tbName0 = tbName;
                if (j != 0 || !this.useOrignalNameIfZero) {
                    tbName0 = tbName + '_' + j;
                }
                if ((list = (ArrayList<RangeShardValue>)map.get(routeInfo = new ShardRouteInfo(scName, tbName0))) == null) {
                    list = new ArrayList<RangeShardValue>();
                    map.put(routeInfo, list);
                }
                RangeShardValue rangeShardValue1 = new RangeShardValue((long)j * this.tbSdValueDividend, (long)(j + 1) * this.tbSdValueDividend - 1L);
                this.adjustBorder(rangeShardValue1, rangeShardValue);
                list.add(rangeShardValue1);
            }
            return map;
        }
        int scBegin = (int)(begin / this.scSdValueDividend);
        int scEnd = (int)(end / this.scSdValueDividend);
        for (int j = scBegin; j <= scEnd; ++j) {
            ShardRouteInfo routeInfo;
            ArrayList<RangeShardValue> list;
            String scName0 = scName;
            if (j != 0 || !this.useOrignalNameIfZero) {
                scName0 = scName + '_' + j;
            }
            if ((list = (ArrayList<RangeShardValue>)map.get(routeInfo = new ShardRouteInfo(scName0, tbName))) == null) {
                list = new ArrayList<RangeShardValue>();
                map.put(routeInfo, list);
            }
            RangeShardValue rangeShardValue1 = new RangeShardValue((long)j * this.scSdValueDividend, (long)(j + 1) * this.scSdValueDividend - 1L);
            this.adjustBorder(rangeShardValue1, rangeShardValue);
            list.add(rangeShardValue1);
        }
        return map;
    }

    private void adjustBorder(RangeShardValue currentRangeShardValue, RangeShardValue originalRangeShardValue) {
        if (currentRangeShardValue.getBegin() < originalRangeShardValue.getBegin()) {
            currentRangeShardValue.setBegin(originalRangeShardValue.getBegin());
        }
        if (currentRangeShardValue.getEnd() > originalRangeShardValue.getEnd()) {
            currentRangeShardValue.setEnd(originalRangeShardValue.getEnd());
        }
    }

    protected String parseName(String name, Object sdValue, Long dividend) {
        if (dividend == null) {
            return name;
        }
        if (sdValue == null) {
            throw new NullPointerException("sdValue can't be null");
        }
        if (sdValue instanceof Number) {
            long l = ((Number)sdValue).longValue();
            return this.parseName0(name, l, dividend);
        }
        if (sdValue instanceof RangeShardValue) {
            Long l1;
            Long begin = ((RangeShardValue)sdValue).getBegin();
            Long end = ((RangeShardValue)sdValue).getEnd();
            if (begin == null || end == null) {
                throw new IllegalArgumentException("rangeShardValue.begin and rangeShardValue.end can't be null");
            }
            if (begin > end) {
                throw new IllegalArgumentException("rangeShardValue.end must be greater than rangeShardValue.begin");
            }
            Long l = begin / dividend;
            if (l != (l1 = Long.valueOf(end / dividend))) {
                String prefix = name + '_';
                throw new CrossTableException(prefix + l + ", " + prefix + l1);
            }
            if (l == 0L && this.useOrignalNameIfZero) {
                return name;
            }
            return name + '_' + l;
        }
        if (sdValue instanceof String) {
            Long l = Long.valueOf((String)sdValue);
            return this.parseName0(name, l, dividend);
        }
        throw new UnsupportedShardValueTypeException(sdValue.getClass().toString());
    }

    private String parseName0(String name, Long l, Long dividend) {
        Long a = l / dividend;
        if (a == 0L && this.useOrignalNameIfZero) {
            return name;
        }
        return name + '_' + a;
    }
}

