/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.shard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hellojavaer.ddal.ddr.shard.RangeShardValue;
import org.hellojavaer.ddal.ddr.shard.ShardRouteConfig;
import org.hellojavaer.ddal.ddr.shard.ShardRouteInfo;
import org.hellojavaer.ddal.ddr.shard.ShardRouteRule;
import org.hellojavaer.ddal.ddr.shard.ShardRouter;

public class ShardRouteUtils {
    public static Map<ShardRouteInfo, List<RangeShardValue>> groupSdValuesByRouteInfo(ShardRouter shardRouter, String scName, String tbName, RangeShardValue sdValues) {
        ShardRouteConfig routeConfig = shardRouter.getRouteConfig(scName, tbName);
        ShardRouteRule rule = shardRouter.getRouteRule(routeConfig.getScName(), routeConfig.getTbName());
        Map<ShardRouteInfo, List<RangeShardValue>> map = rule.groupSdValuesByRouteInfo(scName, tbName, sdValues);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public static <T> Map<ShardRouteInfo, List<T>> groupSdValuesByRouteInfo(ShardRouter shardRouter, String scName, String tbName, List<T> sdValues) {
        if (sdValues == null || sdValues.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<ShardRouteInfo, List<T>> map = new LinkedHashMap<ShardRouteInfo, List<T>>();
        for (T item : sdValues) {
            ShardRouteInfo routeInfo = shardRouter.getRouteInfo(scName, tbName, item);
            ArrayList<T> list = (ArrayList<T>)map.get(routeInfo);
            if (list == null) {
                list = new ArrayList<T>();
                map.put(routeInfo, list);
            }
            list.add(item);
        }
        return map;
    }

    public static <T> Map<ShardRouteInfo, Set<T>> groupSdValuesByRouteInfo(ShardRouter shardRouter, String scName, String tbName, Set<T> sdValues) {
        if (sdValues == null || sdValues.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = null;
        map = sdValues instanceof LinkedHashSet ? new LinkedHashMap() : new HashMap();
        for (T item : sdValues) {
            ShardRouteInfo routeInfo = shardRouter.getRouteInfo(scName, tbName, item);
            LinkedHashSet<T> set = (LinkedHashSet<T>)map.get(routeInfo);
            if (set == null) {
                set = new LinkedHashSet<T>();
                map.put((ShardRouteInfo)routeInfo, set);
            }
            set.add(item);
        }
        return map;
    }

    public static Map<String, List<ShardRouteInfo>> groupRouteInfosByScName(List<ShardRouteInfo> routeInfos) {
        if (routeInfos == null || routeInfos.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, List<ShardRouteInfo>> map = new LinkedHashMap<String, List<ShardRouteInfo>>();
        for (ShardRouteInfo routeInfo : routeInfos) {
            ArrayList<ShardRouteInfo> list = (ArrayList<ShardRouteInfo>)map.get(routeInfo.getScName());
            if (list == null) {
                list = new ArrayList<ShardRouteInfo>();
                map.put(routeInfo.getScName(), list);
            }
            list.add(routeInfo);
        }
        return map;
    }

    public static Map<String, Set<ShardRouteInfo>> groupRouteInfosByScName(Set<ShardRouteInfo> routeInfos) {
        if (routeInfos == null || routeInfos.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = null;
        map = routeInfos instanceof LinkedHashSet ? new LinkedHashMap() : new HashMap();
        for (ShardRouteInfo routeInfo : routeInfos) {
            LinkedHashSet<ShardRouteInfo> set = (LinkedHashSet<ShardRouteInfo>)map.get(routeInfo.getScName());
            if (set == null) {
                set = new LinkedHashSet<ShardRouteInfo>();
                map.put((String)routeInfo.getScName(), set);
            }
            set.add(routeInfo);
        }
        return map;
    }
}

