/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.expression.range;

import java.util.ArrayList;
import java.util.List;
import org.hellojavaer.ddal.ddr.expression.range.RangeExpressionException;
import org.hellojavaer.ddal.ddr.expression.range.Token;
import org.hellojavaer.ddal.ddr.expression.range.TokenKind;

class Tokenizer {
    private static final String BLANK_STRING = "";
    private List<Token> tokens = new ArrayList<Token>();
    private int index = 0;
    private int pos = 0;
    private String expression;
    private static final byte[] FLAGS = new byte[256];
    private static final byte IS_DIGIT = 1;
    private static final byte IS_LOWER_ALPHA = 2;
    private static final byte IS_UPPER_ALPHA = 4;

    public Tokenizer(String expression) {
        if (expression == null) {
            return;
        }
        this.expression = expression;
        boolean block = false;
        while (this.pos < expression.length()) {
            char ch = expression.charAt(this.pos);
            if (!block) {
                switch (ch) {
                    case '[': {
                        block = true;
                        this.tokens.add(new Token(TokenKind.LSQUARE, this.pos, this.pos + 1));
                        break;
                    }
                    case ']': {
                        throw new RangeExpressionException(expression, this.pos, "Unexpected character ']'");
                    }
                    case ',': {
                        if (this.tokens.size() > 0) {
                            Token preToken = this.tokens.get(this.tokens.size() - 1);
                            if (preToken != null && preToken.getKind() == TokenKind.COMMA) {
                                this.tokens.add(new Token(TokenKind.LITERAL_STRING, BLANK_STRING, this.pos - 1, this.pos - 1));
                            }
                        } else {
                            this.tokens.add(new Token(TokenKind.LITERAL_STRING, BLANK_STRING, this.pos, this.pos));
                        }
                        this.tokens.add(new Token(TokenKind.COMMA, this.pos, this.pos + 1));
                        break;
                    }
                    default: {
                        int begin;
                        char temp;
                        int end;
                        for (end = begin = this.pos; end < expression.length() && (temp = expression.charAt(end)) != '[' && temp != ']' && temp != ','; ++end) {
                        }
                        this.tokens.add(new Token(TokenKind.LITERAL_STRING, expression.substring(begin, end).trim(), begin, end));
                        this.pos = end - 1;
                        break;
                    }
                }
            } else {
                switch (ch) {
                    case '[': {
                        throw new RangeExpressionException(expression, this.pos, "Unexpected character '['");
                    }
                    case ']': {
                        this.tokens.add(new Token(TokenKind.RSQUARE, this.pos, this.pos + 1));
                        block = false;
                        break;
                    }
                    case ',': {
                        this.tokens.add(new Token(TokenKind.COMMA, this.pos, this.pos + 1));
                        break;
                    }
                    case '.': {
                        ++this.pos;
                        if (this.pos >= expression.length()) break;
                        ch = expression.charAt(this.pos);
                        if (ch == '.') {
                            this.tokens.add(new Token(TokenKind.TO, this.pos, this.pos + 2));
                            break;
                        }
                        throw new RangeExpressionException(expression, this.pos, "Expecte character '.'");
                    }
                    case '\'': {
                        this.pushString(false);
                        break;
                    }
                    case '\"': {
                        this.pushString(true);
                        break;
                    }
                    case '+': 
                    case '-': {
                        ++this.pos;
                        if (this.pos >= expression.length()) break;
                        ch = expression.charAt(this.pos);
                        if (this.isDisit(ch)) {
                            this.pushNum(true);
                            break;
                        }
                        throw new RangeExpressionException(expression, this.pos, "Expecte digist");
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.pushNum(false);
                        break;
                    }
                    default: {
                        throw new RangeExpressionException(expression, this.pos, "Unexpected character '" + ch + "'");
                    }
                }
            }
            ++this.pos;
        }
        if (this.tokens.size() > 0) {
            Token preToken;
            if (!block && (preToken = this.tokens.get(this.tokens.size() - 1)) != null && preToken.getKind() == TokenKind.COMMA) {
                this.tokens.add(new Token(TokenKind.LITERAL_STRING, BLANK_STRING, this.pos - 1, this.pos - 1));
            }
        } else {
            this.tokens.add(new Token(TokenKind.LITERAL_STRING, BLANK_STRING, 0, 0));
        }
    }

    private void pushString(boolean isDoubleuotes) {
        boolean escape = false;
        StringBuilder sb = null;
        for (int i = this.pos + 1; i < this.expression.length(); ++i) {
            char ch = this.expression.charAt(i);
            if (escape) {
                escape = false;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(ch);
                continue;
            }
            boolean terminal = false;
            if (ch == '\\') {
                escape = true;
                continue;
            }
            if (isDoubleuotes && ch == '\"') {
                terminal = true;
            } else if (!isDoubleuotes && ch == '\'') {
                terminal = true;
            } else if (sb != null) {
                sb.append(ch);
            }
            if (!terminal) continue;
            String str = sb == null ? this.expression.substring(this.pos + 1, i) : sb.toString();
            if (str.length() == 1 && (FLAGS[str.charAt(0)] & 2) != 0) {
                this.tokens.add(new Token(TokenKind.LITERAL_LOWER_CHAR, str, this.pos + 1, i));
            } else if (str.length() == 1 && (FLAGS[str.charAt(0)] & 4) != 0) {
                this.tokens.add(new Token(TokenKind.LITERAL_UPPER_CHAR, str, this.pos + 1, i));
            } else {
                this.tokens.add(new Token(TokenKind.LITERAL_STRING, str, this.pos + 1, i));
            }
            this.pos = i;
            return;
        }
        if (isDoubleuotes) {
            throw new RangeExpressionException(this.expression, this.pos, "Cannot find terminating \" for string");
        }
        throw new RangeExpressionException(this.expression, this.pos, "Cannot find terminating ' for string");
    }

    private void pushNum(boolean signed) {
        for (int i = this.pos; i < this.expression.length(); ++i) {
            char ch = this.expression.charAt(i);
            if ((FLAGS[ch] & 1) != 0) continue;
            if (ch == '.' && i + 1 < i + this.expression.length() && this.expression.charAt(i + 1) != '.') {
                for (int j = i + 1; j < this.expression.length(); ++j) {
                    ch = this.expression.charAt(j);
                    if (this.isDisit(ch)) continue;
                    if (!signed) {
                        this.tokens.add(new Token(TokenKind.LITERAL_DOUBLE, this.expression.substring(this.pos, j), this.pos, j));
                    } else {
                        this.tokens.add(new Token(TokenKind.LITERAL_DOUBLE, this.expression.substring(this.pos - 1, j), this.pos - 1, j));
                    }
                    this.pos = j - 1;
                    return;
                }
                continue;
            }
            if (!signed) {
                this.tokens.add(new Token(TokenKind.LITERAL_INT, this.expression.substring(this.pos, i), this.pos, i));
            } else {
                this.tokens.add(new Token(TokenKind.LITERAL_INT, this.expression.substring(this.pos - 1, i), this.pos - 1, i));
            }
            this.pos = i - 1;
            return;
        }
    }

    private boolean isDisit(char ch) {
        return (FLAGS[ch] & 1) == 1;
    }

    public Token peekToken(int nextPos, TokenKind ... expectedTokenKinds) {
        int pos = nextPos + this.index;
        Token token = null;
        if (pos >= 0 && pos < this.tokens.size()) {
            token = this.tokens.get(pos);
        }
        this.assertEquals(token, expectedTokenKinds);
        return token;
    }

    public Token nextToken(TokenKind ... expectedTokenKinds) {
        return this.nextToken(1, expectedTokenKinds);
    }

    public Token nextToken(int nextPos, TokenKind ... expectedTokenKinds) {
        this.index = nextPos + this.index;
        Token token = null;
        if (this.index < this.tokens.size()) {
            token = this.tokens.get(this.index);
        }
        this.assertEquals(token, expectedTokenKinds);
        return token;
    }

    private void assertEquals(Token token, TokenKind ... expectedTokenKinds) {
        if (expectedTokenKinds == null || expectedTokenKinds.length == 0) {
            return;
        }
        if (token != null) {
            for (TokenKind kind : expectedTokenKinds) {
                if (token.getKind() != kind) continue;
                return;
            }
            throw new RangeExpressionException(this.expression, token.getStartPos(), "Current token kind is " + (Object)((Object)token.getKind()) + ", expecte " + this.buildString((Object[])expectedTokenKinds));
        }
        throw new RangeExpressionException(this.expression, this.expression.length(), "Current token is null, expecte " + this.buildString((Object[])expectedTokenKinds));
    }

    private String buildString(Object ... objects) {
        if (objects == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object obj : objects) {
            sb.append(obj);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public boolean hasMoreTokens() {
        return this.index < this.tokens.size() - 1;
    }

    static {
        int ch = 48;
        while (ch <= 57) {
            int n = ch++;
            FLAGS[n] = (byte)(FLAGS[n] | 1);
        }
        ch = 97;
        while (ch <= 122) {
            int n = ch++;
            FLAGS[n] = (byte)(FLAGS[n] | 2);
        }
        ch = 65;
        while (ch <= 90) {
            int n = ch++;
            FLAGS[n] = (byte)(FLAGS[n] | 4);
        }
    }
}

