/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.expression.el.function;

import java.math.BigDecimal;
import java.math.BigInteger;

public class MathFunction {
    public static Number abs(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Byte) {
            byte b = number.byteValue();
            if (b < 0) {
                return -b;
            }
        } else if (number instanceof Short) {
            short s = number.shortValue();
            if (s < 0) {
                return -s;
            }
        } else if (number instanceof Integer) {
            int i = number.intValue();
            if (i < 0) {
                return -i;
            }
        } else if (number instanceof Long) {
            long l = number.longValue();
            if (l < 0L) {
                return -l;
            }
        } else if (number instanceof Float) {
            float f = number.floatValue();
            if (f < 0.0f) {
                return Float.valueOf(-f);
            }
        } else if (number instanceof Double) {
            double d = number.doubleValue();
            if (d < 0.0) {
                return -d;
            }
        } else {
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)number;
                return bigDecimal.abs();
            }
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                bigInteger.abs();
            } else {
                throw new UnsupportedOperationException("Can't calculate absolute value for type of " + number.getClass());
            }
        }
        return number;
    }

    public static Number max(Number n1, Number n2) {
        if (MathFunction.compare(n1, n2) >= 0) {
            return n1;
        }
        return n2;
    }

    public static Number min(Number n1, Number n2) {
        if (MathFunction.compare(n1, n2) <= 0) {
            return n1;
        }
        return n2;
    }

    private static int compare(Number n1, Number n2) {
        if (n1 instanceof BigInteger) {
            BigInteger b1 = (BigInteger)n1;
            BigInteger b2 = (BigInteger)n2;
            return b1.compareTo(b2);
        }
        if (n1 instanceof BigDecimal) {
            BigDecimal d1 = (BigDecimal)n1;
            BigDecimal d2 = (BigDecimal)n2;
            return d1.compareTo(d2);
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            double d2;
            double d1 = n1.doubleValue();
            return d1 - (d2 = n2.doubleValue()) > 0.0 ? 1 : -1;
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            float f2;
            float f1 = n1.floatValue();
            return f1 - (f2 = n2.floatValue()) > 0.0f ? 1 : -1;
        }
        long l1 = n1.longValue();
        long l2 = n2.longValue();
        return (int)(l1 - l2);
    }

    public static long ceil(double a) {
        return (long)Math.ceil(a);
    }

    public static long floor(double a) {
        return (long)Math.floor(a);
    }

    public static long round(double a) {
        return Math.round(a);
    }
}

