/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.datasource.jdbc;

import java.util.Collections;
import java.util.Map;
import org.hellojavaer.ddal.ddr.datasource.jdbc.AbstractDDRDataSource;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DataSourceWrapper;
import org.hellojavaer.ddal.ddr.datasource.jdbc.init.UninitializedConnectionProcessor;
import org.hellojavaer.ddal.ddr.datasource.jdbc.init.UninitializedDataSourceProcessor;
import org.hellojavaer.ddal.ddr.datasource.jdbc.property.ConnectionProperty;
import org.hellojavaer.ddal.ddr.datasource.jdbc.property.DataSourceProperty;
import org.hellojavaer.ddal.ddr.datasource.manager.DataSourceManager;
import org.hellojavaer.ddal.ddr.datasource.manager.DataSourceParam;
import org.hellojavaer.ddal.ddr.shard.ShardParser;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedResult;

public class DefaultDDRDataSource
extends AbstractDDRDataSource {
    private DataSourceManager dataSourceManager;
    private ShardParser shardParser;

    private DefaultDDRDataSource() {
    }

    public DefaultDDRDataSource(DataSourceManager dataSourceManager, ShardParser shardParser) {
        this.dataSourceManager = dataSourceManager;
        this.shardParser = shardParser;
    }

    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    public void setDataSourceManager(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public ShardParser getShardParser() {
        return this.shardParser;
    }

    public void setShardParser(ShardParser shardParser) {
        this.shardParser = shardParser;
    }

    @Override
    public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParam) {
        if (this.shardParser == null) {
            SQLParsedResult sqlParsedResult = new SQLParsedResult();
            sqlParsedResult.setSql(sql);
            sqlParsedResult.setSchemas(Collections.emptySet());
            return sqlParsedResult;
        }
        return this.shardParser.parse(sql, jdbcParam);
    }

    @Override
    public DataSourceWrapper getDataSource(DataSourceParam param) {
        return this.dataSourceManager.getDataSource(param);
    }

    static {
        UninitializedDataSourceProcessor.setDefaultValue(DataSourceProperty.loginTimeout, 0, false);
        UninitializedConnectionProcessor.setDefaultValue(ConnectionProperty.autoCommit, true, true);
        UninitializedConnectionProcessor.setDefaultValue(ConnectionProperty.metaData, null, false);
    }
}

