/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.datasource.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Set;
import org.hellojavaer.ddal.ddr.datasource.exception.CrossDataSourceException;
import org.hellojavaer.ddal.ddr.datasource.exception.StatementInitializationException;
import org.hellojavaer.ddal.ddr.datasource.exception.UninitializedStatusException;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DDRStatement;
import org.hellojavaer.ddal.ddr.datasource.jdbc.StatementWrapper;
import org.hellojavaer.ddal.ddr.datasource.jdbc.init.UninitializedStatementProcessor;
import org.hellojavaer.ddal.ddr.datasource.jdbc.property.StatementProperty;
import org.hellojavaer.ddal.ddr.datasource.manager.DataSourceParam;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DDRStatementImpl
implements DDRStatement {
    private Logger stdLogger = LoggerFactory.getLogger((String)"org.hellojavaer.ddr.sql");
    protected Set<String> schemas = null;
    protected Statement statement = null;
    protected Connection connection = null;
    protected boolean readOnly = false;
    private StatementPropertyBean prop = new StatementPropertyBean();
    private InvocationTag tag = new InvocationTag();

    public DDRStatementImpl(boolean readOnly, Set<String> schemas) {
        this.readOnly = readOnly;
        this.schemas = schemas;
    }

    protected boolean isCrossDataSource(Set<String> schemas) {
        if (this.schemas == null) {
            return false;
        }
        return !this.schemas.containsAll(schemas);
    }

    private String initStatementAndConvertSql(String sql) throws SQLException {
        SQLParsedResult parsedResult = this.parseSql(sql, null);
        if (this.stdLogger.isDebugEnabled()) {
            this.stdLogger.debug("[ParseSql] from:" + sql + " =>to: " + parsedResult.getSql());
        }
        if (this.isCrossDataSource(parsedResult.getSchemas())) {
            throw new CrossDataSourceException("Sql '" + sql + "'");
        }
        if (this.statement == null) {
            DataSourceParam param = new DataSourceParam();
            param.setReadOnly(this.readOnly);
            param.setScNames(parsedResult.getSchemas());
            try {
                this.initStatementIfAbsent(param, null);
            }
            catch (Throwable e) {
                throw new StatementInitializationException("readOnly:" + this.readOnly + " ,SQLParsedResult:" + parsedResult + " ,original sql:[" + sql + "]", e);
            }
            this.playbackInvocation(this.statement);
        }
        return parsedResult.getSql();
    }

    protected void initStatementIfAbsent(DataSourceParam param, String sql) throws SQLException {
        StatementWrapper statementWrapper = this.getStatement(param, sql);
        this.statement = statementWrapper.getStatement();
        this.connection = statementWrapper.getConnection();
        this.schemas = statementWrapper.getSchemas();
    }

    protected void playbackInvocation(Statement statement) throws SQLException {
        if (this.tag != null && this.prop != null) {
            if (this.tag.isEscapeProcessing()) {
                statement.setEscapeProcessing(this.prop.isEscapeProcessing());
            }
            if (this.tag.isFetchDirection()) {
                statement.setFetchDirection(this.prop.getFetchDirection());
            }
            if (this.tag.isMaxFieldSize()) {
                statement.setMaxFieldSize(this.prop.getMaxFieldSize());
            }
            if (this.tag.isFetchSize()) {
                statement.setFetchSize(this.prop.getFetchSize());
            }
            if (this.tag.isPoolable()) {
                statement.setPoolable(this.prop.isPoolable());
            }
            if (this.tag.isMaxRows()) {
                statement.setMaxRows(this.prop.getMaxRows());
            }
            if (this.tag.isQueryTimeout()) {
                statement.setQueryTimeout(this.prop.getQueryTimeout());
            }
            if (this.tag.isCloseOnCompletion() && this.prop.isCloseOnCompletion()) {
                statement.closeOnCompletion();
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.execute(sql);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        sql = this.initStatementAndConvertSql(sql);
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.statement != null) {
            this.statement.clearBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.statement != null) {
            return this.statement.executeBatch();
        }
        return new int[0];
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.statement != null) {
            this.statement.setMaxFieldSize(max);
        } else {
            this.tag.setMaxFieldSize(true);
            this.prop.setMaxFieldSize(max);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.statement != null) {
            return this.statement.getMaxFieldSize();
        }
        if (this.tag.isMaxFieldSize()) {
            return this.prop.getMaxFieldSize();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.maxFieldSize)) {
            int val = ((Number)UninitializedStatementProcessor.getDefaultValue(StatementProperty.maxFieldSize)).intValue();
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.maxFieldSize)) {
                this.prop.setMaxFieldSize(val);
                this.tag.setMaxFieldSize(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getMaxFieldSize()' before 'setMaxFieldSize(int max)' is invoked or statement is initialized");
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.statement != null) {
            return this.statement.getMaxRows();
        }
        if (this.tag.isMaxRows()) {
            return this.prop.getMaxRows();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.maxRows)) {
            int val = ((Number)UninitializedStatementProcessor.getDefaultValue(StatementProperty.maxRows)).intValue();
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.maxRows)) {
                this.prop.setMaxRows(val);
                this.tag.setMaxRows(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getMaxRows()' before 'setMaxRows' is invoked or statement is initialized");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.statement != null) {
            this.statement.setMaxRows(max);
        } else {
            this.tag.setMaxRows(true);
            this.prop.setMaxRows(max);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.statement != null) {
            this.statement.setFetchDirection(direction);
        } else {
            this.tag.setFetchDirection(true);
            this.prop.setFetchDirection(direction);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.statement != null) {
            return this.statement.getFetchDirection();
        }
        if (this.tag.isFetchDirection()) {
            return this.prop.getFetchDirection();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.fetchDirection)) {
            int val = ((Number)UninitializedStatementProcessor.getDefaultValue(StatementProperty.fetchDirection)).intValue();
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.fetchDirection)) {
                this.prop.setFetchDirection(val);
                this.tag.setFetchDirection(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getFetchDirection()' before 'setFetchDirection(int direction)' is invoked or statement is initialized");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.statement != null) {
            this.statement.setFetchSize(rows);
        } else {
            this.tag.setFetchSize(true);
            this.prop.setFetchSize(rows);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.statement != null) {
            return this.statement.getFetchSize();
        }
        if (this.tag.isFetchSize()) {
            return this.prop.getFetchSize();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.fetchSize)) {
            int val = ((Number)UninitializedStatementProcessor.getDefaultValue(StatementProperty.fetchSize)).intValue();
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.fetchSize)) {
                this.prop.setFetchSize(val);
                this.tag.setFetchSize(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getFetchSize()' before 'setFetchSize(int rows)' is invoked or statement is initialized");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.statement != null) {
            this.statement.setQueryTimeout(seconds);
        } else {
            this.tag.setQueryTimeout(true);
            this.prop.setQueryTimeout(seconds);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.statement != null) {
            return this.statement.getQueryTimeout();
        }
        if (this.tag.isQueryTimeout()) {
            return this.prop.getQueryTimeout();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.queryTimeout)) {
            int val = ((Number)UninitializedStatementProcessor.getDefaultValue(StatementProperty.queryTimeout)).intValue();
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.queryTimeout)) {
                this.prop.setQueryTimeout(val);
                this.tag.setQueryTimeout(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getQueryTimeout()' before 'setQueryTimeout(int seconds)' is invoked or statement is initialized");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.statement != null) {
            this.statement.closeOnCompletion();
        } else {
            this.tag.setCloseOnCompletion(true);
            this.prop.setCloseOnCompletion(true);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.statement != null) {
            return this.statement.isCloseOnCompletion();
        }
        if (this.tag.isCloseOnCompletion()) {
            return this.prop.isCloseOnCompletion();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.closeOnCompletion)) {
            boolean val = (Boolean)UninitializedStatementProcessor.getDefaultValue(StatementProperty.closeOnCompletion);
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.closeOnCompletion)) {
                this.prop.setCloseOnCompletion(true);
                this.tag.setCloseOnCompletion(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'isCloseOnCompletion()' before 'closeOnCompletion()' is invoked or statement is initialized");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (this.statement != null) {
            this.statement.setPoolable(poolable);
        } else {
            this.tag.setPoolable(true);
            this.prop.setPoolable(poolable);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.statement != null) {
            return this.statement.isPoolable();
        }
        if (this.tag.isPoolable()) {
            return this.prop.isPoolable();
        }
        if (UninitializedStatementProcessor.isSetDefaultValue(StatementProperty.poolable)) {
            boolean val = (Boolean)UninitializedStatementProcessor.getDefaultValue(StatementProperty.poolable);
            if (UninitializedStatementProcessor.isSyncDefaultValue(StatementProperty.poolable)) {
                this.prop.setPoolable(val);
                this.tag.setPoolable(true);
            }
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'isPoolable()' before 'setPoolable(boolean poolable)' is invoked or statement is initialized");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.statement != null) {
            this.statement.setEscapeProcessing(enable);
        } else {
            this.tag.setEscapeProcessing(true);
            this.prop.setEscapeProcessing(enable);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.statement == null) {
            throw new UninitializedStatusException("Can't invoke 'setCursorName()' before statement is initialized");
        }
        this.statement.setCursorName(name);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.statement != null) {
            return this.statement.getGeneratedKeys();
        }
        throw new UninitializedStatusException("Can't invoke 'getGeneratedKeys()' before statement is initialized");
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.statement != null) {
            return this.statement.isClosed();
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.statement != null) {
            this.statement.cancel();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        throw new UninitializedStatusException("Can't invoke 'getConnection()' before statement is initialized");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.statement != null) {
            return this.statement.getMoreResults(current);
        }
        throw new UninitializedStatusException("Can't invoke 'getMoreResults(int current)' before statement is initialized");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.statement != null) {
            return this.statement.getMoreResults();
        }
        throw new UninitializedStatusException("Can't invoke 'getMoreResults()' before statement is initialized");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.statement != null) {
            return this.statement.getResultSetHoldability();
        }
        throw new UninitializedStatusException("Can't invoke 'getResultSetHoldability()' before statement is initialized");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.statement != null) {
            return this.statement.getResultSet();
        }
        throw new UninitializedStatusException("Can't invoke 'getResultSet()' before statement is initialized");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.statement != null) {
            return this.statement.getUpdateCount();
        }
        throw new UninitializedStatusException("Can't invoke 'getUpdateCount()' before statement is initialized");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.statement != null) {
            return this.statement.getResultSetConcurrency();
        }
        throw new UninitializedStatusException("Can't invoke 'getResultSetConcurrency()' before statement is initialized");
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.statement != null) {
            return this.statement.getResultSetConcurrency();
        }
        throw new UninitializedStatusException("Can't invoke 'getResultSetType()' before statement is initialized");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement != null) {
            return this.statement.getWarnings();
        }
        throw new UninitializedStatusException("Can't invoke 'getWarnings()' before statement is initialized");
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.statement == null) {
            throw new UninitializedStatusException("Can't invoke 'clearWarnings()' before statement is initialized");
        }
        this.statement.clearWarnings();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private class InvocationTag {
        private boolean maxFieldSize;
        private boolean maxRows;
        private boolean fetchDirection;
        private boolean fetchSize;
        private boolean queryTimeout;
        private boolean escapeProcessing;
        private boolean closeOnCompletion;
        private boolean poolable;

        private InvocationTag() {
        }

        public boolean isMaxFieldSize() {
            return this.maxFieldSize;
        }

        public void setMaxFieldSize(boolean maxFieldSize) {
            this.maxFieldSize = maxFieldSize;
        }

        public boolean isMaxRows() {
            return this.maxRows;
        }

        public void setMaxRows(boolean maxRows) {
            this.maxRows = maxRows;
        }

        public boolean isFetchDirection() {
            return this.fetchDirection;
        }

        public void setFetchDirection(boolean fetchDirection) {
            this.fetchDirection = fetchDirection;
        }

        public boolean isFetchSize() {
            return this.fetchSize;
        }

        public void setFetchSize(boolean fetchSize) {
            this.fetchSize = fetchSize;
        }

        public boolean isQueryTimeout() {
            return this.queryTimeout;
        }

        public void setQueryTimeout(boolean queryTimeout) {
            this.queryTimeout = queryTimeout;
        }

        public boolean isEscapeProcessing() {
            return this.escapeProcessing;
        }

        public void setEscapeProcessing(boolean escapeProcessing) {
            this.escapeProcessing = escapeProcessing;
        }

        public boolean isCloseOnCompletion() {
            return this.closeOnCompletion;
        }

        public void setCloseOnCompletion(boolean closeOnCompletion) {
            this.closeOnCompletion = closeOnCompletion;
        }

        public boolean isPoolable() {
            return this.poolable;
        }

        public void setPoolable(boolean poolable) {
            this.poolable = poolable;
        }
    }

    private class StatementPropertyBean {
        private int maxFieldSize;
        private int maxRows;
        private int fetchDirection;
        private int fetchSize;
        private int queryTimeout;
        private boolean escapeProcessing;
        private boolean closeOnCompletion;
        private boolean poolable;

        private StatementPropertyBean() {
        }

        public int getMaxFieldSize() {
            return this.maxFieldSize;
        }

        public void setMaxFieldSize(int maxFieldSize) {
            this.maxFieldSize = maxFieldSize;
        }

        public int getMaxRows() {
            return this.maxRows;
        }

        public void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }

        public int getFetchDirection() {
            return this.fetchDirection;
        }

        public void setFetchDirection(int fetchDirection) {
            this.fetchDirection = fetchDirection;
        }

        public int getFetchSize() {
            return this.fetchSize;
        }

        public void setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        public int getQueryTimeout() {
            return this.queryTimeout;
        }

        public void setQueryTimeout(int queryTimeout) {
            this.queryTimeout = queryTimeout;
        }

        public boolean isEscapeProcessing() {
            return this.escapeProcessing;
        }

        public void setEscapeProcessing(boolean escapeProcessing) {
            this.escapeProcessing = escapeProcessing;
        }

        public boolean isCloseOnCompletion() {
            return this.closeOnCompletion;
        }

        public void setCloseOnCompletion(boolean closeOnCompletion) {
            this.closeOnCompletion = closeOnCompletion;
        }

        public boolean isPoolable() {
            return this.poolable;
        }

        public void setPoolable(boolean poolable) {
            this.poolable = poolable;
        }
    }
}

