/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.datasource.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hellojavaer.ddal.ddr.datasource.exception.CrossDataSourceException;
import org.hellojavaer.ddal.ddr.datasource.exception.StatementInitializationException;
import org.hellojavaer.ddal.ddr.datasource.exception.UninitializedStatusException;
import org.hellojavaer.ddal.ddr.datasource.exception.UnsupportedPreparedStatementInvocationException;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DDRPreparedStatement;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DDRStatementImpl;
import org.hellojavaer.ddal.ddr.datasource.manager.DataSourceParam;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedResult;
import org.hellojavaer.ddal.ddr.utils.DDRJSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DDRPreparedStatementImpl
extends DDRStatementImpl
implements DDRPreparedStatement {
    private Logger stdLogger = LoggerFactory.getLogger((String)"org.hellojavaer.ddr.sql");
    private String sql = null;
    protected PreparedStatement preparedStatement = null;
    private Map<Object, Object> jdbcParameter = new HashMap<Object, Object>();
    private List<JdbcParamInvocation> jdbcParamInvocationList = null;
    private SQLParsedResult sqlParsedResult = null;

    public DDRPreparedStatementImpl(String sql, boolean readOnly, Set<String> schemas) {
        super(readOnly, schemas);
        this.sql = sql;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.initPreparedStatementIfAbsent();
        return this.preparedStatement.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.initPreparedStatementIfAbsent();
        return this.preparedStatement.executeUpdate();
    }

    @Override
    public boolean execute() throws SQLException {
        this.initPreparedStatementIfAbsent();
        return this.preparedStatement.execute();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.initPreparedStatementIfAbsent();
        return this.preparedStatement.executeBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.jdbcParameter.clear();
        if (this.jdbcParamInvocationList != null) {
            this.jdbcParamInvocationList.clear();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearBatch();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.initPreparedStatementIfAbsent();
        this.preparedStatement.addBatch();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.preparedStatement == null) {
            throw new UninitializedStatusException("Can't invoke 'addBatch(String sql)' before preparedStatement is initialized");
        }
        super.addBatch(sql);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getParameterMetaData();
        }
        throw new UninitializedStatusException("Can't invoke 'getParameterMetaData()' before preparedStatement is initialized");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getUpdateCount();
        }
        throw new UninitializedStatusException("Can't invoke 'getUpdateCount()' before preparedStatement is initialized");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getResultSetConcurrency();
        }
        throw new UninitializedStatusException("Can't invoke 'getResultSetConcurrency()' before preparedStatement is initialized");
    }

    private void initPreparedStatementIfAbsent() throws SQLException {
        if (this.preparedStatement == null) {
            SQLParsedResult parsedResult = this.parseSql(this.sql, this.jdbcParameter);
            if (this.stdLogger.isDebugEnabled()) {
                this.stdLogger.debug("[ParseSql] from:" + this.sql + " =>to: " + parsedResult.getSql());
                if (this.stdLogger.isTraceEnabled()) {
                    this.stdLogger.trace("[JdbcParameter] " + DDRJSONUtils.toJSONString(this.jdbcParameter));
                }
            }
            this.sqlParsedResult = parsedResult;
            if (this.isCrossDataSource(parsedResult.getSchemas())) {
                throw new CrossDataSourceException("Current sql is using schemas:" + DDRJSONUtils.toJSONString(parsedResult.getSchemas()) + ", but current datasource is bound on schemas:" + DDRJSONUtils.toJSONString(this.schemas) + ". Detail information: original sql is [" + this.sql + "] and jdbc parameter is " + DDRJSONUtils.toJSONString(this.jdbcParameter));
            }
            DataSourceParam param = new DataSourceParam();
            param.setReadOnly(this.readOnly);
            param.setScNames(parsedResult.getSchemas());
            try {
                this.initStatementIfAbsent(param, parsedResult.getSql());
            }
            catch (Throwable e) {
                throw new StatementInitializationException("readOnly:" + this.readOnly + " ,jdbc parameter:" + DDRJSONUtils.toJSONString(this.jdbcParameter) + " ,SQLParsedResult:" + parsedResult + " ,original sql:[" + this.sql + "]", e);
            }
            super.playbackInvocation(this.statement);
            this.playbackSetJdbcParamInvocation(this.preparedStatement, this.jdbcParamInvocationList);
        } else {
            this.sqlParsedResult.checkIfCrossPreparedStatement(this.jdbcParameter);
        }
    }

    @Override
    protected void initStatementIfAbsent(DataSourceParam param, String sql) throws SQLException {
        super.initStatementIfAbsent(param, sql);
        this.preparedStatement = (PreparedStatement)this.statement;
    }

    protected void playbackSetJdbcParamInvocation(PreparedStatement preparedStatement, List<JdbcParamInvocation> jdbcParamInvocationList) throws SQLException {
        if (jdbcParamInvocationList == null || jdbcParamInvocationList.isEmpty()) {
            return;
        }
        block50: for (JdbcParamInvocation item : jdbcParamInvocationList) {
            JdbcParamSetMethod method = item.getMethod();
            int index = item.getIndex();
            Object[] params = item.getParams();
            switch (method) {
                case setBoolean_boolean: {
                    preparedStatement.setBoolean(index, (Boolean)params[0]);
                    continue block50;
                }
                case setByte_byte: {
                    preparedStatement.setByte(index, (Byte)params[0]);
                    continue block50;
                }
                case setShort_short: {
                    preparedStatement.setShort(index, (Short)params[0]);
                    continue block50;
                }
                case setInt_int: {
                    preparedStatement.setInt(index, (Integer)params[0]);
                    continue block50;
                }
                case setLong_long: {
                    preparedStatement.setLong(index, (Long)params[0]);
                    continue block50;
                }
                case setFloat_float: {
                    preparedStatement.setFloat(index, ((Float)params[0]).floatValue());
                    continue block50;
                }
                case setDouble_double: {
                    preparedStatement.setDouble(index, (Double)params[0]);
                    continue block50;
                }
                case setTimestamp_Timestamp: {
                    preparedStatement.setTimestamp(index, (Timestamp)params[0]);
                    continue block50;
                }
                case setTimestamp_Timestamp_Calendar: {
                    preparedStatement.setTimestamp(index, (Timestamp)params[0], (Calendar)params[1]);
                    continue block50;
                }
                case setURL_URL: {
                    preparedStatement.setURL(index, (URL)params[0]);
                    continue block50;
                }
                case setTime_Time_Calendar: {
                    preparedStatement.setTime(index, (Time)params[0], (Calendar)params[1]);
                    continue block50;
                }
                case setTime_Time: {
                    preparedStatement.setTime(index, (Time)params[0]);
                    continue block50;
                }
                case setArray_Array: {
                    preparedStatement.setArray(index, (Array)params[0]);
                    continue block50;
                }
                case setObject_Object_int: {
                    preparedStatement.setObject(index, params[0], (Integer)params[1]);
                    continue block50;
                }
                case setObject_Object_int_int: {
                    preparedStatement.setObject(index, params[0], (Integer)params[1], (int)((Integer)params[2]));
                    continue block50;
                }
                case setObject_Object: {
                    preparedStatement.setObject(index, params[0]);
                    continue block50;
                }
                case setNull_int_String: {
                    preparedStatement.setNull(index, (Integer)params[0], (String)params[1]);
                    continue block50;
                }
                case setNull_int: {
                    preparedStatement.setNull(index, (Integer)params[0]);
                    continue block50;
                }
                case setBigDecimal_BigDecimal: {
                    preparedStatement.setBigDecimal(index, (BigDecimal)params[0]);
                    continue block50;
                }
                case setString_String: {
                    preparedStatement.setString(index, (String)params[0]);
                    continue block50;
                }
                case setBytes_bytes: {
                    preparedStatement.setBytes(index, (byte[])params[0]);
                    continue block50;
                }
                case setDate_Date_Calendar: {
                    preparedStatement.setDate(index, (Date)params[0], (Calendar)params[1]);
                    continue block50;
                }
                case setDate_Date: {
                    preparedStatement.setDate(index, (Date)params[0]);
                    continue block50;
                }
                case setAsciiStream_InputStream_int: {
                    preparedStatement.setAsciiStream(index, (InputStream)params[0], (Integer)params[1]);
                    continue block50;
                }
                case setAsciiStream_InputStream_long: {
                    preparedStatement.setAsciiStream(index, (InputStream)params[0], (Long)params[1]);
                    continue block50;
                }
                case setAsciiStream_InputStream: {
                    preparedStatement.setAsciiStream(index, (InputStream)params[0]);
                    continue block50;
                }
                case setUnicodeStream_InputStream_int: {
                    preparedStatement.setUnicodeStream(index, (InputStream)params[0], (Integer)params[1]);
                    continue block50;
                }
                case setBinaryStream_InputStream_int: {
                    preparedStatement.setBinaryStream(index, (InputStream)params[0], (Integer)params[1]);
                    continue block50;
                }
                case setBinaryStream_InputStream_long: {
                    preparedStatement.setBinaryStream(index, (InputStream)params[0], (Long)params[1]);
                    continue block50;
                }
                case setBinaryStream_InputStream: {
                    preparedStatement.setBinaryStream(index, (InputStream)params[0]);
                    continue block50;
                }
                case setCharacterStream_Reader_int: {
                    preparedStatement.setCharacterStream(index, (Reader)params[0], (Integer)params[1]);
                    continue block50;
                }
                case setCharacterStream_Reader_long: {
                    preparedStatement.setCharacterStream(index, (Reader)params[0], (Long)params[1]);
                    continue block50;
                }
                case setCharacterStream_Reader: {
                    preparedStatement.setCharacterStream(index, (Reader)params[0]);
                    continue block50;
                }
                case setRef_Ref: {
                    preparedStatement.setRef(index, (Ref)params[0]);
                    continue block50;
                }
                case setBlob_InputStream_long: {
                    preparedStatement.setBlob(index, (InputStream)params[0], (Long)params[1]);
                    continue block50;
                }
                case setBlob_InputStream: {
                    preparedStatement.setBlob(index, (InputStream)params[0]);
                    continue block50;
                }
                case setBlob_Blob: {
                    preparedStatement.setBlob(index, (Blob)params[0]);
                    continue block50;
                }
                case setClob_Reader: {
                    preparedStatement.setClob(index, (Reader)params[0]);
                    continue block50;
                }
                case setClob_Reader_long: {
                    preparedStatement.setClob(index, (Reader)params[0], (Long)params[1]);
                    continue block50;
                }
                case setClob_Clob: {
                    preparedStatement.setClob(index, (Clob)params[0]);
                    continue block50;
                }
                case setRowId_RowId: {
                    preparedStatement.setRowId(index, (RowId)params[0]);
                    continue block50;
                }
                case setNString_String: {
                    preparedStatement.setNString(index, (String)params[0]);
                    continue block50;
                }
                case setNCharacterStream_Reader: {
                    preparedStatement.setNCharacterStream(index, (Reader)params[0]);
                    continue block50;
                }
                case setNCharacterStream_Reader_long: {
                    preparedStatement.setNCharacterStream(index, (Reader)params[0], (Long)params[1]);
                    continue block50;
                }
                case setNClob_Reader_long: {
                    preparedStatement.setNClob(index, (Reader)params[0], (Long)params[1]);
                    continue block50;
                }
                case setNClob_NClob: {
                    preparedStatement.setNClob(index, (NClob)params[0]);
                    continue block50;
                }
                case setNClob_Reader: {
                    preparedStatement.setNClob(index, (Reader)params[0]);
                    continue block50;
                }
                case setSQLXML_SQLXML: {
                    preparedStatement.setSQLXML(index, (SQLXML)params[0]);
                    continue block50;
                }
            }
            throw new UnsupportedPreparedStatementInvocationException("Unknown setter method '" + (Object)((Object)method) + "'");
        }
        jdbcParamInvocationList = null;
    }

    private void addJdbcParamInvokeRecord(JdbcParamSetMethod method, int index, Object[] params) {
        if (this.jdbcParamInvocationList == null) {
            this.jdbcParamInvocationList = new ArrayList<JdbcParamInvocation>();
        }
        this.jdbcParamInvocationList.add(new JdbcParamInvocation(method, index, params));
    }

    @Override
    public void setBoolean(int x0, boolean x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBoolean(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBoolean_boolean, x0, new Object[]{x1});
        }
    }

    @Override
    public void setByte(int x0, byte x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setByte(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setByte_byte, x0, new Object[]{x1});
        }
    }

    @Override
    public void setShort(int x0, short x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setShort(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setShort_short, x0, new Object[]{x1});
        }
    }

    @Override
    public void setInt(int x0, int x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setInt(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setInt_int, x0, new Object[]{x1});
        }
    }

    @Override
    public void setLong(int x0, long x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setLong(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setLong_long, x0, new Object[]{x1});
        }
    }

    @Override
    public void setFloat(int x0, float x1) throws SQLException {
        this.jdbcParameter.put(x0, Float.valueOf(x1));
        if (this.preparedStatement != null) {
            this.preparedStatement.setFloat(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setFloat_float, x0, new Object[]{Float.valueOf(x1)});
        }
    }

    @Override
    public void setDouble(int x0, double x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setDouble(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setDouble_double, x0, new Object[]{x1});
        }
    }

    @Override
    public void setTimestamp(int x0, Timestamp x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setTimestamp(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setTimestamp_Timestamp, x0, new Object[]{x1});
        }
    }

    @Override
    public void setTimestamp(int x0, Timestamp x1, Calendar x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setTimestamp(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setTimestamp_Timestamp_Calendar, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setURL(int x0, URL x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setURL(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setURL_URL, x0, new Object[]{x1});
        }
    }

    @Override
    public void setTime(int x0, Time x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setTime(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setTime_Time, x0, new Object[]{x1});
        }
    }

    @Override
    public void setTime(int x0, Time x1, Calendar x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setTime(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setTime_Time_Calendar, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setNull(int x0, int x1, String x2) throws SQLException {
        this.jdbcParameter.put(x0, null);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNull_int_String, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setNull(int x0, int x1) throws SQLException {
        this.jdbcParameter.put(x0, null);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNull_int, x0, new Object[]{x1});
        }
    }

    @Override
    public void setBigDecimal(int x0, BigDecimal x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBigDecimal(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBigDecimal_BigDecimal, x0, new Object[]{x1});
        }
    }

    @Override
    public void setString(int x0, String x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setString(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setString_String, x0, new Object[]{x1});
        }
    }

    @Override
    public void setBytes(int x0, byte[] x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBytes(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBytes_bytes, x0, new Object[]{x1});
        }
    }

    @Override
    public void setDate(int x0, Date x1, Calendar x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setDate(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setDate_Date_Calendar, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setDate(int x0, Date x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setDate(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setDate_Date, x0, new Object[]{x1});
        }
    }

    @Override
    public void setAsciiStream(int x0, InputStream x1, int x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setAsciiStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setAsciiStream_InputStream_int, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setAsciiStream(int x0, InputStream x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setAsciiStream(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setAsciiStream_InputStream, x0, new Object[]{x1});
        }
    }

    @Override
    public void setAsciiStream(int x0, InputStream x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setAsciiStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setAsciiStream_InputStream_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setUnicodeStream(int x0, InputStream x1, int x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setUnicodeStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setUnicodeStream_InputStream_int, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setBinaryStream(int x0, InputStream x1, int x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBinaryStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBinaryStream_InputStream_int, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setBinaryStream(int x0, InputStream x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBinaryStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBinaryStream_InputStream_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setBinaryStream(int x0, InputStream x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBinaryStream(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBinaryStream_InputStream, x0, new Object[]{x1});
        }
    }

    @Override
    public void setObject(int x0, Object x1, int x2, int x3) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setObject(x0, x1, x2, x3);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setObject_Object_int_int, x0, new Object[]{x1, x2, x3});
        }
    }

    @Override
    public void setObject(int x0, Object x1, int x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setObject(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setObject_Object_int, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setObject(int x0, Object x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setObject(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setObject_Object, x0, new Object[]{x1});
        }
    }

    @Override
    public void setCharacterStream(int x0, Reader x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setCharacterStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setCharacterStream_Reader_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setCharacterStream(int x0, Reader x1, int x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setCharacterStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setCharacterStream_Reader_int, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setCharacterStream(int x0, Reader x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setCharacterStream(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setCharacterStream_Reader, x0, new Object[]{x1});
        }
    }

    @Override
    public void setRef(int x0, Ref x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setRef(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setRef_Ref, x0, new Object[]{x1});
        }
    }

    @Override
    public void setBlob(int x0, InputStream x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBlob(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBlob_InputStream_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setBlob(int x0, InputStream x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBlob(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBlob_InputStream, x0, new Object[]{x1});
        }
    }

    @Override
    public void setBlob(int x0, Blob x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setBlob(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setBlob_Blob, x0, new Object[]{x1});
        }
    }

    @Override
    public void setClob(int x0, Reader x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setClob(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setClob_Reader, x0, new Object[]{x1});
        }
    }

    @Override
    public void setClob(int x0, Clob x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setClob(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setClob_Clob, x0, new Object[]{x1});
        }
    }

    @Override
    public void setClob(int x0, Reader x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setClob(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setClob_Reader_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setArray(int x0, Array x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setArray(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setArray_Array, x0, new Object[]{x1});
        }
    }

    @Override
    public void setRowId(int x0, RowId x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setRowId(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setRowId_RowId, x0, new Object[]{x1});
        }
    }

    @Override
    public void setNString(int x0, String x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNString(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNString_String, x0, new Object[]{x1});
        }
    }

    @Override
    public void setNCharacterStream(int x0, Reader x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNCharacterStream(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNCharacterStream_Reader, x0, new Object[]{x1});
        }
    }

    @Override
    public void setNCharacterStream(int x0, Reader x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNCharacterStream(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNCharacterStream_Reader_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setNClob(int x0, Reader x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNClob(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNClob_Reader, x0, new Object[]{x1});
        }
    }

    @Override
    public void setNClob(int x0, Reader x1, long x2) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNClob(x0, x1, x2);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNClob_Reader_long, x0, new Object[]{x1, x2});
        }
    }

    @Override
    public void setNClob(int x0, NClob x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setNClob(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setNClob_NClob, x0, new Object[]{x1});
        }
    }

    @Override
    public void setSQLXML(int x0, SQLXML x1) throws SQLException {
        this.jdbcParameter.put(x0, x1);
        if (this.preparedStatement != null) {
            this.preparedStatement.setSQLXML(x0, x1);
        } else {
            this.addJdbcParamInvokeRecord(JdbcParamSetMethod.setSQLXML_SQLXML, x0, new Object[]{x1});
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getMetaData();
        }
        return null;
    }

    private static enum JdbcParamSetMethod {
        setBoolean_boolean,
        setByte_byte,
        setShort_short,
        setInt_int,
        setLong_long,
        setFloat_float,
        setDouble_double,
        setTimestamp_Timestamp,
        setTimestamp_Timestamp_Calendar,
        setURL_URL,
        setTime_Time,
        setTime_Time_Calendar,
        setNull_int_String,
        setNull_int,
        setBigDecimal_BigDecimal,
        setString_String,
        setBytes_bytes,
        setDate_Date_Calendar,
        setDate_Date,
        setAsciiStream_InputStream_int,
        setAsciiStream_InputStream,
        setAsciiStream_InputStream_long,
        setUnicodeStream_InputStream_int,
        setBinaryStream_InputStream_int,
        setBinaryStream_InputStream_long,
        setBinaryStream_InputStream,
        setObject_Object_int_int,
        setObject_Object_int,
        setObject_Object,
        setCharacterStream_Reader_long,
        setCharacterStream_Reader_int,
        setCharacterStream_Reader,
        setRef_Ref,
        setBlob_InputStream_long,
        setBlob_InputStream,
        setBlob_Blob,
        setClob_Reader,
        setClob_Clob,
        setClob_Reader_long,
        setArray_Array,
        setRowId_RowId,
        setNString_String,
        setNCharacterStream_Reader,
        setNCharacterStream_Reader_long,
        setNClob_Reader,
        setNClob_Reader_long,
        setNClob_NClob,
        setSQLXML_SQLXML;

    }

    private class JdbcParamInvocation {
        private JdbcParamSetMethod method;
        private int index;
        private Object[] params;

        public JdbcParamInvocation(JdbcParamSetMethod method, int index, Object[] params) {
            this.method = method;
            this.index = index;
            this.params = params;
        }

        public JdbcParamSetMethod getMethod() {
            return this.method;
        }

        public void setMethod(JdbcParamSetMethod method) {
            this.method = method;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }

        public Class<?> getParamTypes() {
            return null;
        }

        public String getMethodName() {
            return null;
        }
    }
}

