/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.ddr.datasource.jdbc;

import java.io.PrintWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import org.hellojavaer.ddal.ddr.datasource.exception.DataSourceNotFoundException;
import org.hellojavaer.ddal.ddr.datasource.exception.UninitializedStatusException;
import org.hellojavaer.ddal.ddr.datasource.exception.UnsupportedConnectionInvocationException;
import org.hellojavaer.ddal.ddr.datasource.exception.UnsupportedDataSourceInvocationException;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DDRDataSource;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DDRPreparedStatementImpl;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DDRStatementImpl;
import org.hellojavaer.ddal.ddr.datasource.jdbc.DataSourceWrapper;
import org.hellojavaer.ddal.ddr.datasource.jdbc.StatementWrapper;
import org.hellojavaer.ddal.ddr.datasource.jdbc.init.UninitializedConnectionProcessor;
import org.hellojavaer.ddal.ddr.datasource.jdbc.init.UninitializedDataSourceProcessor;
import org.hellojavaer.ddal.ddr.datasource.jdbc.property.ConnectionProperty;
import org.hellojavaer.ddal.ddr.datasource.jdbc.property.DataSourceProperty;
import org.hellojavaer.ddal.ddr.datasource.manager.DataSourceParam;
import org.hellojavaer.ddal.ddr.sqlparse.SQLParsedResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDDRDataSource
implements DDRDataSource {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private DataSourceWrapper getDataSource0(DataSourceParam param) throws SQLException {
        DataSourceWrapper dataSourceWrapper = this.getDataSource(param);
        if (dataSourceWrapper == null) {
            throw new DataSourceNotFoundException("No datasource found for parameter:" + param.toString());
        }
        return dataSourceWrapper;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return java.util.logging.Logger.getLogger("global");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        if (UninitializedDataSourceProcessor.isSetDefaultValue(DataSourceProperty.loginTimeout)) {
            int val = ((Number)UninitializedDataSourceProcessor.getDefaultValue(DataSourceProperty.loginTimeout)).intValue();
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getLoginTimeout()' when 'loginTimeout' isn't set default value");
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new UnsupportedDataSourceInvocationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (UninitializedDataSourceProcessor.isSetDefaultValue(DataSourceProperty.logWriter)) {
            PrintWriter val = (PrintWriter)UninitializedDataSourceProcessor.getDefaultValue(DataSourceProperty.logWriter);
            return val;
        }
        throw new UninitializedStatusException("Can't invoke 'getLogWriter()' when 'logWriter' isn't set default value");
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        throw new UnsupportedDataSourceInvocationException("setLogWriter");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new ConnectionWrapper(){

            @Override
            public ConnectionResult getConnection(DataSourceParam param) throws SQLException {
                DataSourceWrapper dataSourceWrapper = AbstractDDRDataSource.this.getDataSource0(param);
                return new ConnectionResult(dataSourceWrapper.getDataSource().getConnection(), dataSourceWrapper.getSchemas());
            }
        };
    }

    @Override
    public Connection getConnection(final String username, final String password) throws SQLException {
        return new ConnectionWrapper(){

            @Override
            public ConnectionResult getConnection(DataSourceParam param) throws SQLException {
                DataSourceWrapper dataSourceWrapper = AbstractDDRDataSource.this.getDataSource0(param);
                return new ConnectionResult(dataSourceWrapper.getDataSource().getConnection(username, password), dataSourceWrapper.getSchemas());
            }
        };
    }

    private abstract class ConnectionWrapper
    implements Connection {
        private volatile ConnectionResult connectionResult;
        private volatile ConnectionPropertyBean prop = new ConnectionPropertyBean();
        private volatile InvocationTag tag = new InvocationTag();

        private ConnectionWrapper() {
        }

        private boolean isReadOnly0() {
            return this.prop.isReadOnly();
        }

        private Set<String> getSchemas0() {
            if (this.connectionResult == null) {
                return null;
            }
            return this.connectionResult.getSchemas();
        }

        public abstract ConnectionResult getConnection(DataSourceParam var1) throws SQLException;

        private Connection getConnection1() {
            if (this.connectionResult == null) {
                return null;
            }
            return this.connectionResult.getConnection();
        }

        private void closeConnection0(Connection connection) {
            block3: {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        if (!AbstractDDRDataSource.this.logger.isWarnEnabled()) break block3;
                        AbstractDDRDataSource.this.logger.warn("[closeConnection]", (Throwable)e);
                    }
                }
            }
        }

        private ConnectionResult getConnection0(DataSourceParam param) throws SQLException {
            if (this.connectionResult == null || this.connectionResult.getConnection().getAutoCommit()) {
                if (this.connectionResult != null && this.connectionResult.getConnection() != null) {
                    this.closeConnection0(this.connectionResult.getConnection());
                }
                ConnectionResult connectionResult = this.getConnection(param);
                Connection connection = connectionResult.getConnection();
                if (this.tag.isAutoCommit()) {
                    connection.setAutoCommit(this.prop.isAutoCommit());
                }
                if (this.tag.isReadOnly()) {
                    connection.setReadOnly(this.prop.isReadOnly());
                }
                if (this.tag.isSchema()) {
                    connection.setSchema(this.prop.getSchema());
                }
                if (this.tag.isTypeMap()) {
                    connection.setTypeMap(this.prop.getTypeMap());
                }
                if (this.tag.isTransactionIsolation()) {
                    connection.setTransactionIsolation(this.prop.getTransactionIsolation());
                }
                if (this.tag.isHoldability()) {
                    connection.setHoldability(this.prop.getHoldability());
                }
                if (this.tag.isCatalog()) {
                    connection.setCatalog(this.prop.getCatalog());
                }
                this.connectionResult = connectionResult;
            }
            return this.connectionResult;
        }

        @Override
        public Statement createStatement() throws SQLException {
            return new DDRStatementImpl(this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String sql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        Statement statement = connectionResult.getConnection().createStatement();
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return new DDRPreparedStatementImpl(sql, this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String routedSql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        PreparedStatement statement = connectionResult.getConnection().prepareStatement(routedSql);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public Statement createStatement(final int resultSetType, final int resultSetConcurrency) throws SQLException {
            return new DDRStatementImpl(this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String sql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        Statement statement = connectionResult.getConnection().createStatement(resultSetType, resultSetConcurrency);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
            return new DDRPreparedStatementImpl(sql, this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String routedSql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        PreparedStatement statement = connectionResult.getConnection().prepareStatement(routedSql, resultSetType, resultSetConcurrency);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public Statement createStatement(final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
            return new DDRStatementImpl(this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String sql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        Statement statement = this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
            return new DDRPreparedStatementImpl(sql, this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String routedSql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        PreparedStatement statement = this.connection.prepareStatement(routedSql, resultSetType, resultSetConcurrency, resultSetHoldability);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(String sql, final int autoGeneratedKeys) throws SQLException {
            return new DDRPreparedStatementImpl(sql, this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String routedSql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        PreparedStatement statement = this.connection.prepareStatement(routedSql, autoGeneratedKeys);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(String sql, final int[] columnIndexes) throws SQLException {
            return new DDRPreparedStatementImpl(sql, this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String routedSql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        PreparedStatement statement = connectionResult.getConnection().prepareStatement(routedSql, columnIndexes);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(String sql, final String[] columnNames) throws SQLException {
            return new DDRPreparedStatementImpl(sql, this.isReadOnly0(), this.getSchemas0()){

                @Override
                public SQLParsedResult parseSql(String sql, Map<Object, Object> jdbcParams) throws SQLException {
                    return AbstractDDRDataSource.this.parseSql(sql, jdbcParams);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public StatementWrapper getStatement(DataSourceParam param, String routedSql) throws SQLException {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        ConnectionResult connectionResult = ConnectionWrapper.this.getConnection0(param);
                        PreparedStatement statement = connectionResult.getConnection().prepareStatement(routedSql, columnNames);
                        return new StatementWrapper(ConnectionWrapper.this, statement, connectionResult.getSchemas());
                    }
                }
            };
        }

        @Override
        public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setAutoCommit(autoCommit);
            }
            this.tag.setAutoCommit(true);
            this.prop.setAutoCommit(autoCommit);
        }

        @Override
        public synchronized void setReadOnly(boolean readOnly) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setReadOnly(readOnly);
            }
            this.tag.setReadOnly(true);
            this.prop.setReadOnly(readOnly);
        }

        @Override
        public synchronized void setCatalog(String catalog) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setCatalog(catalog);
            }
            this.tag.setCatalog(true);
            this.prop.setCatalog(catalog);
        }

        @Override
        public synchronized void setTransactionIsolation(int level) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setTransactionIsolation(level);
            }
            this.tag.setTransactionIsolation(true);
            this.prop.setTransactionIsolation(level);
        }

        @Override
        public synchronized SQLWarning getWarnings() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getWarnings();
            }
            throw new UninitializedStatusException("Can't invoke 'getWarnings()' before connection is initialized");
        }

        @Override
        public synchronized void clearWarnings() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'clearWarnings()' before connection is initialized");
            }
            connection.clearWarnings();
        }

        @Override
        public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setTypeMap(map);
            }
            this.tag.setTypeMap(true);
            this.prop.setTypeMap(map);
        }

        @Override
        public synchronized void setHoldability(int holdability) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setHoldability(holdability);
            }
            this.tag.setHoldability(true);
            this.prop.setHoldability(holdability);
        }

        @Override
        public synchronized void setSchema(String schema) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                connection.setSchema(schema);
            }
            this.tag.setSchema(true);
            this.prop.setSchema(schema);
        }

        @Override
        public synchronized void setClientInfo(String name, String value) throws SQLClientInfoException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'setClientInfo(String name, String value)' before connection is initialized");
            }
            connection.setClientInfo(name, value);
        }

        @Override
        public synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'setClientInfo(Properties properties)' before connection is initialized");
            }
            connection.setClientInfo(properties);
        }

        @Override
        public synchronized String getClientInfo(String name) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getClientInfo(name);
            }
            throw new UninitializedStatusException("Can't invoke 'getClientInfo(String name)' before connection is initialized");
        }

        @Override
        public synchronized Properties getClientInfo() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getClientInfo();
            }
            throw new UninitializedStatusException("Can't invoke 'getClientInfo()' before connection is initialized");
        }

        @Override
        public synchronized void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'setNetworkTimeout(Executor executor, int milliseconds)' before connection is initialized");
            }
            connection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public synchronized int getNetworkTimeout() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getNetworkTimeout();
            }
            throw new UninitializedStatusException("Can't invoke 'getNetworkTimeout()' before connection is initialized");
        }

        @Override
        public synchronized Savepoint setSavepoint() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.setSavepoint();
            }
            throw new UninitializedStatusException("Can't invoke 'setSavepoint()' before connection is initialized");
        }

        @Override
        public synchronized Savepoint setSavepoint(String name) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.setSavepoint(name);
            }
            throw new UninitializedStatusException("Can't invoke 'setSavepoint(name)' before connection is initialized");
        }

        @Override
        public synchronized void rollback(Savepoint savepoint) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'rollback(Savepoint savepoint)' before connection is initialized");
            }
            connection.rollback(savepoint);
        }

        @Override
        public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'releaseSavepoint(Savepoint savepoint)' before connection is initialized");
            }
            connection.releaseSavepoint(savepoint);
        }

        @Override
        public synchronized Clob createClob() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.createClob();
            }
            throw new UninitializedStatusException("Can't invoke 'createClob()' before connection is initialized");
        }

        @Override
        public synchronized Blob createBlob() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.createBlob();
            }
            throw new UninitializedStatusException("Can't invoke 'createBlob()' before connection is initialized");
        }

        @Override
        public synchronized NClob createNClob() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.createNClob();
            }
            throw new UninitializedStatusException("Can't invoke 'createNClob()' before connection is initialized");
        }

        @Override
        public synchronized SQLXML createSQLXML() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.createSQLXML();
            }
            throw new UninitializedStatusException("Can't invoke 'createSQLXML()' before connection is initialized");
        }

        @Override
        public synchronized boolean isValid(int timeout) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.isValid(timeout);
            }
            throw new UninitializedStatusException("Can't invoke 'isValid(int timeout)' before connection is initialized");
        }

        @Override
        public synchronized Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.createArrayOf(typeName, elements);
            }
            throw new UninitializedStatusException("Can't invoke 'createArrayOf(String typeName, Object[] elements)' before connection is initialized");
        }

        @Override
        public synchronized Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.createStruct(typeName, attributes);
            }
            throw new UninitializedStatusException("Can't invoke 'createStruct(String typeName, Object[] attributes)' before connection is initialized");
        }

        @Override
        public synchronized void commit() throws SQLException {
            if (this.connectionResult != null) {
                this.connectionResult.getConnection().commit();
                this.closeConnection0(this.connectionResult.getConnection());
                this.connectionResult = null;
            }
        }

        @Override
        public synchronized void rollback() throws SQLException {
            if (this.connectionResult != null) {
                this.connectionResult.getConnection().rollback();
                this.closeConnection0(this.connectionResult.getConnection());
                this.connectionResult = null;
            }
        }

        @Override
        public synchronized void close() throws SQLException {
            if (this.connectionResult != null) {
                this.connectionResult.getConnection().close();
                this.connectionResult = null;
            }
        }

        @Override
        public synchronized boolean isClosed() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.isClosed();
            }
            return false;
        }

        @Override
        public synchronized void abort(Executor executor) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection == null) {
                throw new UninitializedStatusException("Can't invoke 'abort(Executor executor)' before connection is initialized");
            }
            connection.abort(executor);
        }

        @Override
        public synchronized String nativeSQL(String sql) throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.nativeSQL(sql);
            }
            throw new UninitializedStatusException("Can't invoke 'nativeSQL(String sql)' before connection is initialized");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (iface.isInstance(this)) {
                return (T)this;
            }
            throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isInstance(this);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            throw new UnsupportedConnectionInvocationException("prepareCall");
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            throw new UnsupportedConnectionInvocationException("prepareCall");
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            throw new UnsupportedConnectionInvocationException("prepareCall");
        }

        @Override
        public synchronized boolean isReadOnly() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.isReadOnly();
            }
            if (this.tag.isReadOnly()) {
                return this.prop.isReadOnly();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.readOnly)) {
                boolean val = (Boolean)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.readOnly);
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.readOnly)) {
                    this.prop.setReadOnly(val);
                    this.tag.setReadOnly(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'isReadOnly()' before 'setReadOnly(boolean readOnly)' is invoked");
        }

        @Override
        public synchronized String getCatalog() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getCatalog();
            }
            if (this.tag.isCatalog()) {
                return this.prop.getCatalog();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.catalog)) {
                String val = (String)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.catalog);
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.catalog)) {
                    this.prop.setCatalog(val);
                    this.tag.setCatalog(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getCatalog()' before 'setCatalog(String catalog)' is invoked or connection is initialized");
        }

        @Override
        public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getTypeMap();
            }
            if (this.tag.isTypeMap()) {
                return this.prop.getTypeMap();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.typeMap)) {
                Map val = (Map)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.typeMap);
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.typeMap)) {
                    this.prop.setTypeMap(val);
                    this.tag.setTypeMap(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getTypeMap()' before 'setTypeMap(Map<String, Class<?>> map)' is invoked or connection is initialized");
        }

        @Override
        public synchronized int getHoldability() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getHoldability();
            }
            if (this.tag.isHoldability()) {
                return this.prop.getHoldability();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.holdability)) {
                int val = ((Number)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.holdability)).intValue();
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.holdability)) {
                    this.prop.setHoldability(val);
                    this.tag.setHoldability(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getHoldability()' before 'setHoldability(int holdability)' is invoked or connection is initialized");
        }

        @Override
        public synchronized DatabaseMetaData getMetaData() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getMetaData();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.metaData)) {
                DatabaseMetaData val = (DatabaseMetaData)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.metaData);
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.metaData)) {
                    this.prop.setMetaData(val);
                    this.tag.setMetaData(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getMetaData()' before connection is initialized");
        }

        @Override
        public synchronized String getSchema() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getSchema();
            }
            if (this.tag.isSchema()) {
                return this.prop.getSchema();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.schema)) {
                String val = (String)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.schema);
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.schema)) {
                    this.prop.setSchema(val);
                    this.tag.setSchema(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getSchema()' before 'setSchema(String schema)' is invoked or connection is initialized");
        }

        @Override
        public synchronized int getTransactionIsolation() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getTransactionIsolation();
            }
            if (this.tag.isTransactionIsolation()) {
                return this.prop.getTransactionIsolation();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.transactionIsolation)) {
                int val = ((Number)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.transactionIsolation)).intValue();
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.transactionIsolation)) {
                    this.prop.setTransactionIsolation(val);
                    this.tag.setTransactionIsolation(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getTransactionIsolation()' before 'setTransactionIsolation(int level)' is invoked or connection is initialized");
        }

        @Override
        public synchronized boolean getAutoCommit() throws SQLException {
            Connection connection = this.getConnection1();
            if (connection != null) {
                return connection.getAutoCommit();
            }
            if (this.tag.isAutoCommit()) {
                return this.prop.isAutoCommit();
            }
            if (UninitializedConnectionProcessor.isSetDefaultValue(ConnectionProperty.autoCommit)) {
                boolean val = (Boolean)UninitializedConnectionProcessor.getDefaultValue(ConnectionProperty.autoCommit);
                if (UninitializedConnectionProcessor.isSyncDefaultValue(ConnectionProperty.autoCommit)) {
                    this.prop.setAutoCommit(val);
                    this.tag.setAutoCommit(true);
                }
                return val;
            }
            throw new UninitializedStatusException("Can't invoke 'getAutoCommit()' before connection is initialized");
        }

        private class InvocationTag {
            private boolean readOnly;
            private boolean autoCommit;
            private boolean catalog;
            private boolean transactionIsolation;
            private boolean typeMap;
            private boolean holdability;
            private boolean schema;
            private boolean metaData;

            private InvocationTag() {
            }

            public boolean isReadOnly() {
                return this.readOnly;
            }

            public void setReadOnly(boolean readOnly) {
                this.readOnly = readOnly;
            }

            public boolean isAutoCommit() {
                return this.autoCommit;
            }

            public void setAutoCommit(boolean autoCommit) {
                this.autoCommit = autoCommit;
            }

            public boolean isCatalog() {
                return this.catalog;
            }

            public void setCatalog(boolean catalog) {
                this.catalog = catalog;
            }

            public boolean isTransactionIsolation() {
                return this.transactionIsolation;
            }

            public void setTransactionIsolation(boolean transactionIsolation) {
                this.transactionIsolation = transactionIsolation;
            }

            public boolean isTypeMap() {
                return this.typeMap;
            }

            public void setTypeMap(boolean typeMap) {
                this.typeMap = typeMap;
            }

            public boolean isHoldability() {
                return this.holdability;
            }

            public void setHoldability(boolean holdability) {
                this.holdability = holdability;
            }

            public boolean isSchema() {
                return this.schema;
            }

            public void setSchema(boolean schema) {
                this.schema = schema;
            }

            public boolean isMetaData() {
                return this.metaData;
            }

            public void setMetaData(boolean metaData) {
                this.metaData = metaData;
            }
        }

        private class ConnectionPropertyBean {
            private boolean readOnly;
            private boolean autoCommit;
            private String catalog;
            private int transactionIsolation;
            private Map<String, Class<?>> typeMap;
            private int holdability;
            private String schema;
            private DatabaseMetaData metaData;

            private ConnectionPropertyBean() {
            }

            public boolean isReadOnly() {
                return this.readOnly;
            }

            public void setReadOnly(boolean readOnly) {
                this.readOnly = readOnly;
            }

            public boolean isAutoCommit() {
                return this.autoCommit;
            }

            public void setAutoCommit(boolean autoCommit) {
                this.autoCommit = autoCommit;
            }

            public String getCatalog() {
                return this.catalog;
            }

            public void setCatalog(String catalog) {
                this.catalog = catalog;
            }

            public int getTransactionIsolation() {
                return this.transactionIsolation;
            }

            public void setTransactionIsolation(int transactionIsolation) {
                this.transactionIsolation = transactionIsolation;
            }

            public Map<String, Class<?>> getTypeMap() {
                return this.typeMap;
            }

            public void setTypeMap(Map<String, Class<?>> typeMap) {
                this.typeMap = typeMap;
            }

            public int getHoldability() {
                return this.holdability;
            }

            public void setHoldability(int holdability) {
                this.holdability = holdability;
            }

            public String getSchema() {
                return this.schema;
            }

            public void setSchema(String schema) {
                this.schema = schema;
            }

            public DatabaseMetaData getMetaData() {
                return this.metaData;
            }

            public void setMetaData(DatabaseMetaData metaData) {
                this.metaData = metaData;
            }
        }
    }

    private class ConnectionResult {
        private Connection connection;
        private Set<String> schemas;

        public ConnectionResult(Connection connection, Set<String> schemas) {
            this.connection = connection;
            this.schemas = schemas;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public Set<String> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Set<String> schemas) {
            this.schemas = schemas;
        }
    }
}

