/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.datasource.spring;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanInfoFactory;

public class DDALBeanInfoFactory
implements BeanInfoFactory {
    private static final String DDAL_PACKAGE = "org.hellojavaer.ddal.";
    private static final Map<Class<?>, BeanInfo> cache = new HashMap();

    public BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        if (beanClass == null) {
            return null;
        }
        Introspector.getBeanInfo(beanClass);
        if (beanClass.getName().startsWith(DDAL_PACKAGE)) {
            BeanInfo beanInfo = cache.get(beanClass);
            if (beanInfo == null) {
                beanInfo = new DDALBeanInfo(beanClass, Introspector.getBeanInfo(beanClass));
                cache.put(beanClass, beanInfo);
            }
            return beanInfo;
        }
        return null;
    }

    class DDALBeanInfo
    implements BeanInfo {
        private BeanInfo beanInfo;

        public DDALBeanInfo(Class<?> beanClass, BeanInfo beanInfo) {
            this.beanInfo = beanInfo;
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            if (pds != null) {
                for (PropertyDescriptor pd : pds) {
                    if (pd == null || pd.getWriteMethod() != null && pd.getReadMethod() != null) continue;
                    Class<?> clazz = beanClass;
                    do {
                        Method method;
                        Class<?> fieldType = pd.getPropertyType();
                        if (pd.getReadMethod() == null) {
                            try {
                                method = clazz.getDeclaredMethod(this.fieldToGetter(pd.getName(), fieldType), new Class[0]);
                                method.setAccessible(true);
                                pd.setReadMethod(method);
                                pd.getPropertyType();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        if (pd.getWriteMethod() != null) continue;
                        try {
                            method = clazz.getDeclaredMethod(this.fieldToSetter(pd.getName()), fieldType);
                            method.setAccessible(true);
                            pd.setWriteMethod(method);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    } while ((pd.getReadMethod() == null || pd.getWriteMethod() == null) && (clazz = clazz.getSuperclass()) != null && clazz != Object.class);
                }
            }
        }

        private String fieldToGetter(String name, Class<?> type) {
            return this.fieldToGetter(name, type == Boolean.class || type == Boolean.TYPE);
        }

        private String fieldToGetter(String name, boolean isBoolean) {
            return (isBoolean ? "is" : "get") + name.substring(0, 1).toUpperCase() + name.substring(1);
        }

        private String fieldToSetter(String name) {
            return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        }

        @Override
        public BeanDescriptor getBeanDescriptor() {
            return this.beanInfo.getBeanDescriptor();
        }

        @Override
        public EventSetDescriptor[] getEventSetDescriptors() {
            return this.beanInfo.getEventSetDescriptors();
        }

        @Override
        public int getDefaultEventIndex() {
            return this.beanInfo.getDefaultEventIndex();
        }

        @Override
        public PropertyDescriptor[] getPropertyDescriptors() {
            return this.beanInfo.getPropertyDescriptors();
        }

        @Override
        public int getDefaultPropertyIndex() {
            return this.beanInfo.getDefaultPropertyIndex();
        }

        @Override
        public MethodDescriptor[] getMethodDescriptors() {
            return this.beanInfo.getMethodDescriptors();
        }

        @Override
        public BeanInfo[] getAdditionalBeanInfo() {
            return this.beanInfo.getAdditionalBeanInfo();
        }

        @Override
        public Image getIcon(int iconKind) {
            return this.beanInfo.getIcon(iconKind);
        }
    }
}

