/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.datasource;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.hellojavaer.ddal.datasource.DDALDataSource;
import org.hellojavaer.ddal.ddr.shard.ShardRouter;
import org.hellojavaer.ddal.sequence.Sequence;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class DefaultDDALDataSource
implements DDALDataSource {
    private static final String JDBC_DDAL_PROTOCOL_PREFIX = "jdbc:ddal:";
    private static final String THICK_PROTOCOL_PREFIX = "thick:";
    private static final String THIN_PROTOCOL_PREFIX = "thin:";
    private DataSource dataSource;
    private Sequence sequence;
    private ShardRouter shardRouter;

    public DefaultDDALDataSource(String url) {
        this(url, null, null);
    }

    public DefaultDDALDataSource(String url, String user, String password) {
        if (url != null) {
            url = url.trim();
        }
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("url can't be null");
        }
        if (!url.startsWith(JDBC_DDAL_PROTOCOL_PREFIX)) {
            throw new IllegalArgumentException("url must be start with 'jdbc:ddal:'");
        }
        String url1 = url.substring(JDBC_DDAL_PROTOCOL_PREFIX.length()).trim();
        if (url1.startsWith(THICK_PROTOCOL_PREFIX)) {
            ClassPathXmlApplicationContext context;
            String url2 = url1.substring(THICK_PROTOCOL_PREFIX.length());
            if (url2.startsWith("classpath:") || url2.startsWith("classpath*:")) {
                context = new ClassPathXmlApplicationContext(url2);
            } else if (url2.startsWith("file:")) {
                context = new FileSystemXmlApplicationContext(url2);
            } else if (url2.startsWith("http:") || url2.startsWith("https:")) {
                LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
                param.put("user", user);
                param.put("password", password);
                String content = HttpUtils.sendPost(url2, param);
                ByteArrayResource resource = new ByteArrayResource(content.getBytes());
                GenericXmlApplicationContext genericXmlApplicationContext = new GenericXmlApplicationContext();
                genericXmlApplicationContext.load(new Resource[]{resource});
                genericXmlApplicationContext.refresh();
                context = genericXmlApplicationContext;
            } else {
                throw new IllegalArgumentException("Unsupported protocol " + url);
            }
            this.dataSource = this.getBean((ApplicationContext)context, "dataSource", DataSource.class);
            this.sequence = this.getBean((ApplicationContext)context, "sequence", Sequence.class);
            this.shardRouter = this.getBean((ApplicationContext)context, "shardRouter", ShardRouter.class);
        } else {
            if (url1.startsWith(THIN_PROTOCOL_PREFIX)) {
                throw new IllegalArgumentException("Unsupported protocol " + url);
            }
            this.procCustomProtocol(url);
        }
    }

    private void procCustomProtocol(String url) {
        try {
            Method getShardRouterMethod;
            Method getSequenceMethod;
            URL url0 = new URL(url);
            Object obj = url0.getContent();
            if (obj == null) {
                return;
            }
            Class<?> clazz = obj.getClass();
            Method getDataSourceMethod = this.getMethod(clazz, "getDataSource");
            if (getDataSourceMethod != null) {
                this.dataSource = (DataSource)getDataSourceMethod.invoke(obj, new Object[0]);
            }
            if ((getSequenceMethod = this.getMethod(clazz, "getSequence")) != null) {
                this.sequence = (Sequence)getSequenceMethod.invoke(obj, new Object[0]);
            }
            if ((getShardRouterMethod = this.getMethod(clazz, "getShardRouter")) != null) {
                this.shardRouter = (ShardRouter)getShardRouterMethod.invoke(obj, new Object[0]);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private <T> T getBean(ApplicationContext context, String name, Class<T> requiredType) {
        Map map = context.getBeansOfType(requiredType);
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (map.size() == 1) {
            return (T)map.values().iterator().next();
        }
        return (T)context.getBean(name, requiredType);
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDataSource().isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDataSource().getParentLogger();
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public ShardRouter getShardRouter() {
        return this.shardRouter;
    }

    static class HttpUtils {
        private static final String USER_AGENT = "Mozilla/5.0";

        HttpUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String sendPost(String url, Map<String, String> params) {
            String string;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setDoOutput(true);
            DataOutputStream wr = null;
            try {
                wr = new DataOutputStream(con.getOutputStream());
                if (params != null && !params.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        sb.append(HttpUtils.encode(entry.getKey()));
                        sb.append('=');
                        sb.append(HttpUtils.encode(entry.getValue()));
                        sb.append('&');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    wr.write(sb.toString().getBytes("UTF-8"));
                }
                wr.flush();
            }
            catch (Throwable throwable) {
                HttpUtils.closeIO(wr);
                throw throwable;
            }
            HttpUtils.closeIO(wr);
            BufferedReader br = null;
            InputStream in = con.getResponseCode() < 400 ? con.getInputStream() : con.getErrorStream();
            try {
                String inputLine;
                br = new BufferedReader(new InputStreamReader(in));
                StringBuilder response = new StringBuilder();
                while ((inputLine = br.readLine()) != null) {
                    response.append(inputLine);
                    response.append('\n');
                }
                int responseCode = con.getResponseCode();
                if (responseCode != 200) {
                    throw new IllegalStateException("the requested url: " + url + " returned error code: " + responseCode + "\n" + response.toString());
                }
                string = response.toString();
            }
            catch (Throwable throwable) {
                try {
                    HttpUtils.closeIO(br);
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            HttpUtils.closeIO(br);
            return string;
        }

        private static String encode(String str) {
            if (str == null) {
                return "";
            }
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private static void closeIO(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

