/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.randomized;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.test.randomized.Action;
import org.neo4j.test.randomized.Printable;
import org.neo4j.test.randomized.Result;
import org.neo4j.test.randomized.TestCaseWriter;
import org.neo4j.test.randomized.TestResource;

public class RandomizedTester<T extends TestResource, F> {
    private final List<Action<T, F>> givenActions = new ArrayList<Action<T, F>>();
    private final TargetFactory<T> targetFactory;
    private final ActionFactory<T, F> actionFactory;
    private Action<T, F> failingAction;
    private F failure;

    public RandomizedTester(TargetFactory<T> targetFactory, ActionFactory<T, F> actionFactory) {
        this(targetFactory, actionFactory, null, null);
    }

    private RandomizedTester(TargetFactory<T> targetFactory, ActionFactory<T, F> actionFactory, Action<T, F> failingAction, F failure) {
        this.targetFactory = targetFactory;
        this.actionFactory = actionFactory;
        this.failingAction = failingAction;
        this.failure = failure;
    }

    public Result<T, F> run(int numberOfActions) {
        try (TestResource target = (TestResource)this.targetFactory.newInstance();){
            for (int i = 0; i < numberOfActions; ++i) {
                Action<TestResource, F> action = this.actionFactory.apply(target);
                F failure = action.apply(target);
                if (failure != null) {
                    this.failingAction = action;
                    this.failure = failure;
                    Result<TestResource, F> result = new Result<TestResource, F>(target, i, failure);
                    return result;
                }
                this.givenActions.add(action);
            }
            Result<TestResource, F> result = new Result<TestResource, F>(target, -1, this.failure);
            return result;
        }
    }

    public RandomizedTester<T, F> findMinimalReproducible() {
        RandomizedTester<T, F> minimal = this;
        RandomizedTester<T, F> candidate;
        while ((candidate = minimal.reduceOneAction()) != minimal) {
            minimal = candidate;
        }
        return candidate;
    }

    private RandomizedTester<T, F> reduceOneAction() {
        int numberOfIterations = this.givenActions.size();
        if (numberOfIterations == 1) {
            return this;
        }
        for (int actionToSkip = 0; actionToSkip < this.givenActions.size(); ++actionToSkip) {
            RandomizedTester<T, F> reducedActions = new RandomizedTester<T, F>(this.targetFactory, this.actionFactoryThatSkipsOneAction(this.givenActions.iterator(), actionToSkip, this.failingAction), this.failingAction, this.failure);
            Result<T, F> result = reducedActions.run(numberOfIterations - 1);
            if (!result.isFailure() || result.getIndex() != this.givenActions.size() - 1 || !result.getFailure().equals(this.failure)) continue;
            return reducedActions;
        }
        return this;
    }

    private ActionFactory<T, F> actionFactoryThatSkipsOneAction(final Iterator<Action<T, F>> iterator, final int actionToSkip, final Action<T, F> failingAction) {
        return new ActionFactory<T, F>(){
            private int index;
            private boolean failingActionReturned;

            @Override
            public Action<T, F> apply(T from) {
                if (iterator.hasNext()) {
                    Action action = (Action)iterator.next();
                    return this.index++ == actionToSkip ? this.apply((T)from) : action;
                }
                if (this.failingActionReturned) {
                    throw new IllegalStateException();
                }
                this.failingActionReturned = true;
                return failingAction;
            }
        };
    }

    public TestCaseWriter<T, F> testCaseWriter(String name, Printable given) {
        return new TestCaseWriter<T, F>(name, given, this.targetFactory, this.givenActions, this.failingAction);
    }

    public F failure() {
        return this.failure;
    }

    public static interface ActionFactory<T, F> {
        public Action<T, F> apply(T var1);
    }

    public static interface TargetFactory<T> {
        public T newInstance();
    }
}

