/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.randomized;

import java.io.PrintStream;
import org.neo4j.test.randomized.LinePrinter;

public class PrintStreamLinePrinter
implements LinePrinter {
    private final PrintStream out;
    private final int indentation;

    public PrintStreamLinePrinter(PrintStream out) {
        this(out, 0);
    }

    public PrintStreamLinePrinter(PrintStream out, int indentation) {
        this.out = out;
        this.indentation = indentation;
    }

    @Override
    public void println(String line) {
        for (int i = 0; i < this.indentation; ++i) {
            this.out.print("    ");
        }
        this.out.println(line);
    }

    @Override
    public LinePrinter indent() {
        return new PrintStreamLinePrinter(this.out, this.indentation + 1);
    }
}

