/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.DecayingFlags;

public class DecayingFlagsTest {
    @Test
    public void shouldTrackToggle() {
        DecayingFlags.Key myFeature = new DecayingFlags.Key(1);
        DecayingFlags set = new DecayingFlags(1);
        set.flag(myFeature);
        Assert.assertEquals((Object)"4000", (Object)set.asHex());
    }

    @Test
    public void shouldTrackMultipleFlags() {
        DecayingFlags.Key featureA = new DecayingFlags.Key(1);
        DecayingFlags.Key featureB = new DecayingFlags.Key(3);
        DecayingFlags set = new DecayingFlags(2);
        set.flag(featureA);
        set.flag(featureA);
        set.flag(featureB);
        Assert.assertEquals((Object)"5000", (Object)set.asHex());
    }

    @Test
    public void toggleShouldDecay() {
        DecayingFlags.Key featureA = new DecayingFlags.Key(1);
        DecayingFlags.Key featureB = new DecayingFlags.Key(3);
        DecayingFlags set = new DecayingFlags(2);
        set.flag(featureA);
        set.flag(featureA);
        set.flag(featureB);
        set.sweep();
        Assert.assertEquals((Object)"4000", (Object)set.asHex());
        set.sweep();
        Assert.assertEquals((Object)"0000", (Object)set.asHex());
    }

    @Test
    public void resetFlagShouldRecoverIfToggledAgain() {
        DecayingFlags.Key featureA = new DecayingFlags.Key(9);
        DecayingFlags set = new DecayingFlags(2);
        set.flag(featureA);
        set.sweep();
        Assert.assertEquals((Object)"0000", (Object)set.asHex());
        set.flag(featureA);
        Assert.assertEquals((Object)"0040", (Object)set.asHex());
    }
}

