/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.BinaryLatch;

public class BinaryLatchTest {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    @AfterClass
    public static void shutDownExecutor() {
        executor.shutdown();
    }

    @Test(timeout=3000L)
    public void releaseThenAwaitDoesNotBlock() {
        BinaryLatch latch = new BinaryLatch();
        latch.release();
        latch.await();
    }

    @Test(timeout=10000L)
    public void releaseMustUnblockAwaiters() throws Exception {
        BinaryLatch latch = new BinaryLatch();
        Runnable awaiter = () -> ((BinaryLatch)latch).await();
        int awaiters = 24;
        Future[] futures = new Future[awaiters];
        for (int i = 0; i < awaiters; ++i) {
            futures[i] = executor.submit(awaiter);
        }
        try {
            futures[0].get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Call should have timed out");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        latch.release();
        for (Future future : futures) {
            future.get();
        }
    }

    @Test(timeout=60000L)
    public void stressLatch() throws Exception {
        AtomicReference<BinaryLatch> latchRef = new AtomicReference<BinaryLatch>(new BinaryLatch());
        Runnable awaiter = () -> {
            BinaryLatch latch;
            while ((latch = (BinaryLatch)latchRef.get()) != null) {
                latch.await();
            }
        };
        int awaiters = 6;
        Future[] futures = new Future[awaiters];
        for (int i = 0; i < awaiters; ++i) {
            futures[i] = executor.submit(awaiter);
        }
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        for (int i = 0; i < 500000; ++i) {
            latchRef.getAndSet(new BinaryLatch()).release();
            BinaryLatchTest.spin(rng.nextLong(0L, 10L));
        }
        ((BinaryLatch)latchRef.getAndSet(null)).release();
        for (Future future : futures) {
            future.get();
        }
    }

    private static void spin(long micros) {
        long now;
        if (micros == 0L) {
            return;
        }
        long deadline = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(micros);
        while ((now = System.nanoTime()) < deadline) {
        }
    }
}

