/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;

public class JumpingSequencePutTest {
    @Test
    public void shouldHandlePathologicalSequenceCase() {
        PrimitiveLongSet set = Primitive.longSet();
        Sequence seqGen = new Sequence();
        for (int i = 0; i < 10000; ++i) {
            set.add(seqGen.next());
        }
    }

    private class Sequence {
        private static final int sizePerJump = 100;
        private final AtomicLong nextId = new AtomicLong();
        private int leftToNextJump = 50;
        private long highBits;

        private Sequence() {
        }

        public long next() {
            long result = this.tryNextId();
            if (--this.leftToNextJump == 0) {
                this.leftToNextJump = 100;
                this.nextId.set((0xFFFFFFFFL | this.highBits++ << 32) - 50L + 1L);
            }
            return result;
        }

        private long tryNextId() {
            long result = this.nextId.getAndIncrement();
            if (result == 0xFFFFFFFFL) {
                result = this.nextId.getAndIncrement();
                --this.leftToNextJump;
            }
            return result;
        }
    }
}

