/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongStack;

public class PrimitiveLongStackTest {
    @Test
    public void shouldPushAndPollSomeEntities() {
        PrimitiveLongStack stack = new PrimitiveLongStack(6);
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)-1L, (long)stack.poll());
        stack.push(123L);
        Assert.assertFalse((boolean)stack.isEmpty());
        stack.push(456L);
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertEquals((long)456L, (long)stack.poll());
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertEquals((long)123L, (long)stack.poll());
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)-1L, (long)stack.poll());
    }

    @Test
    public void shouldGrowArray() {
        int i;
        PrimitiveLongStack stack = new PrimitiveLongStack(5);
        for (i = 0; i <= 7; ++i) {
            stack.push((long)i);
        }
        for (i = 7; i >= 0; --i) {
            Assert.assertFalse((boolean)stack.isEmpty());
            Assert.assertEquals((long)i, (long)stack.poll());
        }
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)-1L, (long)stack.poll());
    }

    @Test
    public void shouldStoreLongs() {
        PrimitiveLongStack stack = new PrimitiveLongStack(5);
        long value1 = 0x4FFFFFFF6L;
        long value2 = 216895848347L;
        stack.push(value1);
        stack.push(value2);
        long firstPolledValue = stack.poll();
        long secondPolledValue = stack.poll();
        Assert.assertEquals((long)value2, (long)firstPolledValue);
        Assert.assertEquals((long)value1, (long)secondPolledValue);
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void shouldIterate() {
        PrimitiveLongStack stack = new PrimitiveLongStack();
        for (int i = 0; i < 7; ++i) {
            stack.push((long)i);
        }
        PrimitiveLongIterator iterator = stack.iterator();
        long i = 0L;
        while (iterator.hasNext()) {
            Assert.assertEquals((long)i++, (long)iterator.next());
        }
        Assert.assertEquals((long)7L, (long)i);
    }
}

