/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongPredicate;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;

public class PrimitiveLongResourceCollectionsTest {
    private static final LongPredicate EVEN = value -> value % 2L == 0L;

    @Test
    public void simpleIterator() {
        CountingResource resource = new CountingResource();
        PrimitiveLongResourceIterator iterator = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{1L, 2L, 3L, 4L});
        this.assertContent(iterator, 1L, 2L, 3L, 4L);
        iterator.close();
        Assert.assertEquals((String)"exactly one call to close", (long)1L, (long)resource.closeCount());
    }

    @Test
    public void filterItems() {
        CountingResource resource = new CountingResource();
        PrimitiveLongResourceIterator iterator = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{1L, 2L, 3L, 4L});
        PrimitiveLongResourceIterator filtered = PrimitiveLongResourceCollections.filter((PrimitiveLongResourceIterator)iterator, (LongPredicate)EVEN);
        this.assertContent(filtered, 2L, 4L);
        filtered.close();
        Assert.assertEquals((String)"exactly one call to close", (long)1L, (long)resource.closeCount());
    }

    @Test
    public void concatIterators() {
        CountingResource resource = new CountingResource();
        PrimitiveLongResourceIterator first = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{1L, 2L});
        PrimitiveLongResourceIterator second = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{3L, 4L});
        PrimitiveLongResourceIterator concat = PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])new PrimitiveLongResourceIterator[]{first, second});
        this.assertContent(concat, 1L, 2L, 3L, 4L);
        concat.close();
        Assert.assertEquals((String)"all concatenated iterators are closed", (long)2L, (long)resource.closeCount());
    }

    private void assertContent(PrimitiveLongResourceIterator iterator, long ... expected) {
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((String)"has expected value", (long)expected[i++], (long)iterator.next());
        }
        Assert.assertEquals((String)"has all expected values", (long)expected.length, (long)i);
    }

    private static class CountingResource
    implements Resource {
        private AtomicInteger closed = new AtomicInteger();

        private CountingResource() {
        }

        public void close() {
            this.closed.incrementAndGet();
        }

        int closeCount() {
            return this.closed.get();
        }
    }
}

