/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIntKeyValueArray;

public class PrimitiveLongIntKeyValueArrayTest {
    private static final int DEFAULT_VALUE = -1;

    @Test
    public void testEnsureCapacity() {
        PrimitiveLongIntKeyValueArray map = new PrimitiveLongIntKeyValueArray();
        MatcherAssert.assertThat((Object)map.capacity(), (Matcher)CoreMatchers.equalTo((Object)100));
        map.ensureCapacity(10);
        MatcherAssert.assertThat((Object)map.capacity(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10)));
        map.ensureCapacity(100);
        MatcherAssert.assertThat((Object)map.capacity(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(100)));
        map.ensureCapacity(1000);
        MatcherAssert.assertThat((Object)map.capacity(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1000)));
    }

    @Test
    public void testSize() {
        PrimitiveLongIntKeyValueArray map = new PrimitiveLongIntKeyValueArray();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        map.putIfAbsent(1L, 100);
        map.putIfAbsent(2L, 200);
        map.putIfAbsent(3L, 300);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testGetOrDefault() {
        PrimitiveLongIntKeyValueArray map = new PrimitiveLongIntKeyValueArray();
        map.putIfAbsent(1L, 100);
        map.putIfAbsent(2L, 200);
        map.putIfAbsent(3L, 300);
        MatcherAssert.assertThat((Object)map.getOrDefault(1L, -1), (Matcher)CoreMatchers.equalTo((Object)100));
        MatcherAssert.assertThat((Object)map.getOrDefault(2L, -1), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)map.getOrDefault(3L, -1), (Matcher)CoreMatchers.equalTo((Object)300));
        MatcherAssert.assertThat((Object)map.getOrDefault(4L, -1), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testPutIfAbsent() {
        PrimitiveLongIntKeyValueArray map = new PrimitiveLongIntKeyValueArray();
        MatcherAssert.assertThat((Object)map.putIfAbsent(1L, 100), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)map.putIfAbsent(2L, 200), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)map.putIfAbsent(3L, 300), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)map.keys(), (Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 2L, 3L}));
        MatcherAssert.assertThat((Object)map.putIfAbsent(2L, 2000), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)map.putIfAbsent(3L, 3000), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)map.putIfAbsent(4L, 4000), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)map.keys(), (Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 2L, 3L, 4L}));
        MatcherAssert.assertThat((Object)map.getOrDefault(2L, -1), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)map.getOrDefault(3L, -1), (Matcher)CoreMatchers.equalTo((Object)300));
        MatcherAssert.assertThat((Object)map.getOrDefault(4L, -1), (Matcher)CoreMatchers.equalTo((Object)4000));
    }

    @Test
    public void testReset() {
        PrimitiveLongIntKeyValueArray map = new PrimitiveLongIntKeyValueArray();
        map.putIfAbsent(1L, 100);
        map.putIfAbsent(2L, 200);
        map.putIfAbsent(3L, 300);
        map.reset(1000);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)map.capacity(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1000)));
    }

    @Test
    public void testKeys() {
        PrimitiveLongIntKeyValueArray map = new PrimitiveLongIntKeyValueArray();
        map.putIfAbsent(1L, 100);
        map.putIfAbsent(2L, 200);
        map.putIfAbsent(3L, 300);
        map.putIfAbsent(2L, 200);
        map.putIfAbsent(3L, 300);
        map.putIfAbsent(8L, 800);
        map.putIfAbsent(7L, 700);
        map.putIfAbsent(6L, 600);
        map.putIfAbsent(5L, 500);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)7));
        MatcherAssert.assertThat((Object)map.keys(), (Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 2L, 3L, 8L, 7L, 6L, 5L}));
    }
}

