/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;

public class PrimitiveLongCollectionsTest {
    @Test
    public void arrayOfItemsAsIterator() {
        long[] items = new long[]{2L, 5L, 234L};
        PrimitiveLongIterator iterator = PrimitiveLongCollections.iterator((long[])items);
        this.assertItems(iterator, items);
    }

    @Test
    public void filter() {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongIterator filtered = PrimitiveLongCollections.filter((PrimitiveLongIterator)items, item -> item != 2L);
        this.assertItems(filtered, 1L, 3L);
    }

    @Test
    public void singleWithDefaultMustAutoCloseIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveLongIteratorResource itr = new CountingPrimitiveLongIteratorResource(PrimitiveLongCollections.iterator((long[])new long[]{13L}), counter);
        Assert.assertEquals((long)PrimitiveLongCollections.single((PrimitiveLongIterator)itr, (long)2L), (long)13L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void singleWithDefaultMustAutoCloseEmptyIterator() {
        AtomicInteger counter = new AtomicInteger();
        CountingPrimitiveLongIteratorResource itr = new CountingPrimitiveLongIteratorResource(PrimitiveLongCollections.emptyIterator(), counter);
        Assert.assertEquals((long)PrimitiveLongCollections.single((PrimitiveLongIterator)itr, (long)2L), (long)2L);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void indexOf() {
        PrimitiveLongIterable items = () -> PrimitiveLongCollections.iterator((long[])new long[]{10L, 20L, 30L});
        Assert.assertEquals((long)-1L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)55L));
        Assert.assertEquals((long)0L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)10L));
        Assert.assertEquals((long)1L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)20L));
        Assert.assertEquals((long)2L, (long)PrimitiveLongCollections.indexOf((PrimitiveLongIterator)items.iterator(), (long)30L));
    }

    @Test
    public void iteratorAsSet() {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        PrimitiveLongSet set = PrimitiveLongCollections.asSet((PrimitiveLongIterator)items);
        Assert.assertTrue((boolean)set.contains(1L));
        Assert.assertTrue((boolean)set.contains(2L));
        Assert.assertTrue((boolean)set.contains(3L));
        Assert.assertFalse((boolean)set.contains(4L));
    }

    @Test
    public void count() {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        int count = PrimitiveLongCollections.count((PrimitiveLongIterator)items);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void asArray() {
        PrimitiveLongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        long[] array = PrimitiveLongCollections.asArray((PrimitiveLongIterator)items);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L}, array));
    }

    @Test
    public void shouldDeduplicate() {
        long[] array = new long[]{1L, 1L, 2L, 5L, 6L, 6L};
        long[] deduped = PrimitiveLongCollections.deduplicate((long[])array);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 5L, 6L}, (long[])deduped);
    }

    @Test
    public void shouldNotContinueToCallNextOnHasNextFalse() {
        final AtomicLong count = new AtomicLong(2L);
        PrimitiveLongCollections.PrimitiveLongBaseIterator iterator = new PrimitiveLongCollections.PrimitiveLongBaseIterator(){

            protected boolean fetchNext() {
                return count.decrementAndGet() >= 0L && this.next(count.get());
            }
        };
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)0L, (long)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)-1L, (long)count.get());
    }

    @Test
    public void copyPrimitiveSet() {
        PrimitiveLongSet longSet = PrimitiveLongCollections.setOf((long[])new long[]{1L, 3L, 5L});
        PrimitiveLongSet copySet = PrimitiveLongCollections.asSet((PrimitiveLongSet)longSet);
        Assert.assertNotSame((Object)copySet, (Object)longSet);
        Assert.assertTrue((boolean)copySet.contains(1L));
        Assert.assertTrue((boolean)copySet.contains(3L));
        Assert.assertTrue((boolean)copySet.contains(5L));
        Assert.assertEquals((long)3L, (long)copySet.size());
    }

    @Test
    public void convertJavaCollectionToSetOfPrimitives() {
        List<Long> longs = Arrays.asList(1L, 4L, 7L);
        PrimitiveLongSet longSet = PrimitiveLongCollections.asSet(longs);
        Assert.assertTrue((boolean)longSet.contains(1L));
        Assert.assertTrue((boolean)longSet.contains(4L));
        Assert.assertTrue((boolean)longSet.contains(7L));
        Assert.assertEquals((long)3L, (long)longSet.size());
    }

    @Test
    public void convertPrimitiveSetToJavaSet() {
        PrimitiveLongSet longSet = PrimitiveLongCollections.setOf((long[])new long[]{1L, 3L, 5L});
        Set longs = PrimitiveLongCollections.toSet((PrimitiveLongSet)longSet);
        Assert.assertThat((Object)longs, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 3L, 5L}));
    }

    @Test
    public void copyMap() {
        PrimitiveLongObjectMap originalMap = Primitive.longObjectMap();
        originalMap.put(1L, (Object)"a");
        originalMap.put(2L, (Object)"b");
        originalMap.put(3L, (Object)"c");
        PrimitiveLongObjectMap copyMap = PrimitiveLongCollections.copy((PrimitiveLongObjectMap)originalMap);
        Assert.assertNotSame((Object)originalMap, (Object)copyMap);
        Assert.assertEquals((long)3L, (long)copyMap.size());
        Assert.assertEquals((Object)"a", (Object)copyMap.get(1L));
        Assert.assertEquals((Object)"b", (Object)copyMap.get(2L));
        Assert.assertEquals((Object)"c", (Object)copyMap.get(3L));
    }

    private void assertNoMoreItems(PrimitiveLongIterator iterator) {
        Assert.assertFalse((String)(iterator + " should have no more items"), (boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)("Invoking next() on " + iterator + " which has no items left should have thrown NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void assertNextEquals(long expected, PrimitiveLongIterator iterator) {
        Assert.assertTrue((String)(iterator + " should have had more items"), (boolean)iterator.hasNext());
        Assert.assertEquals((long)expected, (long)iterator.next());
    }

    private void assertItems(PrimitiveLongIterator iterator, long ... expectedItems) {
        for (long expectedItem : expectedItems) {
            this.assertNextEquals(expectedItem, iterator);
        }
        this.assertNoMoreItems(iterator);
    }

    private long[] reverse(long[] items) {
        long[] result = new long[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = items[items.length - i - 1];
        }
        return result;
    }

    private static final class CountingPrimitiveLongIteratorResource
    implements PrimitiveLongIterator,
    AutoCloseable {
        private final PrimitiveLongIterator delegate;
        private final AtomicInteger closeCounter;

        private CountingPrimitiveLongIteratorResource(PrimitiveLongIterator delegate, AtomicInteger closeCounter) {
            this.delegate = delegate;
            this.closeCounter = closeCounter;
        }

        @Override
        public void close() {
            this.closeCounter.incrementAndGet();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long next() {
            return this.delegate.next();
        }
    }
}

