/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongArrayQueue;
import org.neo4j.collection.primitive.PrimitiveLongIterator;

public class PrimitiveLongArrayQueueTest {
    @Test
    public void newQueueIsEmpty() {
        Assert.assertTrue((boolean)this.createQueue().isEmpty());
    }

    @Test
    public void growQueueOnElementOffer() {
        PrimitiveLongArrayQueue longArrayQueue = this.createQueue();
        for (int i = 1; i < 1000; ++i) {
            longArrayQueue.enqueue((long)i);
            Assert.assertEquals((long)i, (long)longArrayQueue.size());
        }
    }

    @Test
    public void addRemoveElementKeepQueueEmpty() {
        PrimitiveLongArrayQueue longArrayQueue = this.createQueue();
        for (int i = 0; i < 1000; ++i) {
            longArrayQueue.enqueue((long)i);
            Assert.assertEquals((long)i, (long)longArrayQueue.dequeue());
            Assert.assertTrue((boolean)longArrayQueue.isEmpty());
        }
    }

    @Test
    public void offerLessThenQueueCapacityElements() {
        PrimitiveLongArrayQueue arrayQueue = this.createQueue();
        for (int i = 1; i < 16; ++i) {
            arrayQueue.enqueue((long)i);
            Assert.assertEquals((long)i, (long)arrayQueue.size());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void failToRemoveElementFromNewEmptyQueue() {
        this.createQueue().dequeue();
    }

    @Test
    public void offerMoreThenQueueCapacityElements() {
        PrimitiveLongArrayQueue arrayQueue = this.createQueue();
        for (int i = 1; i < 1234; ++i) {
            arrayQueue.enqueue((long)i);
        }
        int currentValue = 1;
        while (!arrayQueue.isEmpty()) {
            Assert.assertEquals((long)currentValue++, (long)arrayQueue.dequeue());
        }
    }

    @Test
    public void emptyQueueAfterClear() {
        PrimitiveLongArrayQueue queue = this.createQueue();
        queue.enqueue(2L);
        queue.enqueue(3L);
        Assert.assertFalse((boolean)queue.isEmpty());
        Assert.assertEquals((long)2L, (long)queue.size());
        queue.clear();
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void tailBeforeHeadCorrectSize() {
        int i;
        PrimitiveLongArrayQueue queue = this.createQueue();
        for (i = 0; i < 14; ++i) {
            queue.enqueue((long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)queue.dequeue());
        }
        for (i = 14; i < 24; ++i) {
            queue.enqueue((long)i);
        }
        Assert.assertEquals((long)14L, (long)queue.size());
    }

    @Test
    public void tailBeforeHeadCorrectResize() {
        int i;
        PrimitiveLongArrayQueue queue = this.createQueue();
        for (i = 0; i < 14; ++i) {
            queue.enqueue((long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)queue.dequeue());
        }
        for (i = 14; i < 34; ++i) {
            queue.enqueue((long)i);
        }
        Assert.assertEquals((long)24L, (long)queue.size());
        for (int j = 10; j < 34; ++j) {
            Assert.assertEquals((long)j, (long)queue.dequeue());
        }
    }

    @Test
    public void tailBeforeHeadCorrectIteration() {
        int i;
        PrimitiveLongArrayQueue queue = this.createQueue();
        for (i = 0; i < 14; ++i) {
            queue.enqueue((long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)queue.dequeue());
        }
        for (i = 14; i < 24; ++i) {
            queue.enqueue((long)i);
        }
        Assert.assertEquals((long)14L, (long)queue.size());
        PrimitiveLongIterator iterator = queue.iterator();
        for (int j = 10; j < 24; ++j) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((long)j, (long)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void failToGetNextOnEmptyQueueIterator() {
        this.createQueue().iterator().next();
    }

    @Test
    public void addAllElementsFromOtherQueue() {
        PrimitiveLongArrayQueue queue = this.createQueue();
        queue.enqueue(1L);
        queue.enqueue(2L);
        PrimitiveLongArrayQueue otherQueue = this.createQueue();
        otherQueue.enqueue(3L);
        otherQueue.enqueue(4L);
        queue.addAll(otherQueue);
        Assert.assertTrue((boolean)otherQueue.isEmpty());
        Assert.assertEquals((long)0L, (long)otherQueue.size());
        Assert.assertEquals((long)4L, (long)queue.size());
        for (int value = 1; value <= 4; ++value) {
            Assert.assertEquals((long)value, (long)queue.dequeue());
        }
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test(expected=AssertionError.class)
    public void doNotAllowCreationOfQueueWithRandomCapacity() {
        new PrimitiveLongArrayQueue(7);
    }

    private PrimitiveLongArrayQueue createQueue() {
        return new PrimitiveLongArrayQueue();
    }
}

