/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntStack;

public class PrimitiveIntStackTest {
    @Test
    public void shouldPushAndPollSomeEntities() {
        PrimitiveIntStack stack = new PrimitiveIntStack(6);
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)-1L, (long)stack.poll());
        stack.push(123);
        Assert.assertFalse((boolean)stack.isEmpty());
        stack.push(456);
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertEquals((long)456L, (long)stack.poll());
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertEquals((long)123L, (long)stack.poll());
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)-1L, (long)stack.poll());
    }

    @Test
    public void shouldGrowArray() {
        int i;
        PrimitiveIntStack stack = new PrimitiveIntStack(5);
        for (i = 0; i <= 7; ++i) {
            stack.push(i);
        }
        for (i = 7; i >= 0; --i) {
            Assert.assertFalse((boolean)stack.isEmpty());
            Assert.assertEquals((long)i, (long)stack.poll());
        }
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)-1L, (long)stack.poll());
    }

    @Test
    public void shouldIterate() {
        PrimitiveIntStack stack = new PrimitiveIntStack();
        for (int i = 0; i < 7; ++i) {
            stack.push(i);
        }
        PrimitiveIntIterator iterator = stack.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((long)i++, (long)iterator.next());
        }
        Assert.assertEquals((long)7L, (long)i);
    }
}

