/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;

public class PrimitiveIntCollectionsTest {
    @Test
    public void arrayOfItemsAsIterator() {
        int[] items = new int[]{2, 5, 234};
        PrimitiveIntIterator iterator = PrimitiveIntCollections.iterator((int[])items);
        this.assertItems(iterator, items);
    }

    @Test
    public void convertCollectionToLongArray() {
        PrimitiveIntSet heapSet = PrimitiveIntCollections.asSet((int[])new int[]{1, 2, 3});
        PrimitiveIntSet offHeapIntSet = Primitive.offHeapIntSet((MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        offHeapIntSet.add(7);
        offHeapIntSet.add(8);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])PrimitiveIntCollections.asLongArray((PrimitiveIntCollection)heapSet));
        Assert.assertArrayEquals((long[])new long[]{7L, 8L}, (long[])PrimitiveIntCollections.asLongArray((PrimitiveIntCollection)offHeapIntSet));
    }

    @Test
    public void concatenateTwoIterators() {
        PrimitiveIntIterator firstItems = PrimitiveIntCollections.iterator((int[])new int[]{10, 3, 203, 32});
        PrimitiveIntIterator otherItems = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 5});
        PrimitiveIntIterator iterator = PrimitiveIntCollections.concat(Arrays.asList(firstItems, otherItems).iterator());
        this.assertItems(iterator, 10, 3, 203, 32, 1, 2, 5);
    }

    @Test
    public void filter() {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntIterator filtered = PrimitiveIntCollections.filter((PrimitiveIntIterator)items, item -> item != 2);
        this.assertItems(filtered, 1, 3);
    }

    @Test
    public void deduplicate() {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 1, 2, 3, 2});
        PrimitiveIntIterator deduped = PrimitiveIntCollections.deduplicate((PrimitiveIntIterator)items);
        this.assertItems(deduped, 1, 2, 3);
    }

    @Test
    public void iteratorAsSet() {
        PrimitiveIntIterator items = PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 3});
        PrimitiveIntSet set = PrimitiveIntCollections.asSet((PrimitiveIntIterator)items);
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertTrue((boolean)set.contains(3));
        Assert.assertFalse((boolean)set.contains(4));
        try {
            PrimitiveIntCollections.asSet((PrimitiveIntIterator)PrimitiveIntCollections.iterator((int[])new int[]{1, 2, 1}));
            Assert.fail((String)"Should fail on duplicates");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotContinueToCallNextOnHasNextFalse() {
        final AtomicInteger count = new AtomicInteger(2);
        PrimitiveIntCollections.PrimitiveIntBaseIterator iterator = new PrimitiveIntCollections.PrimitiveIntBaseIterator(){

            protected boolean fetchNext() {
                return count.decrementAndGet() >= 0 && this.next(count.get());
            }
        };
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)0L, (long)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)-1L, (long)count.get());
    }

    @Test
    public void shouldDeduplicate() {
        int[] array = new int[]{1, 6, 2, 5, 6, 1, 6};
        int[] deduped = PrimitiveIntCollections.deduplicate((int[])array);
        Assert.assertArrayEquals((int[])new int[]{1, 6, 2, 5}, (int[])deduped);
    }

    @Test
    public void copyTransformMap() {
        PrimitiveIntObjectMap originalMap = Primitive.intObjectMap();
        originalMap.put(1, (Object)"a");
        originalMap.put(2, (Object)"b");
        originalMap.put(3, (Object)"c");
        PrimitiveIntObjectMap copyMap = PrimitiveIntCollections.copyTransform((PrimitiveIntObjectMap)originalMap, String::toUpperCase);
        Assert.assertNotSame((Object)originalMap, (Object)copyMap);
        Assert.assertEquals((long)3L, (long)copyMap.size());
        Assert.assertEquals((Object)"A", (Object)copyMap.get(1));
        Assert.assertEquals((Object)"B", (Object)copyMap.get(2));
        Assert.assertEquals((Object)"C", (Object)copyMap.get(3));
    }

    private void assertNoMoreItems(PrimitiveIntIterator iterator) {
        Assert.assertFalse((String)(iterator + " should have no more items"), (boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)("Invoking next() on " + iterator + " which has no items left should have thrown NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void assertNextEquals(long expected, PrimitiveIntIterator iterator) {
        Assert.assertTrue((String)(iterator + " should have had more items"), (boolean)iterator.hasNext());
        Assert.assertEquals((long)expected, (long)iterator.next());
    }

    private void assertItems(PrimitiveIntIterator iterator, int ... expectedItems) {
        int[] nArray = expectedItems;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long expectedItem = nArray[i];
            this.assertNextEquals(expectedItem, iterator);
        }
        this.assertNoMoreItems(iterator);
    }

    private int[] reverse(int[] items) {
        int[] result = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = items[items.length - i - 1];
        }
        return result;
    }

    private static final class CountingPrimitiveIntIteratorResource
    implements PrimitiveIntIterator,
    AutoCloseable {
        private final PrimitiveIntIterator delegate;
        private final AtomicInteger closeCounter;

        private CountingPrimitiveIntIteratorResource(PrimitiveIntIterator delegate, AtomicInteger closeCounter) {
            this.delegate = delegate;
            this.closeCounter = closeCounter;
        }

        @Override
        public void close() {
            this.closeCounter.incrementAndGet();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public int next() {
            return this.delegate.next();
        }
    }
}

