/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;

public class PrimitiveCollectionsAllocationsTest {
    @Test
    public void trackPrimitiveMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        PrimitiveIntSet offHeapIntSet = Primitive.offHeapIntSet((MemoryAllocationTracker)memoryTracker);
        Assert.assertTrue((memoryTracker.usedDirectMemory() > 0L ? 1 : 0) != 0);
        offHeapIntSet.close();
        Assert.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
    }

    @Test
    public void trackPrimitiveMemoryOnResize() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        PrimitiveIntSet offHeapIntSet = Primitive.offHeapIntSet((MemoryAllocationTracker)memoryTracker);
        long originalSetMemory = memoryTracker.usedDirectMemory();
        for (int i = 0; i < 0x100001; ++i) {
            offHeapIntSet.add(i);
        }
        Assert.assertTrue((memoryTracker.usedDirectMemory() > originalSetMemory ? 1 : 0) != 0);
        offHeapIntSet.close();
        Assert.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
    }
}

