/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.evaluator;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.Evaluator;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.helpers.collection.MapUtil;

class SimpleExpressionEvaluatorTest {
    SimpleExpressionEvaluatorTest() {
    }

    @Test
    void shouldConvertToSpecificType() throws EvaluationException {
        ExpressionEvaluator evaluator = Evaluator.expressionEvaluator();
        List list = (List)evaluator.evaluate("[1, 2, 3]", List.class);
        Assertions.assertEquals(Arrays.asList(1L, 2L, 3L), (Object)list);
    }

    @Test
    void shouldConvertToObject() throws EvaluationException {
        ExpressionEvaluator evaluator = Evaluator.expressionEvaluator();
        Object object = evaluator.evaluate("{prop: 42}", Object.class);
        Assertions.assertEquals((Object)MapUtil.map((Object[])new Object[]{"prop", 42L}), (Object)object);
    }

    @Test
    void shouldThrowIfWrongType() {
        ExpressionEvaluator evaluator = Evaluator.expressionEvaluator();
        Assertions.assertThrows(EvaluationException.class, () -> {
            List cfr_ignored_0 = (List)evaluator.evaluate("{prop: 42}", List.class);
        });
    }
}

