/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.HelpCommand;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.arguments.Arguments;

public class HelpCommandTest {
    @Mock
    private Consumer<String> out;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void printsUnknownCommandWhenUnknownCommandIsProvided() {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        Mockito.when((Object)commandLocator.getAllProviders()).thenReturn((Object)Collections.EMPTY_LIST);
        Mockito.when((Object)commandLocator.findProvider("foobar")).thenThrow(new Throwable[]{new NoSuchElementException("foobar")});
        HelpCommand helpCommand = new HelpCommand((Usage)Mockito.mock(Usage.class), this.out, commandLocator);
        try {
            helpCommand.execute(new String[]{"foobar"});
            Assert.fail();
        }
        catch (IncorrectUsage e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unknown command: foobar"));
        }
    }

    @Test
    public void printsAvailableCommandsWhenUnknownCommandIsProvided() {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        ArrayList<AdminCommand.Provider> mockCommands = new ArrayList<AdminCommand.Provider>(){
            {
                this.add(HelpCommandTest.this.mockCommand("foo"));
                this.add(HelpCommandTest.this.mockCommand("bar"));
                this.add(HelpCommandTest.this.mockCommand("baz"));
            }
        };
        Mockito.when((Object)commandLocator.getAllProviders()).thenReturn((Object)mockCommands);
        Mockito.when((Object)commandLocator.findProvider("foobar")).thenThrow(new Throwable[]{new NoSuchElementException("foobar")});
        HelpCommand helpCommand = new HelpCommand((Usage)Mockito.mock(Usage.class), this.out, commandLocator);
        try {
            helpCommand.execute(new String[]{"foobar"});
            Assert.fail();
        }
        catch (IncorrectUsage e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Available commands are: foo bar baz"));
        }
    }

    @Test
    public void testAdminUsage() throws Exception {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        ArrayList<AdminCommand.Provider> mockCommands = new ArrayList<AdminCommand.Provider>(){
            {
                this.add(HelpCommandTest.this.mockCommand("foo"));
                this.add(HelpCommandTest.this.mockCommand("bar"));
                this.add(HelpCommandTest.this.mockCommand("baz"));
            }
        };
        Mockito.when((Object)commandLocator.getAllProviders()).thenReturn((Object)mockCommands);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("ongdb-admin", commandLocator);
            HelpCommand helpCommand = new HelpCommand(usage, ps::println, commandLocator);
            helpCommand.execute(new String[0]);
            Assert.assertEquals((Object)String.format("usage: ongdb-admin <command>%n%nManage your ONgDB instance.%n%nenvironment variables:%n    ONGDB_CONF    Path to directory which contains ongdb.conf.%n    ONGDB_DEBUG   Set to anything to enable debug output.%n    ONGDB_HOME    ONgDB home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%navailable commands:%n%nGeneral%n    bar%n        null%n    baz%n        null%n    foo%n        null%n%nUse ongdb-admin help <command> for more details.%n", new Object[0]), (Object)baos.toString());
        }
    }

    @Test
    public void showsArgumentsAndDescriptionForSpecifiedCommand() throws Exception {
        CommandLocator commandLocator = (CommandLocator)Mockito.mock(CommandLocator.class);
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)"foobar");
        Arguments arguments = new Arguments().withDatabase();
        Mockito.when((Object)commandProvider.allArguments()).thenReturn((Object)arguments);
        Mockito.when((Object)commandProvider.possibleArguments()).thenReturn(Collections.singletonList(arguments));
        Mockito.when((Object)commandProvider.description()).thenReturn((Object)"This is a description of the foobar command.");
        Mockito.when((Object)commandLocator.findProvider("foobar")).thenReturn((Object)commandProvider);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            HelpCommand helpCommand = new HelpCommand(new Usage("ongdb-admin", commandLocator), ps::println, commandLocator);
            helpCommand.execute(new String[]{"foobar"});
            Assert.assertEquals((Object)String.format("usage: ongdb-admin foobar [--database=<name>]%n%nenvironment variables:%n    ONGDB_CONF    Path to directory which contains ongdb.conf.%n    ONGDB_DEBUG   Set to anything to enable debug output.%n    ONGDB_HOME    ONgDB home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nThis is a description of the foobar command.%n%noptions:%n  --database=<name>   Name of database. [default:graph.db]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private AdminCommand.Provider mockCommand(String name) {
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)name);
        Mockito.when((Object)commandProvider.commandSection()).thenReturn((Object)AdminCommandSection.general());
        return commandProvider;
    }
}

