
package org.glassfish.jersey.media.multipart.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.media.multipart.internal.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERROR_PARSING_CONTENT_DISPOSITION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.parsing.content.disposition", arg0);
    }

    /**
     * Error parsing content disposition: {0}
     * 
     */
    public static String ERROR_PARSING_CONTENT_DISPOSITION(Object arg0) {
        return LOCALIZER.localize(localizableERROR_PARSING_CONTENT_DISPOSITION(arg0));
    }

    public static Localizable localizableENTITY_HAS_WRONG_TYPE() {
        return MESSAGE_FACTORY.getMessage("entity.has.wrong.type");
    }

    /**
     * Entity instance does not contain the unconverted content.
     * 
     */
    public static String ENTITY_HAS_WRONG_TYPE() {
        return LOCALIZER.localize(localizableENTITY_HAS_WRONG_TYPE());
    }

    public static Localizable localizableCANNOT_INJECT_FILE() {
        return MESSAGE_FACTORY.getMessage("cannot.inject.file");
    }

    /**
     * Cannot provide file for an entity body part.
     * 
     */
    public static String CANNOT_INJECT_FILE() {
        return LOCALIZER.localize(localizableCANNOT_INJECT_FILE());
    }

    public static Localizable localizableMISSING_ENTITY_OF_BODY_PART(Object arg0) {
        return MESSAGE_FACTORY.getMessage("missing.entity.of.body.part", arg0);
    }

    /**
     * Missing body part entity of type "{0}".
     * 
     */
    public static String MISSING_ENTITY_OF_BODY_PART(Object arg0) {
        return LOCALIZER.localize(localizableMISSING_ENTITY_OF_BODY_PART(arg0));
    }

    public static Localizable localizableMISSING_MEDIA_TYPE_OF_BODY_PART() {
        return MESSAGE_FACTORY.getMessage("missing.media.type.of.body.part");
    }

    /**
     * Missing media type of body part.
     * 
     */
    public static String MISSING_MEDIA_TYPE_OF_BODY_PART() {
        return LOCALIZER.localize(localizableMISSING_MEDIA_TYPE_OF_BODY_PART());
    }

    public static Localizable localizableNO_AVAILABLE_MBW(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("no.available.mbw", arg0, arg1);
    }

    /**
     * No available MessageBodyWriter for class "{0}" and media type "{1}".
     * 
     */
    public static String NO_AVAILABLE_MBW(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableNO_AVAILABLE_MBW(arg0, arg1));
    }

    public static Localizable localizableTEMP_FILE_NOT_DELETED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("temp.file.not.deleted", arg0);
    }

    /**
     * Temporary file {0} was not deleted.
     * 
     */
    public static String TEMP_FILE_NOT_DELETED(Object arg0) {
        return LOCALIZER.localize(localizableTEMP_FILE_NOT_DELETED(arg0));
    }

    public static Localizable localizableENTITY_IS_EMPTY() {
        return MESSAGE_FACTORY.getMessage("entity.is.empty");
    }

    /**
     * Entity is empty.
     * 
     */
    public static String ENTITY_IS_EMPTY() {
        return LOCALIZER.localize(localizableENTITY_IS_EMPTY());
    }

    public static Localizable localizableMEDIA_TYPE_NOT_TEXT_PLAIN() {
        return MESSAGE_FACTORY.getMessage("media.type.not.text.plain");
    }

    /**
     * Media type is not text/plain.
     * 
     */
    public static String MEDIA_TYPE_NOT_TEXT_PLAIN() {
        return LOCALIZER.localize(localizableMEDIA_TYPE_NOT_TEXT_PLAIN());
    }

    public static Localizable localizableMUST_SPECIFY_BODY_PART() {
        return MESSAGE_FACTORY.getMessage("must.specify.body.part");
    }

    /**
     * Must specify at least one body part.
     * 
     */
    public static String MUST_SPECIFY_BODY_PART() {
        return LOCALIZER.localize(localizableMUST_SPECIFY_BODY_PART());
    }

    public static Localizable localizableNO_AVAILABLE_MBR(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("no.available.mbr", arg0, arg1);
    }

    /**
     * No available MessageBodyReader for class "{0}" and media type "{1}".
     * 
     */
    public static String NO_AVAILABLE_MBR(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableNO_AVAILABLE_MBR(arg0, arg1));
    }

    public static Localizable localizableCONTROL_NAME_CANNOT_BE_NULL() {
        return MESSAGE_FACTORY.getMessage("control.name.cannot.be.null");
    }

    /**
     * Controls name can not be null.
     * 
     */
    public static String CONTROL_NAME_CANNOT_BE_NULL() {
        return LOCALIZER.localize(localizableCONTROL_NAME_CANNOT_BE_NULL());
    }

    public static Localizable localizableENTITY_CONTENT_NOT_SET() {
        return MESSAGE_FACTORY.getMessage("entity.content.not.set");
    }

    /**
     * EntityPart content is not set.
     * 
     */
    public static String ENTITY_CONTENT_NOT_SET() {
        return LOCALIZER.localize(localizableENTITY_CONTENT_NOT_SET());
    }

    public static Localizable localizableCONTENT_HAS_BEEN_ALREADY_READ() {
        return MESSAGE_FACTORY.getMessage("content.has.been.already.read");
    }

    /**
     * Content method has already been invoked.
     * 
     */
    public static String CONTENT_HAS_BEEN_ALREADY_READ() {
        return LOCALIZER.localize(localizableCONTENT_HAS_BEEN_ALREADY_READ());
    }

    public static Localizable localizablePARSING_ERROR() {
        return MESSAGE_FACTORY.getMessage("parsing.error");
    }

    /**
     * Exception occurred during parsing MultiPart message. Performing cleanup.
     * 
     */
    public static String PARSING_ERROR() {
        return LOCALIZER.localize(localizablePARSING_ERROR());
    }

    public static Localizable localizableERROR_READING_ENTITY(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.reading.entity", arg0);
    }

    /**
     * Error reading entity as {0}.
     * 
     */
    public static String ERROR_READING_ENTITY(Object arg0) {
        return LOCALIZER.localize(localizableERROR_READING_ENTITY(arg0));
    }

    public static Localizable localizableFORM_DATA_MULTIPART_CANNOT_CHANGE_MEDIATYPE() {
        return MESSAGE_FACTORY.getMessage("form.data.multipart.cannot.change.mediatype");
    }

    /**
     * Cannot change media type of a FormDataMultiPart instance.
     * 
     */
    public static String FORM_DATA_MULTIPART_CANNOT_CHANGE_MEDIATYPE() {
        return LOCALIZER.localize(localizableFORM_DATA_MULTIPART_CANNOT_CHANGE_MEDIATYPE());
    }

    public static Localizable localizableTEMP_FILE_CANNOT_BE_CREATED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("temp.file.cannot.be.created", arg0);
    }

    /**
     * Cannot create temporary files. Multipart attachments will be limited to "{0}" bytes.
     * 
     */
    public static String TEMP_FILE_CANNOT_BE_CREATED(Object arg0) {
        return LOCALIZER.localize(localizableTEMP_FILE_CANNOT_BE_CREATED(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
