/*
 * Decompiled with CFR 0.152.
 */
package se.cambio.cm.model.generic.dao;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.jberet.support.io.UnicodeBOMInputStream;
import se.cambio.cm.model.generic.dao.CMElementBuilder;
import se.cambio.cm.model.generic.dao.GenericCMElementDAO;
import se.cambio.cm.model.util.CMElement;
import se.cambio.cm.model.util.CMTypeManager;
import se.cambio.openehr.util.Resources;
import se.cambio.openehr.util.exceptions.InstanceNotFoundException;
import se.cambio.openehr.util.exceptions.InternalErrorException;

public class ResourceGenericCMElementDAO<E extends CMElement>
implements GenericCMElementDAO<E> {
    private Class<E> cmElementClass;
    private Collection<String> fileExtensions;

    public ResourceGenericCMElementDAO(Class<E> cmElementClass) {
        this.cmElementClass = cmElementClass;
    }

    @Override
    public Collection<E> searchByIds(Collection<String> ids) throws InternalErrorException, InstanceNotFoundException {
        ArrayList<E> cmElements = new ArrayList<E>();
        InputStream is = this.getInputStreamForResourceList();
        if (is != null) {
            Collection<String> resourceFileNamesIdsMap = this.getResourceFileNames(is);
            for (String resourceFileName : resourceFileNamesIdsMap) {
                try {
                    String fileExtension = this.matchingFileExtension(resourceFileName);
                    String id = resourceFileName.substring(resourceFileName.lastIndexOf("/") + 1, resourceFileName.length() - fileExtension.length() - 1);
                    if (!ids.contains(id)) continue;
                    E cmElement = this.getCMElement(resourceFileName);
                    cmElements.add(cmElement);
                }
                catch (Exception ex) {
                    throw new InternalErrorException(ex);
                }
            }
        } else {
            throw new InternalErrorException(new Exception("Resource list not found!"));
        }
        this.checkMissingInstance(ids, cmElements);
        return cmElements;
    }

    @Override
    public Collection<E> searchAll() throws InternalErrorException {
        ArrayList<E> cmElements = new ArrayList<E>();
        InputStream is = this.getInputStreamForResourceList();
        if (is != null) {
            Collection<String> resourceFileNamesIdsMap = this.getResourceFileNames(is);
            for (String resourceFileName : resourceFileNamesIdsMap) {
                try {
                    E cmElement = this.getCMElement(resourceFileName);
                    cmElements.add(cmElement);
                }
                catch (Exception ex) {
                    throw new InternalErrorException(ex);
                }
            }
        } else {
            throw new InternalErrorException(new Exception("Resource list not found!"));
        }
        return cmElements;
    }

    private E getCMElement(String resourceFileName) throws IOException, InternalErrorException {
        InputStream fis = ResourceGenericCMElementDAO.class.getClassLoader().getResourceAsStream(resourceFileName);
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(fis);
        ubis.skipBOM();
        String fileExtension = this.matchingFileExtension(resourceFileName);
        String id = resourceFileName.substring(resourceFileName.lastIndexOf("/") + 1, resourceFileName.length() - fileExtension.length() - 1);
        String source = IOUtils.toString((InputStream)ubis, (String)"UTF-8");
        E cmElement = new CMElementBuilder().setId(id).setFormat(fileExtension).setSource(source).setLastUpdate(Calendar.getInstance().getTime()).createCMElement(this.cmElementClass);
        return cmElement;
    }

    private InputStream getInputStreamForResourceList() throws InternalErrorException {
        return ResourceGenericCMElementDAO.class.getClassLoader().getResourceAsStream(Resources.RESOURCES_LIST);
    }

    private Collection<String> getResourceFileNames(InputStream is) throws InternalErrorException {
        ArrayList<String> resourceFileNames = new ArrayList<String>();
        try {
            String resourceList = IOUtils.toString((InputStream)is, (String)"UTF-8");
            for (String resourceFileName : resourceList.split("\n")) {
                String fileExtension = this.matchingFileExtension(resourceFileName = resourceFileName.trim());
                if (fileExtension == null) continue;
                resourceFileName = resourceFileName.replaceAll("\\\\", "/");
                resourceFileNames.add(resourceFileName.substring(1, resourceFileName.length()));
            }
        }
        catch (IOException ex) {
            throw new InternalErrorException((Exception)ex);
        }
        return resourceFileNames;
    }

    @Override
    public Collection<String> searchAllIds() throws InternalErrorException {
        ArrayList<String> ids = new ArrayList<String>();
        InputStream is = this.getInputStreamForResourceList();
        Collection<String> resourceFileNames = this.getResourceFileNames(is);
        for (String resourceFileName : resourceFileNames) {
            String fileExtension = this.matchingFileExtension(resourceFileName);
            String id = resourceFileName.substring(resourceFileName.lastIndexOf("/") + 1, resourceFileName.length() - fileExtension.length() - 1);
            ids.add(id);
        }
        return ids;
    }

    @Override
    public void insert(E cmElement) throws InternalErrorException {
        throw new UnsupportedOperationException("Not allowed on resources DAO");
    }

    @Override
    public void update(E cmElement) throws InternalErrorException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not allowed on resources DAO");
    }

    @Override
    public void remove(String id) throws InternalErrorException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not allowed on resources DAO");
    }

    @Override
    public void removeAll() throws InternalErrorException {
        throw new UnsupportedOperationException("Not allowed on resources DAO");
    }

    @Override
    public Date getLastUpdateDate() throws InternalErrorException {
        return Calendar.getInstance().getTime();
    }

    private String matchingFileExtension(String fileName) throws InternalErrorException {
        for (String fileExtension : this.getFileExtensions()) {
            if (!fileName.endsWith("." + fileExtension)) continue;
            return fileExtension;
        }
        return null;
    }

    private void checkMissingInstance(Collection<String> ids, Collection<E> cmElements) throws InstanceNotFoundException {
        ArrayList<String> foundIds = new ArrayList<String>();
        for (CMElement cmElement : cmElements) {
            foundIds.add(cmElement.getId());
        }
        for (String id : ids) {
            if (foundIds.contains(id)) continue;
            throw new InstanceNotFoundException((Object)id, this.getCMElementClassName());
        }
    }

    private String getCMElementClassName() {
        return this.getCMElementClass().getSimpleName();
    }

    private Class<E> getCMElementClass() {
        return this.cmElementClass;
    }

    public Collection<String> getFileExtensions() throws InternalErrorException {
        if (this.fileExtensions == null) {
            this.fileExtensions = CMTypeManager.getInstance().getCMTypeByClass(this.getCMElementClass()).getFileExtensions();
        }
        return this.fileExtensions;
    }
}

