/*
 * Decompiled with CFR 0.152.
 */
package se.cambio.cm.model.generic.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.jberet.support.io.UnicodeBOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.cambio.cm.model.generic.dao.CMElementBuilder;
import se.cambio.cm.model.generic.dao.GenericCMElementDAO;
import se.cambio.cm.model.util.CMElement;
import se.cambio.cm.model.util.CMTypeManager;
import se.cambio.openehr.util.CmFolder;
import se.cambio.openehr.util.exceptions.FolderNotFoundException;
import se.cambio.openehr.util.exceptions.InstanceNotFoundException;
import se.cambio.openehr.util.exceptions.InternalErrorException;

public class FileGenericCMElementDAO<E extends CMElement>
implements GenericCMElementDAO<E> {
    private Class<E> cmElementClass;
    private CmFolder cmFolder;
    private Collection<String> fileExtensions;
    private Logger logger = LoggerFactory.getLogger(FileGenericCMElementDAO.class);

    public FileGenericCMElementDAO(Class<E> cmElementClass, CmFolder cmFolder) {
        this.cmElementClass = cmElementClass;
        this.cmFolder = cmFolder;
    }

    @Override
    public Collection<E> searchByIds(Collection<String> ids) throws InternalErrorException, InstanceNotFoundException {
        Collection<E> cmElements = this.searchAll();
        ArrayList<CMElement> foundCMElements = new ArrayList<CMElement>();
        for (CMElement cmElement : cmElements) {
            if (!ids.contains(cmElement.getId())) continue;
            foundCMElements.add(cmElement);
        }
        this.checkMissingInstance(ids, foundCMElements);
        return foundCMElements;
    }

    @Override
    public Collection<String> searchAllIds() throws InternalErrorException {
        if (!this.getFolder().isDirectory()) {
            throw new FolderNotFoundException(this.getFolder().getAbsolutePath());
        }
        ArrayList<String> ids = new ArrayList<String>();
        File[] listOfFiles = this.getFolder().listFiles();
        if (listOfFiles != null) {
            for (File listOfFile : listOfFiles) {
                String fileName;
                String fileExtension;
                if (!listOfFile.isFile() || (fileExtension = this.matchingFileExtension(fileName = listOfFile.getName())) == null) continue;
                String id = this.getId(fileName, fileExtension);
                ids.add(id);
            }
        }
        return ids;
    }

    @Override
    public Collection<E> searchAll() throws InternalErrorException {
        ArrayList<E> cmElements = new ArrayList<E>();
        if (!this.getFolder().isDirectory()) {
            throw new FolderNotFoundException(this.getFolder().getAbsolutePath());
        }
        File[] listOfFiles = this.getFolder().listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                String fileName;
                String fileExtension;
                if (!file.isFile() || (fileExtension = this.matchingFileExtension(fileName = file.getName())) == null) continue;
                try (FileInputStream fis = new FileInputStream(file.getAbsolutePath());){
                    E cmElement = this.getCMElement(fileName, fileExtension, fis, new Date(file.lastModified()));
                    cmElements.add(cmElement);
                }
                catch (Exception ex) {
                    this.logger.error("Reading file : " + fileName, (Throwable)ex);
                }
            }
        }
        return cmElements;
    }

    public E getCMElement(String fileName, String fileExtension, InputStream fis, Date date) throws IOException, InternalErrorException {
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(fis);
        ubis.skipBOM();
        String id = this.getId(fileName, fileExtension);
        String src = IOUtils.toString((InputStream)ubis, (String)"UTF-8");
        return new CMElementBuilder().setId(id).setFormat(fileExtension).setSource(src).setLastUpdate(date).createCMElement(this.cmElementClass);
    }

    private String getId(String fileName, String fileExtension) {
        return fileName.substring(0, fileName.length() - fileExtension.length() - 1);
    }

    private String matchingFileExtension(String fileName) throws InternalErrorException {
        for (String fileExtension : this.getFileExtensions()) {
            if (!fileName.endsWith("." + fileExtension)) continue;
            return fileExtension;
        }
        return null;
    }

    @Override
    public void insert(E cmElement) throws InternalErrorException {
        this.upsert(cmElement);
    }

    @Override
    public void update(E cmElement) throws InternalErrorException {
        this.upsert(cmElement);
    }

    private void upsert(E cmElement) throws InternalErrorException {
        if (!this.getFolder().isDirectory()) {
            throw new FolderNotFoundException(this.getFolder().getAbsolutePath());
        }
        File file = new File(this.getFolder(), cmElement.getId() + "." + cmElement.getFormat());
        try {
            Files.write(Paths.get(file.toURI()), cmElement.getSource().getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new InternalErrorException((Exception)ex);
        }
    }

    @Override
    public void remove(String id) throws InternalErrorException {
        if (!this.getFolder().isDirectory()) {
            throw new FolderNotFoundException(this.getFolder().getAbsolutePath());
        }
        File file = new File(this.getFolder(), id + "." + this.getFileExtensions().iterator().next());
        file.delete();
    }

    @Override
    public void removeAll() throws InternalErrorException {
        File[] listOfFiles = this.getFolder().listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file = listOfFiles[i];
                String matchingExtension = this.matchingFileExtension(file.getName());
                if (matchingExtension == null) continue;
                String id = this.getId(file.getName(), matchingExtension);
                this.remove(id);
            }
        }
    }

    @Override
    public Date getLastUpdateDate() throws InternalErrorException {
        if (!this.getFolder().isDirectory()) {
            throw new FolderNotFoundException(this.getFolder().getAbsolutePath());
        }
        Date lastModifiedDate = null;
        File[] listOfFiles = this.getFolder().listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file = listOfFiles[i];
                Date date = new Date(file.lastModified());
                if (lastModifiedDate != null && !date.after(lastModifiedDate)) continue;
                lastModifiedDate = date;
            }
        }
        return lastModifiedDate;
    }

    private File getFolder() {
        return this.cmFolder.getFolder();
    }

    private void checkMissingInstance(Collection<String> ids, Collection<E> cmElements) throws InstanceNotFoundException {
        ArrayList<String> foundIds = new ArrayList<String>();
        for (CMElement cmElement : cmElements) {
            foundIds.add(cmElement.getId());
        }
        for (String id : ids) {
            if (foundIds.contains(id)) continue;
            throw new InstanceNotFoundException((Object)id, this.getCMElementClassName());
        }
    }

    private String getCMElementClassName() {
        return this.getCMElementClass().getSimpleName();
    }

    private Class<E> getCMElementClass() {
        return this.cmElementClass;
    }

    public Collection<String> getFileExtensions() throws InternalErrorException {
        if (this.fileExtensions == null) {
            this.fileExtensions = CMTypeManager.getInstance().getCMTypeByClass(this.getCMElementClass()).getFileExtensions();
        }
        return this.fileExtensions;
    }
}

