/*
 * Decompiled with CFR 0.152.
 */
package se.cambio.cm.model.generic.dao;

import java.util.Date;
import se.cambio.cm.model.util.CMElement;
import se.cambio.openehr.util.exceptions.InternalErrorException;

public class CMElementBuilder<E extends CMElement> {
    private String id;
    private String format;
    private String source;
    private Date lastUpdate;

    public CMElementBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public CMElementBuilder setFormat(String format) {
        this.format = format;
        return this;
    }

    public CMElementBuilder setSource(String source) {
        this.source = source;
        return this;
    }

    public CMElementBuilder setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    public E createCMElement(Class<E> cmElementClass) throws InternalErrorException {
        try {
            this.checkMissingAttributes();
            CMElement cmElement = (CMElement)cmElementClass.newInstance();
            cmElement.setId(this.id);
            cmElement.setFormat(this.format);
            cmElement.setSource(this.source);
            cmElement.setLastUpdate(this.lastUpdate);
            return (E)cmElement;
        }
        catch (Exception ex) {
            throw new InternalErrorException(ex);
        }
    }

    private void checkMissingAttributes() throws InternalErrorException {
        if (this.id == null) {
            throw new InternalErrorException(new Exception("No id specified for cmElement"));
        }
        if (this.format == null) {
            throw new InternalErrorException(new Exception("No format specified for cmElement"));
        }
        if (this.source == null) {
            throw new InternalErrorException(new Exception("No source specified for cmElement"));
        }
        if (this.lastUpdate == null) {
            throw new InternalErrorException(new Exception("No lastUpdate specified for cmElement"));
        }
    }
}

