/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.friendularity.bundle.ui.swing.animation.PlayerClientComboBoxModel;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroMessageSenderLifecycle;
import org.jflux.impl.messaging.rk.utils.ConnectionManager;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.jflux.impl.services.rk.lifecycle.ManagedService;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.lifecycle.AnimationPlayerClientLifecycle;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.animation.protocol.AnimationEvent;
import org.mechio.api.animation.protocol.AnimationSignal;
import org.mechio.impl.animation.messaging.AnimationRecord;
import org.mechio.impl.animation.messaging.AnimationSignallingRecord;
import org.mechio.impl.animation.messaging.PortableAnimationEvent;
import org.mechio.impl.animation.messaging.PortableAnimationSignal;
import org.osgi.framework.BundleContext;

public class PlayerClientPanel
extends JPanel
implements Source<RemoteAnimationPlayerClient> {
    private AnimationPlayerClientLifecycle myLifecycle;
    private ManagedService myPlayerService;
    private ManagedService mySenderService;
    private ManagedService myConnectionService;
    private ManagedService mySessionService;
    private ManagedService myReceiverService;
    private boolean myStartFlag;
    private PlayerClientComboBoxModel myModel;
    private JButton btnClear;
    private JButton btnConnect;
    private JButton btnDisconnect;
    private JComboBox jComboBox1;
    private JLabel jLabel1;

    public PlayerClientPanel() {
        this.initComponents();
        this.myModel = new PlayerClientComboBoxModel();
        this.jComboBox1.setModel(this.myModel);
        this.jComboBox1.setEditable(true);
        this.myStartFlag = false;
        this.btnDisconnect.setEnabled(false);
        this.btnClear.setEnabled(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.btnConnect = new JButton();
        this.btnDisconnect = new JButton();
        this.btnClear = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jLabel1.setText("Ip Address");
        this.btnConnect.setText("Connect");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerClientPanel.this.btnConnectActionPerformed(evt);
            }
        });
        this.btnDisconnect.setText("Disconnect");
        this.btnDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerClientPanel.this.btnDisconnectActionPerformed(evt);
            }
        });
        this.btnClear.setText("Clear Remote Animations");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerClientPanel.this.btnClearActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(4, 4, 4).addComponent(this.jComboBox1, 0, 123, Short.MAX_VALUE)).addComponent(this.btnClear)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnConnect, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnDisconnect, GroupLayout.Alignment.TRAILING))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnConnect).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDisconnect).addComponent(this.btnClear))));
    }

    private void btnDisconnectActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        this.startOnce();
        this.btnConnect.setEnabled(!this.myStartFlag);
        this.btnDisconnect.setEnabled(this.myStartFlag);
        this.btnClear.setEnabled(this.myStartFlag);
    }

    private synchronized void startOnce() {
        if (this.myStartFlag) {
            return;
        }
        BundleContext context = OSGiUtils.getBundleContext(Animation.class);
        String ip = this.myModel.getSelectedItem().toString();
        Connection con = ConnectionManager.createConnection((String)ConnectionUtils.getUsername(), (String)ConnectionUtils.getPassword(), (String)"client1", (String)"test", (String)("tcp://" + ip + ":5672"));
        try {
            con.start();
        }
        catch (JMSException ex) {
            JOptionPane.showMessageDialog(this, "Unable to connect to " + ip, "Connection Error", 0);
            return;
        }
        this.myConnectionService = new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)con, Connection.class));
        this.myConnectionService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteAnimConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationRequest", "animationRequest", 1, null});
        JMSAvroMessageSenderLifecycle senderLife = new JMSAvroMessageSenderLifecycle((Adapter)new PortableAnimationEvent.MessageRecordAdapter(), AnimationEvent.class, AnimationRecord.class, "remoteAnimSender", "remoteAnimConnection", "remoteAnimationRequest");
        this.registerEventFactory(context);
        this.mySenderService = new OSGiComponent(context, (ServiceLifecycleProvider)senderLife);
        this.mySenderService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteSignalConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationSignal", "animationSignal", 1, null});
        JMSAvroAsyncReceiverLifecycle receiverLife = new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableAnimationSignal.RecordMessageAdapter(), AnimationSignal.class, AnimationSignallingRecord.class, AnimationSignallingRecord.SCHEMA$, "remoteSignalReceiver", "remoteSignalConnection", "remoteAnimationSignal");
        this.myReceiverService = new OSGiComponent(context, (ServiceLifecycleProvider)receiverLife);
        this.myReceiverService.start();
        this.myLifecycle = new AnimationPlayerClientLifecycle("remotePlayer", "remotePlayer", "remoteAnimSender", "remoteSignalReceiver", context);
        this.myPlayerService = new OSGiComponent(context, (ServiceLifecycleProvider)this.myLifecycle);
        this.myPlayerService.start();
        this.myStartFlag = true;
    }

    private void registerEventFactory(BundleContext context) {
        if (OSGiUtils.serviceExists((BundleContext)context, AnimationEvent.AnimationEventFactory.class, null).booleanValue()) {
            return;
        }
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableAnimationEvent.Factory(), AnimationEvent.AnimationEventFactory.class)).start();
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        if (this.myLifecycle == null) {
            return;
        }
        RemoteAnimationPlayerClient client = (RemoteAnimationPlayerClient)this.myLifecycle.getService();
        if (client == null) {
            return;
        }
        client.clearAnimations();
    }

    private synchronized void stop() {
        if (this.myPlayerService != null) {
            this.myPlayerService.dispose();
            this.myPlayerService = null;
        }
        if (this.mySenderService != null) {
            this.mySenderService.dispose();
            this.mySenderService = null;
        }
        if (this.myConnectionService != null) {
            this.myConnectionService.dispose();
            this.myConnectionService = null;
        }
        if (this.mySessionService != null) {
            this.mySessionService.dispose();
            this.mySessionService = null;
        }
        this.myStartFlag = false;
        this.btnConnect.setEnabled(!this.myStartFlag);
        this.btnDisconnect.setEnabled(this.myStartFlag);
        this.btnClear.setEnabled(this.myStartFlag);
    }

    public RemoteAnimationPlayerClient getValue() {
        if (this.myLifecycle == null) {
            return null;
        }
        return (RemoteAnimationPlayerClient)this.myLifecycle.getService();
    }
}

