/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQConnectionFactory;
import org.jflux.api.core.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingConnectImpl {
    private static final Logger theLogger = LoggerFactory.getLogger((String)MessagingConnectImpl.class.getName());
    private static final String theAMQPFormatString = "amqp://%s:%s@%s/%s?brokerlist='%s'";
    Connection myConnection;
    Session mySession;
    Destination myDestination;
    private Source<String> myIpSource;
    private Source<String> myDestSource;
    private Source<String> myPortSource;
    private Source<String> myUsernameSource;
    private Source<String> myPasswordSource;
    private Source<String> myClientNameSource;
    private Source<String> myVirtualHostSource;

    public void setBrokerAddress(Source<String> ipSrc, Source<String> portSource, Source<String> usernameSource, Source<String> passwordSource, Source<String> clientNameSource, Source<String> virtualHostSource) {
        if (ipSrc == null || portSource == null || usernameSource == null || passwordSource == null || clientNameSource == null || virtualHostSource == null) {
            throw new NullPointerException();
        }
        this.myIpSource = ipSrc;
        this.myPortSource = portSource;
        this.myUsernameSource = usernameSource;
        this.myPasswordSource = passwordSource;
        this.myClientNameSource = clientNameSource;
        this.myVirtualHostSource = virtualHostSource;
    }

    public void setDestination(Source<String> src) {
        if (src == null) {
            throw new NullPointerException();
        }
        this.myDestSource = src;
    }

    public boolean connect() {
        this.myDestination = this.buildDestination();
        if (this.myDestination == null) {
            return false;
        }
        this.myConnection = this.buildConnection();
        if (this.myConnection == null) {
            return false;
        }
        this.mySession = this.buildSession(this.myConnection);
        if (this.mySession == null) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public void disconnect() {
        if (this.mySession != null) {
            this.mySession = null;
        }
        if (this.myConnection != null) {
            try {
                this.myConnection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.myConnection = null;
        }
    }

    private String createAMQPConnectionURL(String username, String password, String clientName, String virtualHost, String tcpAddress) {
        return String.format(theAMQPFormatString, username, password, clientName, virtualHost, tcpAddress);
    }

    private Connection buildConnection() {
        String ip = (String)this.myIpSource.getValue();
        if (ip == null) {
            throw new NullPointerException();
        }
        String port = (String)this.myPortSource.getValue();
        String addr = "tcp://" + ip + ":" + port;
        String url = this.createAMQPConnectionURL((String)this.myUsernameSource.getValue(), (String)this.myPasswordSource.getValue(), (String)this.myClientNameSource.getValue(), (String)this.myVirtualHostSource.getValue(), addr);
        try {
            String reconnectOptions = "&connectdelay='5000'&retries='2147483647'";
            url = url + reconnectOptions;
            AMQConnectionFactory fact = new AMQConnectionFactory(url);
            Connection con = fact.createConnection();
            if (con == null) {
                return null;
            }
            con.start();
            return con;
        }
        catch (Exception ex) {
            theLogger.warn("Error creating Session.", (Throwable)ex);
            return null;
        }
    }

    private Session buildSession(Connection con) {
        if (con == null) {
            throw new NullPointerException();
        }
        try {
            return con.createSession(false, 2);
        }
        catch (Exception ex) {
            theLogger.warn("Error creating Session.", (Throwable)ex);
            return null;
        }
    }

    private Destination buildDestination() {
        String dest = (String)this.myDestSource.getValue();
        if (dest == null) {
            throw new NullPointerException();
        }
        try {
            return new AMQAnyDestination(dest);
        }
        catch (URISyntaxException ex) {
            theLogger.warn("Error creating Destination.", (Throwable)ex);
            return null;
        }
    }

    public Session getSession() {
        return this.mySession;
    }

    public Destination getDestination() {
        return this.myDestination;
    }
}

