/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.friendularity.bundle.ui.swing.animation.AnimationListPanel;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.core.Source;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.library.AnimationLibrary;
import org.mechio.api.animation.library.AnimationLibraryLoader;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.animation.xml.AnimationFileReader;
import org.mechio.api.animation.xml.AnimationXML;

public class AnimationLibraryPanel
extends JPanel {
    private AnimationLibrary myPromptLibrary;
    private Source<RemoteAnimationPlayerClient> myPlayerSource;
    private List<String> myFilters;
    private AnimationListPanel animationListPanel1;
    private JButton btnAdd;
    private JButton btnBrowse;
    private JButton btnClear;
    private JButton btnStopAll;
    private JLabel jLabel1;
    private JTextField txtAnimationFolderPath;

    public AnimationLibraryPanel() {
        this.initComponents();
    }

    public void setPlayerSource(Source<RemoteAnimationPlayerClient> playerSource) {
        this.animationListPanel1.setSource(playerSource);
        this.myPlayerSource = playerSource;
    }

    public void setPromptLibrary(AnimationLibrary library) {
        this.myPromptLibrary = library;
    }

    public void refresh(String path) {
        this.animationListPanel1.clearAnimations();
        this.repaint();
        if (path == null) {
            path = this.txtAnimationFolderPath.getText();
            this.addAnimationFolder(path);
        } else {
            this.addAnimationFolder(path);
            this.txtAnimationFolderPath.setText(path);
        }
    }

    private void initComponents() {
        this.txtAnimationFolderPath = new JTextField();
        this.jLabel1 = new JLabel();
        this.btnAdd = new JButton();
        this.btnClear = new JButton();
        this.btnBrowse = new JButton();
        this.animationListPanel1 = new AnimationListPanel();
        this.btnStopAll = new JButton();
        this.txtAnimationFolderPath.setText("./resources/animations/");
        this.jLabel1.setText("Animation Folder:");
        this.btnAdd.setText("Add Folder");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationLibraryPanel.this.btnAddActionPerformed(evt);
            }
        });
        this.btnClear.setText("Clear Animations");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationLibraryPanel.this.btnClearActionPerformed(evt);
            }
        });
        this.btnBrowse.setText("Browse");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationLibraryPanel.this.btnBrowseActionPerformed(evt);
            }
        });
        this.btnStopAll.setText("Stop All");
        this.btnStopAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationLibraryPanel.this.btnStopAllActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnStopAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnClear)).addGroup(layout.createSequentialGroup().addComponent(this.txtAnimationFolderPath, -1, 229, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowse)).addComponent(this.animationListPanel1, -1, 301, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAnimationFolderPath, -2, -1, -2).addComponent(this.btnBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.animationListPanel1, -1, 425, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClear).addComponent(this.btnStopAll))));
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        try {
            File file = this.chooseFile();
            if (file == null) {
                return;
            }
            this.txtAnimationFolderPath.setText(file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private File chooseFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f != null && f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Animation Directory";
            }
        });
        int ret = chooser.showOpenDialog(null);
        if (ret != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (file != null && !file.isDirectory()) {
            return null;
        }
        return file;
    }

    public void addAnimationFolder(String folderPath) {
        try {
            AnimationFileReader reader = AnimationXML.getRegisteredReader();
            if (reader == null) {
                return;
            }
            AnimationLibrary lib = AnimationLibraryLoader.loadAnimationFolder((String)"library", (AnimationFileReader)reader, (String)folderPath, (boolean)true);
            if (lib == null) {
                return;
            }
            ArrayList<Animation> animList = new ArrayList<Animation>();
            for (VersionProperty prop : lib.getAnimationVersions()) {
                Animation anim = lib.getAnimation(prop);
                if (anim == null) continue;
                if (!animList.contains(anim)) {
                    animList.add(anim);
                }
                if (this.myPromptLibrary == null) continue;
                this.myPromptLibrary.add(anim);
            }
            this.animationListPanel1.addAnimations(animList);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        String path = this.txtAnimationFolderPath.getText();
        this.addAnimationFolder(path);
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.animationListPanel1.clearAnimations();
        if (this.myPromptLibrary != null) {
            this.myPromptLibrary.clear();
        }
        this.repaint();
    }

    private void btnStopAllActionPerformed(ActionEvent evt) {
        ((RemoteAnimationPlayerClient)this.myPlayerSource.getValue()).stopAllAnimations();
    }
}

