/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.avro.Schema;
import org.friendularity.bundle.ui.swing.animation.MessagingConnectPanel;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.DefaultConfigProperty;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.util.DefaultSource;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.impl.messaging.JMSAvroUtils;
import org.jflux.impl.messaging.rk.ServiceCommandRecord;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.library.AnimationLibrary;
import org.mechio.api.animation.library.DefaultAnimationLibrary;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimPromptPanel
extends JPanel
implements Source<AnimationLibrary> {
    private static final Logger theLogger = LoggerFactory.getLogger(AnimPromptPanel.class);
    private AnimationLibrary myLibrary;
    private Source<RemoteAnimationPlayerClient> myPlayerSource;
    private ProducerNode<ServiceCommand> myPromptProducer;
    private JButton btnConnect;
    private JButton btnStart;
    private MessagingConnectPanel pnlPromptConnect;
    private List<String> defAnims = Arrays.asList("LEGS", "BLINK", "FACE", "ARMS");

    public AnimPromptPanel() {
        this.initComponents();
        DefaultConfigProperty destProp = new DefaultConfigProperty(String.class, (Object)"animPrompt; {create: always, node: {type: topic}}");
        this.pnlPromptConnect.setDestination((Source<String>)destProp.getSource(), (Listener<String>)destProp.getSetter());
        DefaultConfigProperty ipAddrProp = new DefaultConfigProperty(String.class, (Object)"127.0.0.1");
        this.pnlPromptConnect.setBrokerAddress((Source<String>)ipAddrProp.getSource(), (Listener<String>)ipAddrProp.getSetter(), (Source<String>)new DefaultSource((Object)"5672"), (Source<String>)new DefaultSource((Object)ConnectionUtils.getUsername()), (Source<String>)new DefaultSource((Object)ConnectionUtils.getPassword()), (Source<String>)new DefaultSource((Object)"client1"), (Source<String>)new DefaultSource((Object)"test"));
        this.myLibrary = new DefaultAnimationLibrary("prompt");
    }

    public void setPlayerSource(Source<RemoteAnimationPlayerClient> playerSource) {
        this.myPlayerSource = playerSource;
    }

    private void initComponents() {
        this.pnlPromptConnect = new MessagingConnectPanel();
        this.btnConnect = new JButton();
        this.btnStart = new JButton();
        this.btnConnect.setText("Connect");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimPromptPanel.this.btnConnectActionPerformed(evt);
            }
        });
        this.btnStart.setText("start");
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimPromptPanel.this.btnStartActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlPromptConnect, -1, 502, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnStart, -1, -1, Short.MAX_VALUE).addComponent(this.btnConnect, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnStart)).addComponent(this.pnlPromptConnect, -2, -1, -2));
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        this.pnlPromptConnect.connect();
        Session session = this.pnlPromptConnect.getSession();
        Destination dest = this.pnlPromptConnect.getDestination();
        this.myPromptProducer = this.buildSpeechRecChain(session, dest);
        this.myPromptProducer.getNotifier().addListener((Listener)new Listener<ServiceCommand>(){

            public void handleEvent(ServiceCommand input) {
                String animName = input.getCommand();
                if (animName == null) {
                    return;
                }
                RemoteAnimationPlayerClient player = (RemoteAnimationPlayerClient)AnimPromptPanel.this.myPlayerSource.getValue();
                if (player == null) {
                    theLogger.info("No player set, unable to play: " + animName);
                    return;
                }
                theLogger.info("Received Anim Prompt: " + animName);
                VersionProperty p = new VersionProperty(animName, "1.0");
                Animation anim = AnimPromptPanel.this.myLibrary.getAnimation(p);
                if (anim == null) {
                    animName = animName.toLowerCase();
                    p = new VersionProperty(animName, "1.0");
                    anim = AnimPromptPanel.this.myLibrary.getAnimation(p);
                }
                if (anim == null) {
                    animName = animName.toUpperCase();
                    p = new VersionProperty(animName, "1.0");
                    anim = AnimPromptPanel.this.myLibrary.getAnimation(p);
                }
                if (anim == null) {
                    theLogger.info("No anim found for: " + animName);
                    AnimPromptPanel.this.restartDefs();
                    return;
                }
                if (AnimPromptPanel.this.myPlayerSource == null) {
                    theLogger.info("No player set, unable to play: " + animName);
                    return;
                }
                theLogger.info("Playing animation: " + animName);
                if (anim.getChannels().size() > 10) {
                    AnimPromptPanel.this.stop("FACE");
                }
                AnimPromptPanel.this.stop("ARMS");
                player.playAnimation(anim);
                AnimPromptPanel.this.waitRestart(anim.getLength() + 1500L);
            }
        });
        this.myPromptProducer.start();
    }

    private void waitRestart(final long time) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AnimPromptPanel.this.restartDefs();
            }
        }).start();
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        this.startDefs();
    }

    private ProducerNode<ServiceCommand> buildSpeechRecChain(Session session, Destination dest) {
        try {
            return JMSAvroUtils.buildEventReceiverChain(ServiceCommandRecord.class, (Schema)ServiceCommandRecord.SCHEMA$, (Adapter)new EmptyAdapter(), (Session)session, (Destination)dest);
        }
        catch (JMSException ex) {
            theLogger.warn("Error connecting to Anim Prompt.", (Throwable)ex);
            return null;
        }
    }

    public AnimationLibrary getValue() {
        return this.myLibrary;
    }

    private void startDefs() {
        for (String s : this.defAnims) {
            this.loop(s);
        }
    }

    private void restartDefs() {
        RemoteAnimationPlayerClient p = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (this.myLibrary == null || p == null) {
            return;
        }
        for (VersionProperty prop : this.myLibrary.getAnimationVersions()) {
            if (this.defAnims.contains(prop.getName())) continue;
            Animation a = this.myLibrary.getAnimation(prop);
            p.stopAnimation(a);
        }
        this.startDefs();
    }

    private void loop(String anim) {
        RemoteAnimationPlayerClient p = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (this.myLibrary == null || p == null) {
            return;
        }
        Animation legs = this.myLibrary.getAnimation(new VersionProperty(anim, "1.0"));
        if (legs != null) {
            p.loopAnimation(legs);
        }
    }

    private void stop(String anim) {
        RemoteAnimationPlayerClient p = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (this.myLibrary == null || p == null) {
            return;
        }
        Animation legs = this.myLibrary.getAnimation(new VersionProperty(anim, "1.0"));
        if (legs != null) {
            p.stopAnimation(legs);
        }
    }
}

