/*
 * Copyright 2014 the Friendularity Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * PlayerClientPanel.java
 *
 * Created on Jul 13, 2012, 2:53:20 AM
 */
package org.friendularity.bundle.ui.swing.animation;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.swing.JOptionPane;
import org.jflux.api.core.Source;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroMessageSenderLifecycle;
import org.jflux.impl.messaging.rk.utils.ConnectionManager;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.osgi.framework.BundleContext;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.lifecycle.AnimationPlayerClientLifecycle;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.animation.protocol.AnimationEvent;
import org.mechio.api.animation.protocol.AnimationEvent.AnimationEventFactory;
import org.mechio.api.animation.protocol.AnimationSignal;
import org.jflux.impl.services.rk.lifecycle.ManagedService;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.mechio.impl.animation.messaging.AnimationRecord;
import org.mechio.impl.animation.messaging.AnimationSignallingRecord;
import org.mechio.impl.animation.messaging.PortableAnimationEvent;
import org.mechio.impl.animation.messaging.PortableAnimationSignal;

/**
 *
 * @author Matthew Stevenson
 */
public class PlayerClientPanel extends javax.swing.JPanel implements Source<RemoteAnimationPlayerClient>{
    private AnimationPlayerClientLifecycle myLifecycle;
    private ManagedService myPlayerService;
    private ManagedService mySenderService;
    private ManagedService myConnectionService;
    private ManagedService mySessionService;
    private ManagedService myReceiverService;
    private boolean myStartFlag;
    private PlayerClientComboBoxModel myModel;
    /** Creates new form PlayerClientPanel */
    public PlayerClientPanel() {
        initComponents();
        myModel = new PlayerClientComboBoxModel();
        jComboBox1.setModel(myModel);
        jComboBox1.setEditable(true);
        
        myStartFlag = false;
        btnDisconnect.setEnabled(false);
        btnClear.setEnabled(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        btnConnect = new javax.swing.JButton();
        btnDisconnect = new javax.swing.JButton();
        btnClear = new javax.swing.JButton();
        jComboBox1 = new javax.swing.JComboBox();

        jLabel1.setText("Ip Address");

        btnConnect.setText("Connect");
        btnConnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnConnectActionPerformed(evt);
            }
        });

        btnDisconnect.setText("Disconnect");
        btnDisconnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDisconnectActionPerformed(evt);
            }
        });

        btnClear.setText("Clear Remote Animations");
        btnClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnClearActionPerformed(evt);
            }
        });

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(4, 4, 4)
                        .addComponent(jComboBox1, 0, 123, Short.MAX_VALUE))
                    .addComponent(btnClear))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(btnConnect, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btnDisconnect, javax.swing.GroupLayout.Alignment.TRAILING)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnConnect)
                    .addComponent(jLabel1)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnDisconnect)
                    .addComponent(btnClear)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnDisconnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDisconnectActionPerformed
        stop();
    }//GEN-LAST:event_btnDisconnectActionPerformed

    private void btnConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnConnectActionPerformed
        startOnce();
        btnConnect.setEnabled(!myStartFlag);
        btnDisconnect.setEnabled(myStartFlag);
        btnClear.setEnabled(myStartFlag);
    }//GEN-LAST:event_btnConnectActionPerformed

    private synchronized void startOnce(){
        if(myStartFlag){
            return;
        }
        BundleContext context = OSGiUtils.getBundleContext(Animation.class);
        String ip = myModel.getSelectedItem().toString();
        Connection con = ConnectionManager.createConnection(
                ConnectionUtils.getUsername(), ConnectionUtils.getPassword(),
                "client1", "test",  "tcp://" + ip + ":5672");
        try{
            con.start();
        }catch(JMSException ex){
            JOptionPane.showMessageDialog(this, "Unable to connect to " + ip, "Connection Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        myConnectionService = new OSGiComponent(context, new SimpleLifecycle(con, Connection.class));
        myConnectionService.start();
        ConnectionUtils.ensureSession(context, 
                "remoteAnimConnection", con, null);
        ConnectionUtils.ensureDestinations(context, 
                "remoteAnimationRequest", "animationRequest", ConnectionUtils.TOPIC, null);
        JMSAvroMessageSenderLifecycle senderLife = 
                new JMSAvroMessageSenderLifecycle(
                        new PortableAnimationEvent.MessageRecordAdapter(), 
                        AnimationEvent.class, AnimationRecord.class, 
                        "remoteAnimSender", "remoteAnimConnection", 
                        "remoteAnimationRequest");
        registerEventFactory(context);
        mySenderService = new OSGiComponent(context, senderLife);
        mySenderService.start();
        ConnectionUtils.ensureSession(context, 
                "remoteSignalConnection", con, null);
        ConnectionUtils.ensureDestinations(context, 
                "remoteAnimationSignal", "animationSignal", ConnectionUtils.TOPIC, null);
        JMSAvroAsyncReceiverLifecycle receiverLife =
                new JMSAvroAsyncReceiverLifecycle(
                new PortableAnimationSignal.RecordMessageAdapter(),
                AnimationSignal.class, AnimationSignallingRecord.class,
                AnimationSignallingRecord.SCHEMA$, "remoteSignalReceiver",
                "remoteSignalConnection", "remoteAnimationSignal");
        myReceiverService = new OSGiComponent(context, receiverLife);
        myReceiverService.start();
        myLifecycle = 
                new AnimationPlayerClientLifecycle(
                "remotePlayer", "remotePlayer", "remoteAnimSender",
                "remoteSignalReceiver", context);
        myPlayerService = new OSGiComponent(context, myLifecycle);
        myPlayerService.start();
        myStartFlag = true;
    }
    
    private void registerEventFactory(BundleContext context){
        if(OSGiUtils.serviceExists(context, AnimationEvent.AnimationEventFactory.class, null)){
            return;
        }
        new OSGiComponent(context, 
                new SimpleLifecycle(
                        new PortableAnimationEvent.Factory(), 
                        AnimationEventFactory.class)
                ).start();
    }
    private void btnClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnClearActionPerformed
        if(myLifecycle == null){
            return;
        }
        RemoteAnimationPlayerClient client = myLifecycle.getService();
        if(client == null){
            return;
        }
        client.clearAnimations();
    }//GEN-LAST:event_btnClearActionPerformed

    private synchronized void stop(){
        if(myPlayerService != null){
            myPlayerService.dispose();
            myPlayerService = null;
        }
        if(mySenderService != null){
            mySenderService.dispose();
            mySenderService = null;
        }
        if(myConnectionService != null){
            myConnectionService.dispose();
            myConnectionService = null;
        }
        if(mySessionService != null){
            mySessionService.dispose();
            mySessionService = null;
        }
        myStartFlag = false;
        btnConnect.setEnabled(!myStartFlag);
        btnDisconnect.setEnabled(myStartFlag);
        btnClear.setEnabled(myStartFlag);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnClear;
    private javax.swing.JButton btnConnect;
    private javax.swing.JButton btnDisconnect;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    @Override
    public RemoteAnimationPlayerClient getValue() {
        if(myLifecycle == null){
            return null;
        }
        return myLifecycle.getService();
    }

}
