/*
 * Copyright 2012 by The Cogchar Project (www.cogchar.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * MessagingConnectPanel.java
 *
 * Created on Apr 26, 2012, 3:25:43 PM
 */
package org.friendularity.bundle.ui.swing.animation;

import javax.jms.*;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;

/**
 *
 * @author Matthew Stevenson <www.cogchar.org>
 */
public class MessagingConnectPanel extends javax.swing.JPanel {
    
    private MessagingConnectImpl myConnector;
    private Listener<String> myIpSetter;
    private Listener<String> myDestSetter;
        
    /** Creates new form MessagingConnectPanel */
    public MessagingConnectPanel() {
        initComponents();
        myConnector = new MessagingConnectImpl();
    }
    
    public void setBrokerAddress(
            Source<String> ipSrc, 
            Listener<String> ipSet,
            Source<String> portSource,
            Source<String> usernameSource,
            Source<String> passwordSource,
            Source<String> clientNameSource,
            Source<String> virtualHostSource){
        if(ipSrc == null || ipSet == null || portSource == null
                || usernameSource == null || passwordSource == null
                || clientNameSource == null || virtualHostSource == null){
            throw new NullPointerException();
        }
        myConnector.setBrokerAddress(
                ipSrc, portSource, usernameSource, passwordSource, 
                clientNameSource, virtualHostSource);
        myIpSetter = ipSet;
        txtBrokerAddress.setText(ipSrc.getValue());
    }
    
    public void setDestination(Source<String> src, Listener<String> set){
        if(src == null || set == null){
            throw new NullPointerException();
        }
        myConnector.setDestination(src);
        myDestSetter = set;
        txtDestination.setText(src.getValue());
    }
    
    public boolean connect(){
        String ip = txtBrokerAddress.getText();
        String dest = txtDestination.getText();
        myIpSetter.handleEvent(ip);
        myDestSetter.handleEvent(dest);
        boolean val = myConnector.connect();
        txtBrokerAddress.setEnabled(!val);
        txtDestination.setEnabled(!val);
        return val;
    }
    
    public void disconnect(){
        myConnector.disconnect();
        txtBrokerAddress.setEnabled(true);
        txtDestination.setEnabled(true);
    }
    
    public Session getSession(){
        return myConnector.getSession();
    }
    
    public Destination getDestination(){
        return myConnector.getDestination();
    }
    
    public MessagingConnectImpl getConnector(){
        return myConnector;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblDestination = new javax.swing.JLabel();
        lblBrokerAddress = new javax.swing.JLabel();
        txtBrokerAddress = new javax.swing.JTextField();
        txtDestination = new javax.swing.JTextField();

        lblDestination.setText("Destination"); // NOI18N

        lblBrokerAddress.setText("Broker Address"); // NOI18N

        txtBrokerAddress.setText("127.0.0.1"); // NOI18N

        txtDestination.setText("destinationName; {create: always, node: {type: queue}}"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblBrokerAddress)
                    .addComponent(lblDestination))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(txtDestination)
                    .addComponent(txtBrokerAddress, javax.swing.GroupLayout.DEFAULT_SIZE, 389, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblBrokerAddress)
                    .addComponent(txtBrokerAddress, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtDestination, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblDestination)))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblBrokerAddress;
    private javax.swing.JLabel lblDestination;
    private javax.swing.JTextField txtBrokerAddress;
    private javax.swing.JTextField txtDestination;
    // End of variables declaration//GEN-END:variables
}
