/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import javax.jms.Destination;
import javax.jms.Session;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.friendularity.bundle.ui.swing.animation.MessagingConnectImpl;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;

public class MessagingConnectPanel
extends JPanel {
    private MessagingConnectImpl myConnector;
    private Listener<String> myIpSetter;
    private Listener<String> myDestSetter;
    private JLabel lblBrokerAddress;
    private JLabel lblDestination;
    private JTextField txtBrokerAddress;
    private JTextField txtDestination;

    public MessagingConnectPanel() {
        this.initComponents();
        this.myConnector = new MessagingConnectImpl();
    }

    public void setBrokerAddress(Source<String> ipSrc, Listener<String> ipSet, Source<String> portSource, Source<String> usernameSource, Source<String> passwordSource, Source<String> clientNameSource, Source<String> virtualHostSource) {
        if (ipSrc == null || ipSet == null || portSource == null || usernameSource == null || passwordSource == null || clientNameSource == null || virtualHostSource == null) {
            throw new NullPointerException();
        }
        this.myConnector.setBrokerAddress(ipSrc, portSource, usernameSource, passwordSource, clientNameSource, virtualHostSource);
        this.myIpSetter = ipSet;
        this.txtBrokerAddress.setText((String)ipSrc.getValue());
    }

    public void setDestination(Source<String> src, Listener<String> set) {
        if (src == null || set == null) {
            throw new NullPointerException();
        }
        this.myConnector.setDestination(src);
        this.myDestSetter = set;
        this.txtDestination.setText((String)src.getValue());
    }

    public boolean connect() {
        String ip = this.txtBrokerAddress.getText();
        String dest = this.txtDestination.getText();
        this.myIpSetter.handleEvent((Object)ip);
        this.myDestSetter.handleEvent((Object)dest);
        boolean val = this.myConnector.connect();
        this.txtBrokerAddress.setEnabled(!val);
        this.txtDestination.setEnabled(!val);
        return val;
    }

    public void disconnect() {
        this.myConnector.disconnect();
        this.txtBrokerAddress.setEnabled(true);
        this.txtDestination.setEnabled(true);
    }

    public Session getSession() {
        return this.myConnector.getSession();
    }

    public Destination getDestination() {
        return this.myConnector.getDestination();
    }

    public MessagingConnectImpl getConnector() {
        return this.myConnector;
    }

    private void initComponents() {
        this.lblDestination = new JLabel();
        this.lblBrokerAddress = new JLabel();
        this.txtBrokerAddress = new JTextField();
        this.txtDestination = new JTextField();
        this.lblDestination.setText("Destination");
        this.lblBrokerAddress.setText("Broker Address");
        this.txtBrokerAddress.setText("127.0.0.1");
        this.txtDestination.setText("destinationName; {create: always, node: {type: queue}}");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBrokerAddress).addComponent(this.lblDestination)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtDestination).addComponent(this.txtBrokerAddress, -1, 389, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBrokerAddress).addComponent(this.txtBrokerAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDestination, -2, -1, -2).addComponent(this.lblDestination))));
    }
}

