/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.RepaintManager;
import org.jflux.api.core.Source;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.Channel;
import org.mechio.api.animation.editor.ChannelEditor;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.rwshop.swing.animation.AnimationRenderer;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.DefaultCoordinateScalar;

public class AnimationPanel
extends JPanel
implements Comparable<AnimationPanel> {
    private Animation myAnimation;
    private Source<RemoteAnimationPlayerClient> myPlayerSource;
    private JButton btnLoop;
    private JButton btnPlay;
    private JButton btnStop;
    private JLabel lblAnim;
    private AnimationRenderer pnlAnim;

    public AnimationPanel() {
        this.initComponents();
    }

    public void setAnimation(Animation anim) {
        if (anim == null) {
            return;
        }
        this.myAnimation = anim;
        this.lblAnim.setText(this.myAnimation.getVersion().display());
        HashMap<Integer, PathProperties> props = new HashMap<Integer, PathProperties>();
        for (Channel chan : anim.getChannels()) {
            int id = chan.getId();
            Color col = ChannelEditor.getChannelColor((Integer)id);
            PathProperties chanProps = new PathProperties(null, col, null);
            props.put(chan.getId(), chanProps);
        }
        DefaultCoordinateScalar scalar = new DefaultCoordinateScalar();
        this.pnlAnim.setScalar((CoordinateScalar)scalar);
        this.pnlAnim.setAnimation(this.myAnimation, props);
        RepaintManager.currentManager(this).markCompletelyDirty((JComponent)this.pnlAnim);
    }

    public Animation getAnimation() {
        return this.myAnimation;
    }

    public void setPlayerSource(Source<RemoteAnimationPlayerClient> player) {
        this.myPlayerSource = player;
    }

    public String getAnimationName() {
        return this.myAnimation.getVersion().display();
    }

    private void initComponents() {
        this.pnlAnim = new AnimationRenderer();
        this.btnLoop = new JButton();
        this.btnStop = new JButton();
        this.btnPlay = new JButton();
        this.lblAnim = new JLabel();
        this.setMaximumSize(new Dimension(3509999, 64));
        this.setMinimumSize(new Dimension(0, 64));
        this.setPreferredSize(new Dimension(350, 64));
        GroupLayout pnlAnimLayout = new GroupLayout((Container)this.pnlAnim);
        this.pnlAnim.setLayout((LayoutManager)pnlAnimLayout);
        pnlAnimLayout.setHorizontalGroup(pnlAnimLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 189, Short.MAX_VALUE));
        pnlAnimLayout.setVerticalGroup(pnlAnimLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        this.btnLoop.setText("Loop");
        this.btnLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationPanel.this.btnLoopActionPerformed(evt);
            }
        });
        this.btnStop.setText("Stop");
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationPanel.this.btnStopActionPerformed(evt);
            }
        });
        this.btnPlay.setText("Play");
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationPanel.this.btnPlayActionPerformed(evt);
            }
        });
        this.lblAnim.setText("Animation Name");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.pnlAnim, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPlay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStop).addContainerGap()).addComponent(this.lblAnim, -1, 350, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblAnim).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLoop, -1, -1, Short.MAX_VALUE).addComponent(this.btnStop, -1, -1, Short.MAX_VALUE).addComponent(this.btnPlay, -1, -1, Short.MAX_VALUE).addComponent((Component)this.pnlAnim, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void btnPlayActionPerformed(ActionEvent evt) {
        if (this.myAnimation == null || this.myPlayerSource == null) {
            return;
        }
        RemoteAnimationPlayerClient player = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (player == null) {
            return;
        }
        player.playAnimation(this.myAnimation);
    }

    private void btnLoopActionPerformed(ActionEvent evt) {
        if (this.myAnimation == null || this.myPlayerSource == null) {
            return;
        }
        RemoteAnimationPlayerClient player = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (player == null) {
            return;
        }
        player.loopAnimation(this.myAnimation);
    }

    private void btnStopActionPerformed(ActionEvent evt) {
        if (this.myAnimation == null || this.myPlayerSource == null) {
            return;
        }
        RemoteAnimationPlayerClient player = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (player == null) {
            return;
        }
        player.stopAnimation(this.myAnimation);
    }

    @Override
    public int compareTo(AnimationPanel o) {
        String name = this.getAnimationName();
        String otherName = o.getAnimationName();
        return name.compareTo(otherName);
    }
}

