/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.friendularity.bundle.ui.swing.animation.MessagingConnectImpl;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.DefaultConfigProperty;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.util.DefaultSource;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.impl.messaging.JMSAvroUtils;
import org.jflux.impl.messaging.rk.ServiceCommandRecord;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.library.AnimationLibrary;
import org.mechio.api.animation.library.DefaultAnimationLibrary;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;

public class AnimPromptConnector
implements Source<AnimationLibrary> {
    private static final Logger theLogger = Logger.getLogger(AnimPromptConnector.class.getName());
    private AnimationLibrary myLibrary;
    private Source<RemoteAnimationPlayerClient> myPlayerSource;
    private ProducerNode<ServiceCommand> myPromptProducer;
    private Listener<String> myIpListener;
    private MessagingConnectImpl myPromptConnect;
    private static final String SLEEP_DELIM = ":SLEEP:";
    private List<String> defAnims = Arrays.asList("LEGS", "BLINK", "FACE", "ARMS");

    public AnimPromptConnector() {
        DefaultConfigProperty destProp = new DefaultConfigProperty(String.class, (Object)"animPrompt; {create: always, node: {type: topic}}");
        this.myPromptConnect = new MessagingConnectImpl();
        this.myPromptConnect.setDestination((Source<String>)destProp.getSource());
        DefaultConfigProperty ipAddrProp = new DefaultConfigProperty(String.class, (Object)"127.0.0.1");
        this.myIpListener = ipAddrProp.getSetter();
        this.myPromptConnect.setBrokerAddress((Source<String>)ipAddrProp.getSource(), (Source<String>)new DefaultSource((Object)"5672"), (Source<String>)new DefaultSource((Object)ConnectionUtils.getUsername()), (Source<String>)new DefaultSource((Object)ConnectionUtils.getPassword()), (Source<String>)new DefaultSource((Object)"client1"), (Source<String>)new DefaultSource((Object)"test"));
        this.myLibrary = new DefaultAnimationLibrary("prompt");
    }

    public Listener<String> getIpSetter() {
        return this.myIpListener;
    }

    public boolean connect() {
        if (!this.myPromptConnect.connect()) {
            return false;
        }
        Session session = this.myPromptConnect.getSession();
        Destination dest = this.myPromptConnect.getDestination();
        this.myPromptProducer = this.buildSpeechRecChain(session, dest);
        this.myPromptProducer.getNotifier().addListener((Listener)new Listener<ServiceCommand>(){

            public void handleEvent(ServiceCommand input) {
                String animName = input.getCommand();
                if (animName == null) {
                    return;
                }
                int sleepIndex = animName.indexOf(AnimPromptConnector.SLEEP_DELIM);
                if (sleepIndex == -1) {
                    AnimPromptConnector.this.playAnim(animName);
                } else {
                    final String realName = animName.substring(0, sleepIndex);
                    String sleepTimeStr = animName.substring(sleepIndex + AnimPromptConnector.SLEEP_DELIM.length());
                    long sleepTime = Long.parseLong(sleepTimeStr);
                    ScheduledThreadPoolExecutor s = new ScheduledThreadPoolExecutor(1);
                    s.schedule(new Runnable(){

                        @Override
                        public void run() {
                            AnimPromptConnector.this.playAnim(realName);
                        }
                    }, sleepTime, TimeUnit.MILLISECONDS);
                }
            }
        });
        this.myPromptProducer.start();
        return true;
    }

    private void playAnim(String animName) {
        RemoteAnimationPlayerClient player = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (player == null) {
            theLogger.info("No player set, unable to play: " + animName);
            return;
        }
        theLogger.info("Received Anim Prompt: " + animName);
        VersionProperty p = new VersionProperty(animName, "1.0");
        Animation anim = this.myLibrary.getAnimation(p);
        if (anim == null) {
            animName = animName.toLowerCase();
            p = new VersionProperty(animName, "1.0");
            anim = this.myLibrary.getAnimation(p);
        }
        if (anim == null) {
            animName = animName.toUpperCase();
            p = new VersionProperty(animName, "1.0");
            anim = this.myLibrary.getAnimation(p);
        }
        if (anim == null) {
            theLogger.info("No anim found for: " + animName);
            this.restartDefs();
            return;
        }
        if (this.myPlayerSource == null) {
            theLogger.info("No player set, unable to play: " + animName);
            return;
        }
        theLogger.info("Playing animation: " + animName);
        if (anim.getChannels().size() > 10) {
            this.stop("FACE");
            this.stop("LEGS");
        }
        this.stop("ARMS");
        player.playAnimation(anim);
        this.waitRestart(anim.getLength() + 1500L);
    }

    public void stop() {
        this.myPromptProducer.stop();
        this.myPromptConnect.disconnect();
    }

    public void setPlayerSource(Source<RemoteAnimationPlayerClient> playerSource) {
        this.myPlayerSource = playerSource;
    }

    private void waitRestart(final long time) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AnimPromptConnector.this.restartDefs();
            }
        }).start();
    }

    private ProducerNode<ServiceCommand> buildSpeechRecChain(Session session, Destination dest) {
        try {
            return JMSAvroUtils.buildEventReceiverChain(ServiceCommandRecord.class, (Schema)ServiceCommandRecord.SCHEMA$, (Adapter)new EmptyAdapter(), (Session)session, (Destination)dest);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error connecting to Anim Prompt.", ex);
            return null;
        }
    }

    public AnimationLibrary getValue() {
        return this.myLibrary;
    }

    private void startDefs() {
        for (String s : this.defAnims) {
            this.loop(s);
        }
    }

    private void restartDefs() {
        RemoteAnimationPlayerClient p = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (this.myLibrary == null || p == null) {
            return;
        }
        for (VersionProperty prop : this.myLibrary.getAnimationVersions()) {
            if (this.defAnims.contains(prop.getName())) continue;
            Animation a = this.myLibrary.getAnimation(prop);
            p.stopAnimation(a);
        }
        this.startDefs();
    }

    private void loop(String anim) {
        RemoteAnimationPlayerClient p = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (this.myLibrary == null || p == null) {
            return;
        }
        Animation legs = this.myLibrary.getAnimation(new VersionProperty(anim, "1.0"));
        if (legs != null) {
            p.loopAnimation(legs);
        }
    }

    private void stop(String anim) {
        RemoteAnimationPlayerClient p = (RemoteAnimationPlayerClient)this.myPlayerSource.getValue();
        if (this.myLibrary == null || p == null) {
            return;
        }
        Animation legs = this.myLibrary.getAnimation(new VersionProperty(anim, "1.0"));
        if (legs != null) {
            p.stopAnimation(legs);
        }
    }
}

