/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.lang.StringUtils;

public class PlayerClientComboBoxModel
extends DefaultComboBoxModel {
    private List<String> myEntries;
    private String selected;
    private Preferences myPrefs = Preferences.userRoot().node("org.robokind.demo.animation");

    public PlayerClientComboBoxModel() {
        String histString = this.myPrefs.get("ip_history", "127.0.0.1");
        String[] history = histString.split("\u00a4");
        this.myEntries = new ArrayList<String>();
        this.myEntries.addAll(Arrays.asList(history));
        this.selected = !this.myEntries.isEmpty() ? this.myEntries.get(0) : null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!this.myEntries.contains(anItem.toString())) {
            this.myEntries.add(anItem.toString());
            String history = StringUtils.join(this.myEntries, (String)"\u00a4");
            this.myPrefs.put("ip_history", history);
        }
        this.selected = anItem.toString();
        this.fireContentsChanged(this, 0, this.myEntries.size() - 1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        return this.myEntries.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.myEntries.isEmpty()) {
            return null;
        }
        return this.myEntries.get(index);
    }

    public void clear() {
        this.myEntries = new ArrayList<String>();
        this.selected = "";
        this.myPrefs.put("ip_history", "");
    }
}

