/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.friendularity.bundle.ui.swing.animation.AnimationPanel;
import org.jflux.api.core.Source;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;

public class AnimationListPanel
extends JPanel {
    private static final Border theBorder = new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY);
    private SortedSet<AnimationPanel> myAnimationJobPanels;
    private Map<Animation, AnimationPanel> myAnimationJobMap;
    private Source<RemoteAnimationPlayerClient> myPlayerSource;
    private PlayerSource myIndirectSource;
    private List<String> myFilters;
    private SortedSet<AnimationPanel> myFilteredAnimationJobPanels;
    private JTextField jTextField1;
    private JPanel myAnimationJobsPanel;
    private JScrollPane myAnimationJobsScrollPane;

    public AnimationListPanel() {
        this.initComponents();
        this.myAnimationJobPanels = new TreeSet<AnimationPanel>();
        this.myAnimationJobMap = new HashMap<Animation, AnimationPanel>();
        this.myAnimationJobsPanel.setLayout(new BoxLayout(this.myAnimationJobsPanel, 1));
        this.myIndirectSource = new PlayerSource();
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AnimationListPanel.this.jTextField1KeyReleased(evt);
            }
        });
    }

    public void setSource(Source<RemoteAnimationPlayerClient> playerSource) {
        this.myPlayerSource = playerSource;
    }

    public void addAnimation(Animation anim) {
        this._addAnimation(anim);
    }

    public void addAnimations(List<Animation> anims) {
        for (Animation anim : anims) {
            this._addAnimation(anim);
        }
    }

    private void _addAnimation(Animation anim) {
        if (anim == null) {
            return;
        }
        if (this.myAnimationJobMap.containsKey(anim)) {
            return;
        }
        AnimationPanel panel = new AnimationPanel();
        panel.setBorder(theBorder);
        panel.setAnimation(anim);
        panel.setPlayerSource(this.myIndirectSource);
        this.myAnimationJobMap.put(anim, panel);
        this.myAnimationJobPanels.add(panel);
        this.filterCache();
    }

    public void clearAnimations() {
        RemoteAnimationPlayerClient player = this.myIndirectSource.getValue();
        this.myAnimationJobPanels.clear();
        this.myAnimationJobsPanel.removeAll();
        if (player != null) {
            for (Animation anim : this.myAnimationJobMap.keySet()) {
                player.stopAnimation(anim);
            }
        }
        this.myAnimationJobMap.clear();
        this.filterCache();
    }

    public void jTextField1KeyReleased(KeyEvent evt) {
        this.setFilters(this.jTextField1.getText());
    }

    public void setFilters(String filterStr) {
        String[] filters;
        this.myFilters = new ArrayList<String>();
        for (String s : filters = filterStr.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            this.myFilters.add(s);
        }
        this.filterCache();
    }

    private void filterCache() {
        if (this.myFilters == null || this.myFilters.isEmpty()) {
            this.myFilteredAnimationJobPanels = this.myAnimationJobPanels;
            this.refresh();
            return;
        }
        this.myFilteredAnimationJobPanels = new TreeSet<AnimationPanel>();
        for (AnimationPanel thals : this.myAnimationJobPanels) {
            if (!this.filterList(thals)) continue;
            this.myFilteredAnimationJobPanels.add(thals);
        }
        this.refresh();
    }

    private boolean filterList(AnimationPanel thals) {
        String s = thals.getAnimationName();
        for (String f : this.myFilters) {
            Pattern p = Pattern.compile(".*" + f + ".*", 40);
            if (s == null || !p.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    private void refresh() {
        this.myAnimationJobsPanel.removeAll();
        for (AnimationPanel p : this.myFilteredAnimationJobPanels) {
            this.myAnimationJobsPanel.add(p);
        }
        this.myAnimationJobsPanel.revalidate();
    }

    private void initComponents() {
        this.myAnimationJobsScrollPane = new JScrollPane();
        this.myAnimationJobsPanel = new JPanel();
        this.jTextField1 = new JTextField();
        this.myAnimationJobsScrollPane.setBorder(null);
        GroupLayout myAnimationJobsPanelLayout = new GroupLayout(this.myAnimationJobsPanel);
        this.myAnimationJobsPanel.setLayout(myAnimationJobsPanelLayout);
        myAnimationJobsPanelLayout.setHorizontalGroup(myAnimationJobsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 278, Short.MAX_VALUE));
        myAnimationJobsPanelLayout.setVerticalGroup(myAnimationJobsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 320, Short.MAX_VALUE));
        this.myAnimationJobsScrollPane.setViewportView(this.myAnimationJobsPanel);
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationListPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myAnimationJobsScrollPane).addComponent(this.jTextField1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myAnimationJobsScrollPane, -1, 314, Short.MAX_VALUE)));
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    class PlayerSource
    implements Source<RemoteAnimationPlayerClient> {
        PlayerSource() {
        }

        public RemoteAnimationPlayerClient getValue() {
            if (AnimationListPanel.this.myPlayerSource == null) {
                return null;
            }
            return (RemoteAnimationPlayerClient)AnimationListPanel.this.myPlayerSource.getValue();
        }
    }
}

