/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.ui.swing.animation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.impl.services.rk.lifecycle.ManagedService;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.lifecycle.AnimationPlayerClientLifecycle;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.impl.animation.messaging.AnimationRecord;
import org.robokind.impl.animation.messaging.AnimationSignallingRecord;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.impl.animation.messaging.PortableAnimationSignal;
import org.robokind.impl.messaging.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroMessageSenderLifecycle;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.messaging.utils.ConnectionUtils;

public class AnimConnector
implements Source<RemoteAnimationPlayerClient> {
    private static final Logger theLogger = Logger.getLogger(AnimConnector.class.getName());
    private AnimationPlayerClientLifecycle myLifecycle;
    private ManagedService myPlayerService;
    private ManagedService mySenderService;
    private ManagedService myConnectionService;
    private ManagedService mySessionService;
    private ManagedService myReceiverService;
    private JMSAvroMessageSenderLifecycle mySenderLife;
    private Connection myConnection;
    private String myAnimDestString;
    private int myAnimDestType;
    private boolean myStartFlag;
    private Source<String> myIPSource;

    public AnimConnector(Source<String> ipSource, String animDestStr, Integer animDestType) {
        this.myIPSource = ipSource;
        this.myStartFlag = false;
        this.myAnimDestString = animDestStr != null ? animDestStr : "animationRequest";
        this.myAnimDestType = animDestType != null ? animDestType : 0;
    }

    public synchronized boolean connect() {
        if (this.myStartFlag) {
            return true;
        }
        BundleContext context = OSGiUtils.getBundleContext(Animation.class);
        String ip = (String)this.myIPSource.getValue();
        this.myConnection = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)("tcp://" + ip + ":5672"));
        try {
            this.myConnection.start();
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to connect to {0}", ip);
            return false;
        }
        this.myConnectionService = new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)this.myConnection, Connection.class));
        this.myConnectionService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteAnimConnection", (Connection)this.myConnection, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationRequest", this.myAnimDestString, this.myAnimDestType, null});
        this.mySenderLife = new JMSAvroMessageSenderLifecycle((Adapter)new PortableAnimationEvent.MessageRecordAdapter(), AnimationEvent.class, AnimationRecord.class, "remoteAnimSender", "remoteAnimConnection", "remoteAnimationRequest");
        this.registerEventFactory(context);
        this.mySenderService = new OSGiComponent(context, (ServiceLifecycleProvider)this.mySenderLife);
        this.mySenderService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteSignalConnection", (Connection)this.myConnection, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationSignal", "animationSignal", 1, null});
        JMSAvroAsyncReceiverLifecycle receiverLife = new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableAnimationSignal.RecordMessageAdapter(), AnimationSignal.class, AnimationSignallingRecord.class, AnimationSignallingRecord.SCHEMA$, "remoteSignalReceiver", "remoteSignalConnection", "remoteAnimationSignal");
        this.myReceiverService = new OSGiComponent(context, (ServiceLifecycleProvider)receiverLife);
        this.myReceiverService.start();
        this.myLifecycle = new AnimationPlayerClientLifecycle("remotePlayer", "remotePlayer", "remoteAnimSender", "remoteSignalReceiver", context);
        this.myPlayerService = new OSGiComponent(context, (ServiceLifecycleProvider)this.myLifecycle);
        this.myPlayerService.start();
        this.myStartFlag = true;
        return true;
    }

    private void registerEventFactory(BundleContext context) {
        if (OSGiUtils.serviceExists((BundleContext)context, AnimationEvent.AnimationEventFactory.class, null).booleanValue()) {
            return;
        }
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableAnimationEvent.Factory(), AnimationEvent.AnimationEventFactory.class)).start();
    }

    public synchronized void stop() {
        if (this.myPlayerService != null) {
            this.myPlayerService.dispose();
            this.myPlayerService = null;
        }
        if (this.mySenderService != null) {
            this.mySenderService.dispose();
            this.mySenderService = null;
        }
        if (this.myConnectionService != null) {
            this.myConnectionService.dispose();
            this.myConnectionService = null;
        }
        if (this.mySessionService != null) {
            this.mySessionService.dispose();
            this.mySessionService = null;
        }
        try {
            this.myConnection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.myStartFlag = false;
    }

    public RemoteAnimationPlayerClient getValue() {
        if (this.myLifecycle == null) {
            return null;
        }
        return (RemoteAnimationPlayerClient)this.myLifecycle.getService();
    }
}

